#/bin/sh

. ./_clfsset.sh

APPNAME=glibc
VER=2.19
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr glibc-build

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

cp timezone/Makefile{,.orig}
sed 's/\\$$(pwd)/`pwd`/' timezone/Makefile.orig > timezone/Makefile

mkdir -p ../glibc-build
cd ../glibc-build

echo "libc_cv_ssp=no" > config.cache

echo Configuring...
BUILD_CC="gcc" CC="${CLFS_TARGET}-gcc ${BUILD32}" \
    AR="${CLFS_TARGET}-ar" RANLIB="${CLFS_TARGET}-ranlib" \
    ../glibc-$VER/configure --prefix=/tools \
    --host=${CLFS_TARGET32} --build=${CLFS_HOST} \
    --disable-profile --enable-kernel=2.6.32 \
    --with-binutils=/cross-tools/bin --with-headers=/tools/include \
    --enable-obsolete-rpc --cache-file=config.cache \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr glibc-build

echo Done.

