#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=gettext
VER=0.19.1
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR
cd gettext-tools

echo "gl_cv_func_wcwidth_works=yes" > config.cache

echo Configuring...
./configure --prefix=/tools \
    --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --disable-shared --cache-file=config.cache \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make -C gnulib-lib \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
make -C src msgfmt msgmerge xgettext \
	1>> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
cp -v src/{msgfmt,msgmerge,xgettext} /tools/bin \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir

echo Done.

