#/bin/sh

CHAP=6
TARGET=kernfs

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

mkdir -pv $LFS/{dev,proc,sys,run}

mknod -m 600 $LFS/dev/console c 5 1
mknod -m 666 $LFS/dev/null c 1 3

mount -v --bind /dev $LFS/dev

mount -vt devpts devpts $LFS/dev/pts -o gid=5,mode=620
mount -vt proc proc $LFS/proc
mount -vt sysfs sysfs $LFS/sys
mount -vt tmpfs tmpfs $LFS/run

if [ -h $LFS/dev/shm ]; then
  mkdir -pv $LFS/$(readlink $LFS/dev/shm)
fi

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/_lfstime.txt

###
mkdir -pv /mnt/lfs/etc
cp -p /etc/lfs-release /mnt/lfs/etc
sed -i 's/$/(chroot)/' /mnt/lfs/etc/lfs-release

echo Done.

