﻿using System;
using System.Text;
using System.Linq;
using System.Collections.Generic;
using System.IO;


using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.API.Config;
using Vintagestory.API.Datastructures;

namespace AdminToolkit
{
	/// <summary>
	/// Admininstrators toolkit Mod system
	/// </summary>
	/// <remarks>
	/// Boilerplate; all Functions in 'ATK_BasicFeatures.cs'
	/// </remarks>
	public partial class AdminToolkit : ModSystem
	{
		/* Things it should do:
		 * ==============
		 * [DONE] Server RULES Printout {richtext / multi-linugual }
		 * [DONE] Optional: ACCEPTANCE / REJECT of server rules {changes players role}
		 * [DONE] List all Admins (online or offline) & track last logoff date
		 * [DONE] Keeps track of Elapsed game calendar days for players
		 * [DONE] Alter ADMIN text to look 'different' (optional)
		 * [DONE] Cyclic automatic Backups
		 * [WIP} Broadcast messages, on a schedule ??????
		 * [???] Custom Server name : custom formats to indicate server state/time/things
		 * [IDEA]: Player VIRTUAL (temp) Inventory; Move Player inventory to alternate [world] D.B. as Inventory backup
		 * [WIP]: Variable Player (re)Spawn points from a list ~ at random
		 * 
		 * WORKAROUND -- Localized messages are by SERVERS Native Language code...Not the players...
		 */

		private ICoreAPI API { get; set; }
		private ICoreServerAPI ServerAPI { get; set; }

		internal readonly string[] adminPriviledges = {
				Privilege.buildblockseverywhere,
				Privilege.useblockseverywhere,
				Privilege.gamemode,
				Privilege.pickingrange,
				Privilege.kick,
				Privilege.ban,
				Privilege.whitelist,
				Privilege.setwelcome,
				Privilege.announce,
				Privilege.readlists,
				Privilege.give,
				Privilege.setspawn,
				Privilege.controlserver,
				Privilege.tp,
				Privilege.time,
				Privilege.grantrevoke,
				Privilege.root,
				Privilege.commandplayer,
			};

		internal const string _lastLoginKey = @"LastLogin";
		internal const string _lastGameDayCountKey = @"LastDayCount";
		internal const string _configFilename = @"admintoolkit.json";

		internal static List<string> AdminRoles;	

		public AdminToolkit( )
		{
			
		}

		/// <summary>
		/// Gets or sets the cached configuration.
		/// </summary>
		/// <value>The cached configuration.</value>
		internal AdminModConfig CachedConfiguration {
			get {				
				return ( AdminModConfig )ServerAPI.ObjectCache[_configFilename];
			}
			set {
				ServerAPI.ObjectCache.Add(_configFilename, value);
			}
		}

		public override bool ShouldLoad(EnumAppSide forSide)
		{
			return forSide.IsServer( );
		}

		public override void StartServerSide(ICoreServerAPI api)
		{
			base.StartServerSide(api);

			Mod.Logger.Notification("Starting Administrators Toolkit mod");

			this.API = api;
			this.ServerAPI = API as ICoreServerAPI;

			PopulateAdminRoleTable( );
			PrepareServersideConfig( );

			MultiLang.Load(Mod.Logger, ServerAPI.Assets, Mod.Info.ModID);


			if (this.CachedConfiguration.RuleRoleChangerEnabled) { this.ServerAPI.RegisterCommand(new RulesCommand(this.ServerAPI)); }
			this.ServerAPI.RegisterCommand(new AdminListingCommand(this.ServerAPI) );
			this.ServerAPI.RegisterCommand(new BackupCycleCommand(this.ServerAPI) );
			//this.ServerAPI.RegisterCommand(new BannerControl(this.ServerAPI));
			this.ServerAPI.RegisterCommand(new PingerCommand(this.ServerAPI));
			if (this.CachedConfiguration.VariableSpawnpoints) { this.ServerAPI.RegisterCommand(new VariableSpawnpoints(this.ServerAPI)); }

			if (CachedConfiguration.BoomingVoice) {
				this.ServerAPI.Event.PlayerChat += BoomingVoiceOfAuthority;
			}

			this.ServerAPI.Event.PlayerNowPlaying += WelcomeMessage;


			this.ServerAPI.Event.ServerRunPhase(EnumServerRunPhase.Shutdown, SaveConfigSettings);
		}



}
}

