﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Vintagestory.API;
using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.API.Client;
using Vintagestory.API.Config;
using Vintagestory.API.MathTools;

using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace ArmourMod
{
	public class ArmourModHookin: ModSystem
	{
		private static string _domain = @"armourmod";
		private static string _thirdPersonKey = @"thirdPersonTransform";

		public override double ExecuteOrder()
		{
			return 1.1D;
		}

		public override bool AllowRuntimeReload()
		{
			return false;
		}

		public override bool ShouldLoad(EnumAppSide forSide)
		{
			return true;
		}

		public override void Start(ICoreAPI api)
		{
			//Both Server parts and Client part(s)
			base.Start(api);
			var entityPlayerClassName = api.ClassRegistry.GetEntityClassName( typeof(EntityPlayer) );
			api.RegisterEntity( entityPlayerClassName, typeof(EntityArmourPlayer) );// class swap 'EntityPlayer'
			api.World.Logger.Debug("Replaced EntityPlayer with Armour version");
		}

		public override void StartClientSide(ICoreClientAPI ClientApi)
		{									
			ClientApi.Event.BlockTexturesLoaded += () => {
			ClientApi.Logger.VerboseDebug( "Armour Mod Populate Armoury, Attach Renderers " );

			var armorData = PopulateArmoury( ClientApi );
			ArmourMeshRenderer theOne = new ArmourMeshRenderer(ClientApi, armorData );

			//#if RENDER
			ClientApi.Logger.VerboseDebug( "Registering Renderers for Armour");
			ClientApi.Event.RegisterRenderer(theOne, EnumRenderStage.Opaque,this.Mod.Info.Name);
			ClientApi.Event.RegisterRenderer(theOne, EnumRenderStage.ShadowFar,this.Mod.Info.Name);
			ClientApi.Event.RegisterRenderer(theOne, EnumRenderStage.ShadowNear,this.Mod.Info.Name);      
			//#endif
			};

		}

		/// <summary>
		/// Populates the Cached data for Rendering.
		/// </summary>
		/// <returns>The armoury.</returns>
		/// <param name="ClientApi">Client API.</param>
		private Dictionary<AssetLocation,ArmourModelData> PopulateArmoury( ICoreClientAPI ClientApi)
		{			
			var Armoury = new Dictionary<AssetLocation, ArmourModelData>( );

			//armourmod:clothes-upperbodyover-vest-leather
			//armourmod:item-clothes-upperbodyover-vest-leather
			//var armourLocations = ClientApi.Assets.GetLocations( "itemtypes/wearable", _domain );
			var armourAssets = ClientApi.World.AssetManager.GetMany("itemtypes/wearable",_domain,true);
			//ClientApi.Assets.GetMany


			//BRUTE FORCE SEARCH!
			var armourItemsBrute = ClientApi.World.Items.Where( itm => itm.Code != null && itm.Code.BeginsWith( _domain, "clothes" ));
			ClientApi.Logger.VerboseDebug( "****************************************************** " );
			ClientApi.Logger.VerboseDebug( "Known Armour variants: {0}", armourItemsBrute.Count() );
			ClientApi.Logger.VerboseDebug( "****************************************************** " );


			foreach(var armourItem in armourItemsBrute)
			{		
				if ( armourItem.IsMissing || armourItem.Attributes == null ) {
					ClientApi.Logger.Error( "Armour item MISSING / NULL ATTRIBUTES {0} !", armourItem.Code.ToShortString( ) );
					continue;
				}

				//MeshRef armourMeshRef = ClientApi.TesselatorManager.GetDefaultItemMeshRef(armour);				
				MeshData armourMesh;
				ClientApi.Tesselator.TesselateItem( armourItem, out armourMesh );

				if ( armourMesh == null ) {
					ClientApi.Logger.Error( "Tesselator did not return mesh! {0}", armourItem.Code.ToShortString( ) );
					continue;
				}
				var armourMeshRef = ClientApi.Render.UploadMesh(armourMesh);
				var textureId = ClientApi.ItemTextureAtlas.Positions[armourItem.FirstTexture.Baked.TextureSubId].atlasTextureId;

				ModelTransform fudge_transform = new ModelTransform()
				{//TODO: Better defaults!
					Translation = new Vec3f(-0.34f, -0.5f, -0.6f),
					Rotation = new Vec3f(0, 0, -87),
					Scale = 0.65f
					//Origin - from root cube, as what?
				};						

				//thirdPersonTransform <- not an 'Attribute'!
				//Manual fetch by JSON parsing....

				if ( armourAssets != null && armourAssets.Count > 0 ) {				
					string partialName = armourItem.Code.GetName( ).Substring(0, armourItem.Code.GetName( ).LastIndexOf( "-" ) );

					var originAsset = armourAssets.Single( armA => armA.Name.StartsWith( partialName ) );

					//System.Diagnostics.Debugger.Break();
					JObject originalJson = JObject.Parse(originAsset.ToText());	

					if ( originalJson.HasValues ) {
						var tpJsonNode = originalJson[_thirdPersonKey];
						//Token.C.SelectToken( @"$.thirdPersonTransform" );
						//if ( tpJsonNode != null )
						//	ClientApi.Logger.VerboseDebug("TP SPAM:"+ tpJsonNode.ToString( ) );


						ModelTransform configuredTransform = new JsonObject( tpJsonNode ).AsObject<ModelTransform>( );
						fudge_transform = configuredTransform;
						ClientApi.Logger.VerboseDebug( "[{0}] Using JSON Transform parameters = {1}", armourItem.Code.ToShortString( ),configuredTransform.Translation.ToString() );
					}

				} else {
					ClientApi.Logger.VerboseDebug( "Json Armour data unloadable !" );
				}

				Armoury.Add(armourItem.Code,new ArmourModelData(armourMeshRef, textureId, fudge_transform, fudge_transform.Origin));
				ClientApi.Logger.VerboseDebug( "Add Armoury entry: {0}", armourItem.Code.ToShortString() );
			}

			return Armoury;
		}
	}
}

