var folderPath = "D:/Rounded M+/SourceForge/mplus_outline_fonts/svg.d";
var continueName = "";
var overWrite = false;

var continueFlag = false;
var activeFileName = "";
var activeFullName = "";
var familyName = "";

function selectWakusen()
{
    var i;

    //uhꂽpX̃bN
    var blendItems = app.activeDocument.pluginItems;
    for (i=0; i<blendItems.length; i++){
        if (blendItems[i].locked == true){
            blendItems[i].locked = false;
        }
    }
    var groupItems = app.activeDocument.groupItems;
    var mosttop = -1; //Illustrator CS5͎AvƃXNvgōWlقȂAXNvgmax͎AvminȂ̂łȕϐ
    var mostindex = -1;
    for (i=0; i<groupItems.length; i++){
        //O[vꂽpX̃bN
        if (groupItems[i].locked == true){
            groupItems[i].locked = false;
        }
        //YWԏɂO[vT
        if (mosttop < groupItems[i].top){
            mosttop = groupItems[i].top;
            mostindex = i;
        }
    }
    //YWԏɂO[vił͘gjI
    groupItems[mostindex].selected = true;
}

function doSmartRound()
{
    var i;
    var actionName = "SmartRound" + familyName;
    
    switch ( activeFileName )
    {
        case "2010.ai":
            if ( activeFullName.indexOf("latain_monospase1") >= 0 )
            {
                return;
            }
            break;

        case "u3030.ai":
        case "u2598.ai":
        case "u2590.ai":
        case "u2588.ai":
        case "u2580.ai":
        case "u2568.ai":
        case "u2560.ai":
        case "u2558.ai":
        case "u2550.ai":
        case "u2548.ai":
        case "u2540.ai":
        case "u2538.ai":
        case "u2530.ai":
        case "u2528.ai":
        case "u2520.ai":
        case "u2518.ai":
        case "u2510.ai":
        case "u2508.ai":
        case "u2500.ai":
        case "u2300.ai":
        case "u30A0.ai":
        case "u25D8.ai":
        // case "u2778.ai":
        case "2580.ai":
        case "2588.ai":
        case "2590.ai":
        case "2598.ai":
            return;
            
        case "u24E8.ai":
        case "u2770.ai":
        case "u2778.ai":
            actionName += "-Rev";
            break;
            
        case "u24F0.ai":
            if ( activeFullName.indexOf("miscellaneous2") < 0 )
            {
                actionName += "-Rev";
            }
            break;
            
        case "23C8.ai":
        case "u21E8.ai":
        case "u2400.ai":
        case "u2408.ai":
        case "u2410.ai":
        case "u2418.ai":
        case "u2420.ai":
            if ( familyName == "-X" )
            {
                actionName = "SmartRound";
            }
            break;
            
        case "2400.ai":
        case "2408.ai":
        case "2410.ai":
        case "2418.ai":
        case "2420.ai":   // mix
            if ( activeFullName.indexOf("latain_monospase1") >= 0 )
            {
                actionName = "SmartRound-L";
            }
            break;
    }

    app.executeMenuCommand('cut');
    app.executeMenuCommand('selectall');
    app.executeMenuCommand('Path Blend Expand');

    var i, j;

    //uhꂽpX̃bN
    var blendItems = app.activeDocument.pluginItems;
    for (i=0; i<blendItems.length; i++){
        if (blendItems[i].locked == true){
            blendItems[i].locked = false;
        }
    }
    var groupItems = app.activeDocument.groupItems;
    for (i=0; i<groupItems.length; i++){
        //O[vꂽpX̃bN
        if (groupItems[i].locked == true){
            groupItems[i].locked = false;
        }
    }
    // alert (groupItems.length);
    for (i = groupItems.length - 1; i >= 0; i--){
        activeDocument.selection = null;
        if ( i < groupItems.length )
        {
            groupItems[i].selected = true;
            app.doScript(actionName, "Rounded M+");
        }
    }

    var pathItems = app.activeDocument.pathItems;
    for (i=0; i<pathItems.length; i++){
        // pX̃bN
        if (pathItems[i].locked == true){
            pathItems[i].locked = false;
        }
    }
    for (i = pathItems.length - 1; i >= 0; i--){
        activeDocument.selection = null;
        if ( i < pathItems.length )
        {
            if ( !pathItems[i].hidden )
            {
                pathItems[i].selected = true;
                app.doScript(actionName, "Rounded M+");
            }
        }
    }

    app.executeMenuCommand('selectall');
    app.doScript(actionName, "Rounded M+");

    app.executeMenuCommand('pasteInPlace');
}

function getSVGFullName(fullName)
{
    //tH_u/mplusv̕u/roundedvɂāAƂ̃tH_\͓ɂ
    var path = fullName.substr(0, fullName.lastIndexOf('/') + 1);
    var name = fullName.substr(fullName.lastIndexOf('/') + 1);
    return getSVGFolder(path) + getSVGFileName(name);
}

function getSVGFileName(name)
{
    //tH_u/mplusv̕u/roundedvɂāAƂ̃tH_\͓ɂ
    return name.substring(0, name.lastIndexOf('.')) + '.svg';
}

function getSVGFolder(path)
{
    //tH_u/mplusv̕u/roundedvɂāAƂ̃tH_\͓ɂ
    var newDirName = path.toString().replace('/mplus', '/rounded');
    newDirName = newDirName.replace('/svg.d', '/svg' + familyName.toLowerCase() + '.d');
    return newDirName;
}

function saveToSVG()
{
    var currentDoc = app.activeDocument;
    var newFileName = getSVGFileName(currentDoc.name);
    var newDirName = getSVGFolder(currentDoc.path);

    //o̓tH_Ȃ΍
    var newDir = new Folder(newDirName);
    if(! newDir.exists){ newDir.create();}

    var newFile= new File(newDirName + '/' + newFileName);
    //t@Cۑł邩`FbN
    if (newFile.open('w')){
        newFile.close();
    }else{
        throw new Error('Access is denied');
    }

    // SVGExport̂́ASaveAsSVGIԂ̂ƓB܂ۑƎAvŊJĂt@CsvgɂȂ
    // SVG1_0, UTF-8, PRESENTATIONATTRIBUTES ͎w肵ȂM+̃XNvg܂삵ȂB
    var options = new ExportOptionsSVG();
    options.DTD = SVGDTDVersion.SVG1_0;
    options.documentEncoding = SVGDocumentEncoding.UTF8;
    options.cssProperties = SVGCSSPropertyLocation.PRESENTATIONATTRIBUTES;
    options.embedRasterImages = false;
    options.includeFileInfo = false;
    currentDoc.exportFile(newFile, ExportType.SVG, options);
}

function processFolder(fld)
{
    var i;
    var folderRef = new Folder (fld);
    var fileList = folderRef.getFiles("*.ai");

    for (i=0; i<fileList.length; i++)
    {
        activeFullName = fileList[i].fullName;
        activeFileName = fileList[i].name;
        if ( !continueFlag )
        {
            if ( activeFullName.indexOf(continueName) >= 0 )
            {
                continueFlag = true;
            }
            else
            {
                continue;
            }
        }

        if ( !overWrite )
        {
            var file = new File(getSVGFullName(fileList[i].fullName));
            if ( file.exists ) { continue; }
        }

        $.writeln(fileList[i].fsName);

        fileObj = new File(fileList[i].fsName);
        app.open(fileObj);
        app.userInteractionLevel = UserInteractionLevel.DONTDISPLAYALERTS;
        selectWakusen();
        doSmartRound();
        app.userInteractionLevel = UserInteractionLevel.DISPLAYALERTS;
        saveToSVG();
        app.activeDocument.close();
    }

    folderRef = new Folder (fld);
    fileList = folderRef.getFiles("*");
    for (i=0; i<fileList.length; i++)
    {
        if ( fileList[i].name != "_works" && fileList[i].getFiles )
        {
            processFolder(fileList[i].fullName);
        }
    }
}

if ( continueName == "" ) { continueFlag = true; }

familyName = "";
processFolder(folderPath);

familyName = "-X";
processFolder(folderPath);

familyName = "-L";
processFolder(folderPath);
