/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: option.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

// $Header: /cvsroot/jsp4cm3/jsp/cfg/base/option.h,v 1.1 2008/06/17 00:04:36 suikan Exp $

#ifndef OPTION_H
#define OPTION_H

#include "base/testsuite.h"
#include "base/singleton.h"

#include <string>
#include <vector>
#include <map>

#define DEFAULT_PARAMETER "#default"

using namespace std;

/*
 *   IvVp[^ǗNX
 */
class OptionParameter
{
public:
    class OptionItem : public std::string
    {
    protected:
        bool                      checked;  //gpǂ
        std::vector<std::string>  param;    //IvV

    public:
            //RXgN^
        OptionItem(void) throw() : string(DEFAULT_PARAMETER), checked(false) {}
        OptionItem(const std::string & name) throw() : string(name), checked(false) {}
        OptionItem(const OptionItem & src) throw() : string(src), checked(src.checked), param(src.param) {}

            //IvVp[^͂OptionItem𐶐
        static bool createItem(OptionItem & item, string & argv);

            //ʂOptionItemp[^ɒǉ
        void mergeItem(const OptionItem & src);

            //p[^̒ǉ
        inline void addParameter(const std::string & src) throw()
        {   param.push_back(src);   }

            //p[^̎擾
        inline size_t countParameter(void) const throw()
        {   return param.size();    }

            //p[^Ă邩ǂ
        inline bool hasParameter(void) const throw()
        {   return countParameter() != 0;   }

            //ʒuw肵ăp[^Q (ȈʒuƋ󕶎)
        inline std::string operator[](std::vector<std::string>::size_type offset) const throw()
        {
            string result;

            if(offset < countParameter())
                result = param[offset];

            return result;
        }

            //̃IvVgpƂL (OptionParameterĂ̗p݂̂Ȃ̂ "_" Ă)
        inline void _check(void) throw()
        {   checked = true;   }

            //̃IvVɐGǂ
        inline bool isChecked(void) const throw()
        {   return checked;   }

            //Lǂ (ȂȂ͖)
        inline bool isValid(void) const throw()
        {   return !empty();   }

            //ȃIvVACe̐
        static OptionItem createInvalidItem(void) throw();

            //SẴp[^̂擾
        std::string getParameters(std::string punctuator = " ") const throw();

            //p[^̌`FbN
        bool checkParameterCount(size_t count, bool allow_zero = false) const throw();

        TESTSUITE_PROTOTYPE(main)
    };

protected:
        //IvVi[ϐ
    std::map<std::string, OptionItem> container;    //set::begin()const_iteratorԂȂ̂ŎdȂmapɕς (lΓR...)

        //vO
    std::string program_name;

        //R}hCɓnꂽ̂
    std::string cmdline;    

        //ftHgRXgN^ (eXgp)
    OptionParameter(void) throw() {}

        //vf̌o
    std::map<std::string, OptionItem>::iterator _find(const std::string & name, bool check = true) throw();

public:

        //VOgRXgN^
    SINGLETON_CONSTRUCTOR(OptionParameter) throw() {}

        //IvVp[^̃p[X
    bool parseOption(int _argc, char const * const * _argv, char const * _default = NULL) throw();

        //SẴIvVgpꂽǂ̊mF
    bool validateOption(void) const throw();

        //gpȂIvV擾
    std::string getInvalidOptions(void) const throw();

        //ACe̐𐔂
    inline size_t countItem(void) const throw()
    {   return container.size();   }

        //IvVACe̎Q
    OptionItem get(const std::string & name, bool check = true) throw();
    
    inline OptionItem operator [] (const std::string & name) throw()
    {   return get(name);   }
    
    inline OptionItem operator [] (const char * name) throw()
    {   return get(string(name));   }

        //IvV̗Ľo
    inline bool find(std::string name) throw()
    {   return get(name).isValid(); }


        //Qƃ}[N
    inline bool check(const std::string & name) throw()
    {   return _find(name) != container.end();   }

    inline bool check(const char * name) throw()
    {   return check(string(name));   }

        //vO擾
    inline const std::string & getProgramName(void) const throw()
    {   return program_name;    }

        //̂܂܎擾 (vO͊܂܂)
    inline const std::string & getCommandLine(void) const throw()
    {   return cmdline;   }

    TESTSUITE_PROTOTYPE(main)
};

    /* VXeŒPOptionParameter邽߂̊֐ */
inline OptionParameter & getOptionParameter(void) throw()
{   return *Singleton<OptionParameter>::getInstance();   }

#endif


