/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.h,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */


/*
 *  ^[QbgVXeˑW[iIntegratorpj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */


#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <sys_rename.h>

/*
 * ݃nh̍ő吔
 */
#define MAX_INT_NUM 22

/*
 *  vxget_tim T|[g邩ǂ̒`
 */
#define	SUPPORT_VXGET_TIM


/*
 *  VA|[gԍɊւ`
 */
#define TNUM_PORT   2   /* T|[gVA|[g̐ */
#define TNUM_SIOP   2   /* T|[gVAI/O|[g̐ */

/*
 *  VA|[gԍɊւ`
 */
#define LOGTASK_PORTID  1   /* VXeOɗpVA|[gԍ */

/*
 *  ݑ҂Ԃł̎s[`
 */
#ifdef ARM920T_CORE
#define WAIT_INTERRUPT  mcr p15, 0, r3, c7, c0, 4
#else
#define WAIT_INTERRUPT  nop
#endif

/*
 *  vZbT̃GfBA
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE  /* gGfBA */

#ifndef _MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^ďoŎ邱Ƃz肵
 *  ĂD
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^ďoŎ邱
 *  Ƃz肵ĂD
 */
extern void	sys_putc(char c);


/*
 *  ݗp̃e[u
 */
extern FP   int_table[MAX_INT_NUM];


/*
 *  IRQnh(sys_support.S)
 */
extern void IRQ_Handler(void);

/*
 *  ݃nh̏o̐}N
 *
 */
#define INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  ݃nh̐ݒ
 *
 *  ݔԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */
extern void define_inh(INHNO inhno, FP inthdr);




#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
