/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *  VAI/OfoCXiSIOjhCo
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <ns9360.h>


/*
 *  SIOhCȍ[`
 */
#define sio_initialize  uart_initialize

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB  *siopcb;
	BOOL    openflag;

	/*
	 *  I[v|[g邩 openflg ɓǂłD
	 */
	openflag = uart_openflag(siopid);

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = uart_opn_por(siopid, exinf);
	  
	/*
	 * ݊֘A̐ݒ
	 */

	if(!openflag){
		/* ݋FBBus Bridge IE TXERXEONɂ */
		uart_TxRx_Enable(siopid);
	}

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[YD
	 */
	uart_cls_por(siopcb);

	/*
	 *  VAI/O݂}XND
	 */
	if (!uart_openflag(uart_get_id(siopcb))) {
		/* ݋֎~FBBus Bridge IE TXERXEOFFɂ */
		uart_TxRx_Disable(uart_get_id(siopcb));
	}
}


/*
 *  SIO̊݃nh
 */
/*	#define sio_handler uart_isr	*/
#define sio_Tx_handler uart_Tx_isr
#define sio_Rx_handler uart_Rx_isr
#define sio2_Tx_handler uart2_Tx_isr
#define sio2_Rx_handler uart2_Rx_isr
/*
 *  VAI/O|[gւ̕M
 */
#define sio_snd_chr uart_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define sio_ierdy_rcv   uart_ierdy_rcv


#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
