/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *    vZbTˑW[ AZuꕔiARMv4pj
 */
#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"
#include <armv4.h>
#include <t_config.h>
        
/*
 *  ^XNfBXpb`
 *
 *  dispatch́C
 *  dispatch ́CVXe[hE݋֎~ԂŌĂяoȂ΂Ȃ
 *  D_exit_and_dispatch CVXe[hE݋֎~ԂŌĂяo
 *  ̂ł邪CJ[lNɑΉ邽߁CIRQ[hŌĂяo
 *    ꍇɂΉĂD
 */

        .text
        .align 4    
        .globl dispatch
        .globl exit_and_dispatch
dispatch:
        stmfd sp!, {r4 - r11,lr}   /* WX^̕ۑ */
        ldr   r0, =runtsk          /* runtskǂݍ */
        ldr   r1, [r0]
        str   sp, [r1,#TCB_sp]      /* ^XNX^bNۑ */
        adr   r2, dispatch_r
        str   r2, [r1,#TCB_pc]      /* sĊJԒnۑ */
        ldr   r6, =interrupt_count  /* r6 <-interrupt_count */
        mov   r5, #(CPSR_SVC|CPSR_IRQ_BIT)  /* 荞݋֎~(VXe[h) */
        mov   r4, #(CPSR_SVC)               /* 荞݋(VXe[h) */
        b     dispatcher_1

dispatch_r:
        ldmfd sp!,{r4 - r11,lr}
        /*
         * ^XNO[`̋N
         * dispatch_r  dispatcher_1 Ăяo邽߁C
         * tcb̃AhXr1ɓĂ
         */
        ldrb  r0,[r1,#TCB_enatex]
        tst   r0,#TCB_enatex_mask
        beq   dispatch_r_1          /* enatex  FALSE Ȃ烊^[ */
        ldr   r0,[r1,#TCB_texptn]   /* texptn[h               */
        tst   r0,r0                 /* texptn 0Ŗ         */
        bne   call_texrtn           /* ^XNO[`̌Ăяo */
dispatch_r_1:   
        mov   pc,lr        



exit_and_dispatch:
        ldr   r6, =interrupt_count /* interrupt_count0NA */
        mov   r3, #0        
        str   r3, [r6]                                        
        /*
         *  FIQ͏ɋ֎~D
         */
        mov   r5, #(CPSR_SVC|CPSR_IRQ_BIT) /* 荞݋֎~(VXe[h) */
        mov   r4, #(CPSR_SVC)              /* 荞݋(VXe[h) */
        mrs   r0, cpsr                     /* FIQp            */
        and   r0, r0, #CPSR_FIQ_BIT
        orr   r0, r0, r5
        msr   cpsr, r0          /* VXe[h */
dispatcher_1:
        /*
         *  ł̓VXe[hE݋֎~ԂłȂ΂ȂȂD
         */
        ldr   r0, =schedtsk   /* schedtsk ǂݍ */
        ldr   r1, [r0]
        ldr   r2, =runtsk     /* schedtsk  runtsk */
        str   r1, [r2]        /* schedtsk ȂꍇruntskNULL */
        cmp   r1, #0
        beq   dispatcher_2        
dispatcher_3:           
        ldr   sp, [r1,#TCB_sp] /* ^XNX^bN𕜋A */
        ldr   pc, [r1,#TCB_pc] /* sĊJԒn𕜋A   */
dispatcher_2:
        mov   r3,#1
        str   r3, [r6]         /* interupt_count = 1 */
        ldr   sp, =STACKTOP
        /* sleep[hCPUȂ珑 */
        mrs   r0, cpsr        /* FIQp           */
        and   r0, r0, #CPSR_FIQ_BIT
        orr   r0, r0, r4
        msr   cpsr, r0        /* ݑ҂          */
        WAIT_INTERRUPT
        mrs   r0, cpsr        /* FIQp           */
        and   r0, r0, #CPSR_FIQ_BIT
        orr   r0, r0, r5
        msr   cpsr, r0        /* ݋֎~          */        
        mov   r3,#0
        str   r3, [r6]        /* interrupt_count = 0 */   
        b     dispatcher_1


                
/*
 *  ^XNN
 */
        .text
        .globl activate_r
activate_r:
        mov   r1,#(CPSR_SVC|CPSR_FIQ_BIT) /* 荞݋(VXe[h) */
        mrs   r2, cpsr         /* FIQp   */
        and   r2, r2, #CPSR_FIQ_BIT
        orr   r1, r1, r2            
        msr   cpsr, r1         /* ݋ */
        ldr   lr, =ext_tsk     /* ߂Ԓnݒ */
        ldmfd sp!, {r0,pc}     /* ,PCݒ  */


        
/*
 *  ݃nh^CPUOnho
 *
 *  ret_int ̓VXe[hEIRQ݋֎~ԂŌĂяoD
 */
        .text
        .globl ret_int
        .globl ret_exc 
ret_int:
ret_exc:                
        /*
         *   VXe[hŗ邱
         */
        ldr   r2, =runtsk       /* runtsk ǂݍ */
        ldr   r1, [r2]
        ldr   r2, =enadsp
        ldr   r0, [r2]
        cmp   r0, #0
        beq   ret_int_1
        ldr   r2, =schedtsk
        ldr   r0, [r2]
        cmp   r0, r1            /* schedtsk  runtsk r */
        beq   ret_int_1
        stmfd sp!, {r4-r11}     /* c̃WX^ۑ */
        str   sp, [r1,#TCB_sp]  /* ^XNX^bNۑ */
        adr   r0, ret_int_r     /* sĊJԒnۑ   */
        str   r0, [r1,#TCB_pc]
        b     dispatcher_1
ret_int_r:
        ldmfd sp!, {r4-r11}     /* WX^̕A */
ret_int_1:
        /*
         * ^XNO[`̋N
         * dispatch_r  dispatcher_1 Ăяo邽߁C
         * tcb̃AhXr1ɓĂ
         * ret_int_1  ret_exe Ăяo
         */
        ldrb  r0, [r1,#TCB_enatex]
        tst   r0, #TCB_enatex_mask
        beq   ret_int_2              /* enatex  FALSE Ȃ烊^[ */
        ldr   r0, [r1,#TCB_texptn]   /* texptn[h               */
        tst   r0, r0                 /* texptn 0Ŗ         */
        blne  call_texrtn            /* ^XNO[`̌Ăяo */        
ret_int_2:              
        ldmfd sp!, {r0}       /* spsr 𕜋A */
        mrs   r2, cpsr        /* FIQp            */
        and   r2, r2, #CPSR_FIQ_BIT
        and   r0, r0, #~CPSR_FIQ_BIT
        orr   r0, r0, r2              
        msr     spsr, r0              /* ߂cpsrspsrɐݒ */
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /* ^XNɕA ^tȂ̂ŁAcpsr <- spsr */
        
        /*
         *  ԑ҂
         */
	.globl sil_dly_nse
sil_dly_nse:
        sub   r0, r0, #SIL_DLY_TIM1
        cmp   r0, #0
        bgt   _sil_dly_nse1
        movle pc, lr
_sil_dly_nse1:
        sub   r0, r0, #SIL_DLY_TIM2
        cmp   r0, #0
        bgt   _sil_dly_nse1
        movle pc, lr
