/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include <integrator.h>
        
/*
 *  ჌x̃^[QbgVXeˑ̏
 *
 *  X^[gAbvW[̒ŁC̑OɌĂяoD          
 */       

        .text
        .align 2
        .global hardware_init_hook
hardware_init_hook: 

init_done:
        mov     pc, lr


        .text
        .align 2
        .global software_init_hook
software_init_hook:
        mov     pc, lr

        .text
        .align 2
        .global software_term_hook
software_term_hook:
        mov     pc, lr





/*
 *
 *  ݂̏o
 *         
 */        
        .text
        .align 4    
        .global IRQ_Handler
IRQ_Handler:

        /* 
         * ݃[h 
         * 
         * cpsrspsr_irqɕA悪r14_irq(lp)ɓC
         * spsr_irqr14_irqr13(sp)_irq r14,r13ƂȂD
         */

        /* 
         *  ^XN̓쎞[h(X[p[oCU[[h)
         */
        mov   sp,#(CPSR_SVC | CPSR_FIQ_BIT | CPSR_IRQ_BIT) 
        msr   cpsr_all, sp
        stmfd sp!, {r0-r3,ip,lr,pc} /* pc̓_~[ */

 
  
        /*
         * spsrƖ߂Ԓn擾邽߂IRQ[h
         */
        mov   r0,#(CPSR_IRQ | CPSR_FIQ_BIT | CPSR_IRQ_BIT)
        msr   cpsr,r0
        sub   r0,lr,#4
        mrs   r1,spsr
   
        /*
         *  X[p[oCU[[h
         */
        and   r2,  r1, #CPSR_FIQ_BIT /* FIQrbǧp */
        orr   r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)        
        msr   cpsr_all, r2
        str   r0, [sp,#0x18] /* Store pc */
        stmfd sp!,{r1}       /* spsr */


        /*
         *  d荞݂
         */
        ldr     r2, =interrupt_count
        ldr     r3, [r2]
        add     r0,r3,#1
        str     r0, [r2]
        cmp     r3, #0x00

        moveq   r2,sp            /* lXg荞݂łȂꍇ */
        ldreq   sp,=STACKTOP     /* X^bN̕ύX    */
        stmeqfd sp!,{r2}         /* ^XNX^bN̕ۑ */


        /*
         *  荞ݗv̔D
         */
        ldr     r1, =IRQ0_STATUS
        ldr     r2, [r1]
        mov     r0, #31
find_bit_loop:
        mov     r3, r2, asr r0
        tst     r3, #1
        bne     find_bit_end   
        subs    r0, r0, #1
        bpl     find_bit_loop
find_bit_end:
        mov     r3, r0
        ldr     r0,=int_mask_table    /* ݃}XNe[ǔĂяo*/
        ldr     r0,[r0,r3,lsl #2]     /* r0<-݃}XN              */    
        ldr     r1, =IRQ0_ENABLECLR   /* ݃WX^ւ̃Zbg      */
        str     r0,[r1]

        stmfd   sp!, {r0}             /* }XNrbgۑ            */

        
        ldr     r0,  =int_table       /* ݋^e[u̓ǂݏo  */
        ldr     r0,  [r0,r3,lsl #2]   /* r0<-݃nh            */    


        /*
         *  `݂̊`FbN
         */
        cmp     r0, #0x00
        beq     undefined_interrupt
        
        /* 
         * 荞݋ 
         */                
        mrs     r2, cpsr
        and     r2,  r2, #~CPSR_IRQ_BIT /* ݋ */
        msr     cpsr,r2

        /* 
         * Call Handler  
         */        
        mov     lr,  pc   
        mov     pc,  r0

        /* 
         * 荞݋֎~ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #CPSR_FIQ_BIT /* FIQrbǧp */         
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr,r2

        ldmfd   sp!, {r0}                /* }XNrbg̕A */
        ldr     r1,  =IRQ0_ENABLESET        /*荞݋*/
        str     r0,  [r1]

        /* 
         * ݃lXg(interrupt_count) fNg 
         */
        ldr     r2, =interrupt_count
        ldr     r1, [r2]        
        sub     r3, r1, #1                        
        str     r3, [r2]
        cmp     r3, #0x00        
        bne     return_to_task_irq
        
        /* 
         * ^XNX^bN̕A 
         */
        ldmfd   sp!,{r0}         
        mov     sp, r0        
                
        ldr     r1, =reqflg    /* Check reqflg */
        ldr     r0, [r1]
        cmp     r0, #0
        beq     return_to_task_irq
        mov     r0, #0
        str     r0, [r1]       /* Clear reqflg */
        b       ret_int

return_to_task_irq:
        /*
         *  A
         *  荞݋ƂȂ邪^XNReLXgɕۑĂ邽߁C
         *  ͂Ȃ
         */
        ldmfd   sp!,{r1}           /* CPSR̕A */
        mrs     r2, cpsr           /* FIQp            */
        and     r2, r2, #CPSR_FIQ_BIT
        and     r1, r1, #~CPSR_FIQ_BIT
        orr     r1, r1, r2                 
        msr     spsr, r1              /* ߂cpsrspsrɐݒ */
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /* ^XNɕA ^tȂ̂ŁAcpsr <- spsr */        

        /*
         *  `݂̊ƂɌĂяo
         */    
undefined_interrupt:
         b      undef_interrupt
    

