/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */
                
/*
 *    J[lp̃X^[gAbvW[(ARMv4p)
 */
#define _MACRO_ONLY
#include <armv4.h>
#include <sys_defs.h>
        
#include <t_config.h>
 


        /*
         * Vectore[uƃWve[u
         * TCY͍v0x3c
         */
        .section .vector,"a"
        .code 32
        .align 0
        .global vector_table
vector_table:
        ldr pc, reset_vector       /* Zbg             */
        ldr pc, undef_vector       /* `           */
        ldr pc, swi_vector         /* \tgEFA   */
        ldr pc, prefech_vector     /* vtFb`A{[h */
        ldr pc, data_abort_vector  /* f[^A{[h       */
        ldr pc, reset_vector
        ldr pc, irq_vector         /* IRQ                  */
        ldr pc, fiq_vector         /* IRQ                  */

/*
 *  xN^[e[u
 */
reset_vector:
        .long   start
undef_vector:
        .long   undef_exception
swi_vector:
        .long   swi_exception
prefech_vector:
        .long   prefetch_exception
data_abort_vector:
        .long   data_abort_exception
irq_vector:
        .long   irq_exception
fiq_vector:
        .long   fiq_exception




        .text
        .code 32
        .align     0
        .global    start
start:
        mov  r1,  #(CPSR_SVC|CPSR_FIQ_BIT|CPSR_IRQ_BIT) /* To System mode */
		msr  cpsr, r1

        /*
         * X^bN|C^ƁCt[|C^̏
         * SL(X^bNWX^r10)͐ݒ肷Kv邩?
         * gcc̓fBtHgł-mapcsȂ̂ŕKvȂ
         */
        ldr  r3, =STACKTOP
        mov  sp, r3
        mov  r11, #0        /* Arm[hpt[|C^   */         
        mov  r7, #0         /* Thubm[hpt[|C^ */

        /*
         * hardware_init_hooǩĂяo i0łȂꍇj
         *
         * ^[Qbgn[hEFAɈˑĕKvȏꍇ
         * ́Chardware_init_hook Ƃ֐pӂ
         */
        ldr  r0, =hardware_init_hook
        cmp  r0, #0x00
        blne hardware_init_hook


        /*
         *  bssZNṼNA
         */        
start_1:
        ldr  r1, =__bss_start
        ldr  r2, =__bss_end
        cmp  r1,r2
        bhs  start_3
        mov  r0,#0
start_2:
        str  r0,[r1],#4
        cmp  r1, r2
        blo  start_2
        
        /*
         *  dataZNV̏(ROMΉ)
         *  __idata_start  __idata_end ܂łC__data_start ȍ~
         *  Rs[
         */
start_3:
#if 0
        ldr  r1, =__idata_start
        ldr  r3, =__idata_end
        cmp  r1, r3
        bhs  start_5
        ldr  r2, =__data_start
start_4:        
        ldr  r0, [r1],#4
        str  r0, [r2],#4
        cmp  r1, r3
        blo  start_4
#endif
        
        /*
         *  software_init_hook ďoi0 łȂꍇj
         *
         *  \tgEFAiɃCujɈˑĕKvȏ
         *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
         *  悢D
         */
start_5:
        ldr   r0, =software_init_hook
        cmp   r0, #0x00
        blne  software_init_hook

start_6:        
        bl    kernel_start
