/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.6 2008/08/03 06:06:48 suikan Exp $
 */

/*
 *	^C}hCoiCQ-STARMpj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
//#include <dve68k_dga.h>

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER	1	CM3NI // STM32F103̃^C}荞݃nh̃xN^ԍt邱ƁB1͂Ƃ肠B

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UW	CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *
 *  CQ_STARM{[hł́C^C}1/72ʕbɃJEgAbvD
 *  ȂASYSTICK_CURRENT_VALUE̓_EJE^Ȃ̂ŁATO_USEC̃}CNb1000lɂB
 */
#define	TO_CLOCK(nume, deno)	(72000 * (nume) / (deno))
#define	TO_USEC(clock)		(1000- (clock) / 72)	


/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define	GET_TOLERANCE	7200	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ^C}~܂ł̎ԁinsecPʁj
 *
 *  lɍ͂ȂD
 */
#define	TIMER_STOP_DELAY	14400


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
	*(volatile UW*)0xE000E010 = 0;			/* SYSTIC Control Reg, initialize */
	*(volatile UW*)0xE000E014 = 72000 - 1;	/* SYSTIC Reload reg. assume clock is 72MHz. generate every 1mS interrupt*/

	*(volatile UW*)0xE000E010 = 0x07;		/* SYSTIC Control Reg. Enable Counting, Multi-shot, interrernal clock source */

}

/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
	CM3NI
/*
 * CORTEX-M3 TRM ɂ ARMv7M ALARM ɂSYSTICK荞݂̃NA@ĂȂB
 */
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
hw_timer_terminate()
{
	/*
	 *  ^C}̓~D
	 */
	*(volatile UW*)0xE000E010 = 0;			/* SYSTIC Control Reg, initialize */
}

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
hw_timer_get_current()
{
	return ( *(volatile UW*)0xE000E018 );	/* SYSTICK current Value register */
}

/*
 *  ^C}ݗṽ`FbN
 * 荞݂vĂȂTRUE
 */
Inline BOOL
hw_timer_fetch_interrupt()
{
	CM3NI
	return(0);		/* CORTEX-M3 TRM ǂłASYSTICKPendԂǂׂ΂̂킩Ȃ */
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
