/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2008 by TOPPERS/JSP for CORTEX-M3 project
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: start.S,v 1.14 2008/07/31 12:39:26 suikan Exp $
 */

/*
 *	J[lp̃X^[gAbvW[iCORTEX-M3pj
 */

#define	_MACRO_ONLY
#include <t_config.h>

		/*
		* CORTEX-M3 ZbgExNg
		*
		* VXeEX^[gɎQƂ4Gg̃xNgB
		* CORTEX-M3 TRM 5.9.1߂Q
		*/
    .section .rodata
    .align 4
    .global vector_table
vector_table:
	.long	__master_stack					/* MSP̏lB */
	.long	start + 1						/* sJnԒnBThumb[hɓ邽߁ALSB1łȂ΂ȂȂ */
	.long	default_nmi_handler +1			/* NMIBThumb[hɓ邽߁ALSB1łȂ΂ȂȂ */
	.long	default_hard_fault_handler + 1	/* n[hEtHgBThumb[hɓ邽߁ALSB1łȂ΂ȂȂ */

	.align 2
	.thumb
	.text
	.globl start
start:
	/*
	 *  vZbT[hƃX^bN|C^̏BCORTEX-M3ł́AɓB_
	 *  MSPɐX^bN̈̍ŏʂ̃AhXݒ肳ĂB
	 */	 
	
			/* 荞݋֎~ԂɕύX */
	cpsid	i					/* 荞݋֎~B lock_cpu ɑ*/
	movw	r0,#0xFF
	msr		basepri,r0			/* BASEPRI = 0xFF : Sx̊荞݂ */
	
			/* X^bN|C^̒lMSPPSPɃRs[ */
	mrs		r0,msp				/* MSP̒l擾 */
	msr		psp,r0				/* PSPɎ擾lZbg */
	
			/* X^bN PSP ɐ؂ւ */
	mrs		r0,control
	mov		r1,#2
	orr		r0,r1				/* CONTROL[1]Thread ModePSPg悤ɂB
								 * CONTROL̓Zbg0ɂ(ARMV7M AAPMRM B1-9 )A
								 * ZbgThread ModeMSPĝŁACONTROL[1]
								 * 1ɂƁAPSPg͂ */
	msr		control,r0
	isb							/* control ւ݂̏Ẑ҂ */
	 
	/*
	 *  hardware_init_hook ̌ďoi0 łȂꍇj
	 *
	 *  ^[Qbgn[hEFAɈˑĕKvȏꍇ
	 *  ́Chardware_init_hook Ƃ֐pӂD
	 */
	ldr r0,=hardware_init_hook +1
	cmp r0,r1					/* AhX1 */
	beq	start_1					/* hardware_init_hook̃AhX1ȂAĂ΂Ȃ */
	blx	r0;

	/*
	 *  bssZNṼNA
	 */
start_1:
	ldr		r0,=__bss_start		/* ̈̊JnAhX */
	ldr		r1,=__bss_end		/* ̈̏IAhX */
	mov		r2,#0
	cmp		r0,r1				/* ̈I ? */
	beq		start_3				/* if yes, finish */
	
start_2:
	strb	r2,[r0]
	add		r0,#1
	cmp		r0,r1				/* ̈I ? */
	bne		start_2				/* if no, repeat again */


	/*
	 *  dataZNV̏iROMΉj
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~
	 *  Rs[D
	 */
start_3:
	ldr		r0,=__idata_start	/* \[Ẍ̊JnԒn */
	ldr		r1,=__idata_end		/* \[Ẍ̏IԒni̎̔Ԓnj */
	ldr		r2,=__data_start	/* fBXeBl[V̈̊JnԒn */
	cmp		r0,r1				/* \[ẌI ? */
	beq		start_5				/* if yes, finish */



start_4:
	ldrb	r3,[r0]				/* \[Xf[^擾 */
	strb	r3,[r2]				/* fBXeBl[VɊi[ */
	add		r0,#1				/* \[XEAhX|C^XV */
	add		r2,#1				/* fBXeBl[VEAhX|C^XV */
	cmp		r0,r1				/* ̈I ? */
	bne		start_4				/* if no, repeat again */

	/*
	 *  software_init_hook ďoi0 łȂꍇj
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */
start_5:
	ldr	r0,=software_init_hook+1
	cmp r0,r1					/* AhX1 */
	beq	start_6					/* hardware_init_hook̃AhX1ȂAĂ΂Ȃ */
	blx	r0;


	/*
	 *  J[lND
	 */
start_6:
	ldr r0,=kernel_start+1
	bx	r0						/* kernel_start()ĂԁBǂ߂ĂȂ̂ blxɂKv͂Ȃ */
