/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Katsuhiro Amano
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  vZbTˑW[iH8pj
 *@@@J[lŎgp`
 *@@@@C֐̎
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include "sil.h"
#include <hw_serial.h>  /*  SCI_putchar_pol()  */

#ifdef SUPPORT_CHG_IPM
/*
 *  ^XNReLXgł̊݃}XN
 */
volatile UB      task_intmask = 0;
#endif /* SUPPORT_CHG_IPM */

/*
 *  ^XNReLXgł̊݃}XN
 */
volatile UB      int_intmask = 0;

/*
 *  ݃lXgJE^
 */
volatile UB      intnest = 0;

/*
 *  CPUbNԂ\tO
 */
volatile BOOL    iscpulocked = TRUE;

/*
 *  ^C}̃vCIeBxݒp̃f[^
 *      {hw_timer.hɋLqׂA
 *      hw_timer.hCN[ht@CłׂĎ̉
 *@@@̈LĂ܂߁Â͂ɋLqB
 */
const IRC TIMER_IRC = {(UB*)SYSTEM_TIMER_IPR,
                        SYSTEM_TIMER_IP_BIT,
                        SYSTEM_TIMER_IPM
};

/*
 *  SYSCȐl
 *      $CPUfBNgŒ`e
 *      @rbg7 SSBY=0Fsleep߂ŃX[v[hֈڍs
 *      @rbg3 UE=1FCCR.UI݃}XNrbgƂėp
 *      @rbg1 1FU[urbg
 *      @rbg0 RAME=1FRAML
 *      $SYSfBNgSYSCR_SYSƂĒ`e
 *      @rbg6-4 STSFX^oCE^C}EZNg
 *      @rbg2 NMIEGFNMIGbW
 */
#define SYSCR_INI	(H8SYSCR_UE | BIT1 | H8SYSCR_RAME | SYSCR_SYS)

/*
 *  vZbTˑ̏
 */
void
cpu_initialize(void)
{
        /*
         *  ȉ̂R̓X^[gAbv[`ŏςłB
         *  @@E݃lXgJE^ intnest
         *  @@E^XNReLXg̊݃}XN int_intmask
         *  @@E^XNReLXg̊݃}XN task_intmask
         *  @@@@ichg_ipmT|[gꍇj
         */

        /*
         *  SYSCR̐ݒ
         */
        sil_wrb_mem((VP)H8SYSCR, (VB)SYSCR_INI);
         
        /*    */
        /*  sleep߂őJڂȓd͏Ԃ̐ݒ  */

        /*  ჌xo͗pVA|[g̏  */
        SCI_initialize(SCI_LOW_PORTID);
}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate(void)
{
}

#ifdef SUPPORT_CHG_IPM
/*
 *  ݃}XN̕ύX
 *
 *@IPMɐݒłlƂIPM_LEVEL0AIPM_LEVEL1}N`ĂB
 *
 *
 *@IPM_LEVEL0FxO@ׂĂ݂̊󂯕t
 *@IPM_LEVEL1FxP@NMIуvCIeBxP݂݂̊̂
 *@@@@@@@@@@@@󂯕t
 *
 *  chg_ipm g IPM x2iNMI ȊÔׂĂ݂̊֎~j
 *  ύX邱Ƃ͂łȂDNMI ȊÔׂĂ݂̊֎~ꍇ
 *  ɂ́Cloc_cpu ɂCPUbNԂɂ΂悢D
 *  IPM  0 ȊO̎ɂC^XNfBXpb`͕ۗȂDIPM ́C
 *  ^XNfBXpb`ɂāCVsԂɂȂ^XNֈp
 *  D̂߁C^XNsɁCʂ̃^XNɂ IPM ύX
 *  ꍇDJSPJ[lł́CIPM ̕ύX̓^XNO[`
 *  ɂĂN̂CɂĈȂ󋵂͏Ȃ
 *  vD
 *@IPM ̒lɂă^XNfBXpb`֎~ꍇɂ́Cdis_dsp
 *  p΂悢D
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
        ER      ercd = E_OK;

        LOG_CHG_IPM_ENTER(ipm);
        CHECK_TSKCTX_UNL();
        CHECK_PAR( (ipm == IPM_LEVEL0) || (ipm == IPM_LEVEL1) || (ipm == IPM_LEVEL2));

        t_lock_cpu();
        task_intmask = ipm;
        t_unlock_cpu();

    exit:
        LOG_CHG_IPM_LEAVE(ercd)
        return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
        ER      ercd = E_OK;

        LOG_GET_IPM_ENTER(p_ipm);
        CHECK_TSKCTX_UNL();

        t_lock_cpu();
        *p_ipm = task_intmask;
        t_unlock_cpu();

    exit:
        LOG_GET_IPM_LEAVE(ercd, *p_ipm);
        return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*
 * ԑ҂
 * @@ӎF
 * @@@WłdlytimUINT^16rbgȂ̂ŁA
 * @@@UW^ɕύXĂB
 * @@@sil_dly_nse()͓sil_dly_nse2()ĂяoB
 */
void sil_dly_nse(UINT dlytim) {
	sil_dly_nse_long((UW)dlytim);
}

/*****ȉAʕƂ̃C^[tF[XɊ܂܂Ȃ*********/

/*
 * o^ĂȂ荞݂̃ftHg
 */

/*
 * X^bN̐擪eWX^̂܂ł̃ItZbg
 * 
 * @X^bN\
 *@@ +0:er0
 *@@ +4:er1
 *@@ +8:er2
 *@@+12:er3
 *@@+16:er4
 *@@+20:er5
 *@@+24:er6
 *@@+28:crr
 *@@+29:pc
 *@@+32`:ݑOɎgpĂX^bN̈
 */

/*
 * ݔÕX^bN|C^܂ł̃ItZbg
 */
#define OFFSET_SP	32

/*
 * o^ĂȂ荞݂ƌĂяo
 */
void 
cpu_experr(EXCSTACK *sp)
{
    UW sp2, pc, ccr, tmp;
    
    sp2 = (UW)sp + OFFSET_SP;
    tmp = sp->pc;
    ccr = (tmp >> 24U) & 0xff;	/*  1oCg  */
    pc = tmp & 0x00ffffffUL;	/*  3oCg  */
    
	/*
	 *  %xi^jł2oCg\łȂ̂
	 *  %pi|C^^jp4oCg\ĂB
	 */
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC  = 0x%08p SP  = 0x%08p CCR  = 0x%02x",
                       (VP)pc, (VP)sp2, (INT)ccr);
    syslog(LOG_EMERG, "ER0 = 0x%08p ER1 = 0x%08p ER2 = 0x%08p ER3 = 0x%08p",
           (VP)(sp->er0), (VP)(sp->er1), (VP)(sp->er2), (VP)(sp->er3));
    syslog(LOG_EMERG, "ER4 = 0x%08p ER5 = 0x%08p ER6 = 0x%08p",
                       (VP)(sp->er4), (VP)(sp->er5), (VP)(sp->er6));
    while(1)
    	;
}

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`D
 */
void
cpu_putc(char c)
{
    if (c == '\n') {
        SCI_putchar_pol('\r');
    }
    SCI_putchar_pol((UB)c);
}
