/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: makeoffset.c,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */


#include "jsp_kernel.h"
#include "task.h"

#define OFFSETOF(structure, field) \
                        ((INT) &(((structure *) 0)->field))

/*  OFFSET_DEF()̃C^[tF[X  */
#define INTERFACE1(TYPE, FIELD)                                         \
          INT JOINT4(OFFSET_DEF_,TYPE,_,FIELD)(void)

#define OFFSET_DEF(TYPE, FIELD)                                         \
          extern INTERFACE1(TYPE, FIELD);                               \
          INTERFACE1(TYPE, FIELD)                                       \
          {                                                             \
                return OFFSETOF(TYPE, FIELD);                           \
          }

/*  OFFSET_DEF2()̃C^[tF[X  */
#define INTERFACE2(TYPE, FIELD, FIELDNAME)                              \
          INT JOINT4(OFFSET_DEF_,TYPE,_,FIELDNAME)(void)

#define OFFSET_DEF2(TYPE, FIELD, FIELDNAME)                             \
          extern INTERFACE2(TYPE, FIELD, FIELDNAME);                    \
          INTERFACE2(TYPE, FIELD, FIELDNAME)                            \
          {                                                             \
                return OFFSETOF(TYPE, FIELD);                           \
          }

#define BIT_LABEL(TYPE, FIELD)  JOINT4(BIT_FIELD_OFFSET_,TYPE,_,FIELD)


OFFSET_DEF (TCB, tinib)
OFFSET_DEF2(TCB, tskctxb.sp, sp)
OFFSET_DEF2(TCB, tskctxb.pc, pc)
OFFSET_DEF (TINIB, task)
OFFSET_DEF (TINIB, exinf)
OFFSET_DEF (TCB, texptn)


TCB     BIT_LABEL(TCB, enatex) = {
                { NULL, NULL }, NULL, 0, 0,
                FALSE, FALSE, TRUE,
                0, NULL, { NULL, NULL }
        };

