/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Kunihiko Ohnaka
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[
 */

#include "jsp_kernel.h"
#include <sil.h>

/*
 *  ^[QbgVXeˑ [`
 */

void
sys_initialize(void)
{
}

/*
 *  ^[QbgVXȅI[`
 */

void
sys_exit(void)
{
  while (1)
  	;
}

#ifdef REDBOOT
/*
 *  Redbootgp銄݃xN^̑ޔƕ
 */
/*  ݃xN^̑ޔ  */
void
load_vector(TMP_VECTOR *p) {
	UW *redboot_trap_vector = (UW *)VECTOR_TABLE_ADDR + TRAP8;
	UW *pirq5 = (UW *)VECTOR_TABLE_ADDR + IRQ_EXT5;
	
	/* xN^e[u̓Atrapaߕޔ */
	memcpy(&(p->trap_vector), redboot_trap_vector, TRAP_VECTOR_SIZE*4);

	/*  IRQ5:Ethernet݂̐擪AhXޔ  */
	p->irq5 = sil_rew_mem((VP)pirq5);		
}

/*  ݃xN^̕  */
void
save_vector(TMP_VECTOR *p) {
	UW *redboot_trap_vector = (UW *)VECTOR_TABLE_ADDR + TRAP8;
	UW *pirq5 = (UW *)VECTOR_TABLE_ADDR + IRQ_EXT5;
	
	/*  IRQ5:Ethernet݂̐擪AhX𕜌  */
	sil_wrw_mem((VP)pirq5, p->irq5);		

	/* xN^e[u̓Atrapaߕ𕜌 */
	memcpy(redboot_trap_vector, &(p->trap_vector), TRAP_VECTOR_SIZE*4);
}

#endif	/* of #ifdef REDBOOT */

