/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_defs.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	vZbTɈˑ`iH8pj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#include <h8.h>		/*  IPM_LEVEL0,1,2̒`  */
#define H8

/* J[lÑbZ[W */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2007 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n" \
"Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering\n" \
"                 Tomakomai National College of Technology, JAPAN\n" \
"Copyright (C) 2003-2004 by Katsuhiro Amano\n"

/*
 *  ^CeBbN̒`
 */

#define	TIC_NUME	1		/* ^CeBbN̎̕q */
#define	TIC_DENO	1		/* ^CeBbN̎̕ */

/*
 *  CPU ̃oCgɊւ`
 */

#define SIL_ENDIAN		SIL_ENDIAN_BIG

#ifndef _MACRO_ONLY
typedef	UINT	INHNO;			/* ݃nhԍ */
typedef	UINT	EXCNO;			/* CPUOnhԍ */
#endif /* _MACRO_ONLY */

/*
 *  ^[QbgVXeˑ̃T[rXR[
 *
 * cpu_defs.hsys_defs.hCN[h鏇Ԃ̊֌W
 * SUPPORT_CHG_IPM}NSUPPORT_VXGET_TIM}Nł͈͂܂Ȃ
 * i_MACRO_ONLY}Nň͂߂΁A\j
 */

/*
 *  ݃}XŇ^Ɗ݃}XN̕ύX^Q
 */
#ifndef _MACRO_ONLY
typedef UB              IPM;            /* ݃}XN */

extern ER       chg_ipm(IPM ipm) throw();
extern ER       get_ipm(IPM *p_ipm) throw();


/*
 *  vCIeBxݒp̃f[^\
 */
typedef struct {
        UB *ipr;        /* ݒ肷IPRWX^̔Ԓn */
        UB bit;         /* IPRWX^̊Yrbgԍ */
        IPM ipm;        /* ݒ肷銄݃x */
                        /* IPM_LEVEL0,IPM_LEVEL1̂ꂩ */
} IRC;                  /* IRC:Interrupt Request Controller */


/*
 *  \]pVXev@\
 */

/* \]pVXe */
#ifdef _int64_		/*  64rbg  */
typedef	UD  SYSUTIM;
#else 	/*  _int64_  */
typedef	UW  SYSUTIM;
#endif	/*  _int64_  */

extern ER   vxget_tim(SYSUTIM *pk_sysutim) throw();

/*
 *  VXe̒f
 */

Inline void
kernel_abort (void)
{
	while (1)
		;
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
