/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <h8_sil.h>

#ifndef _MACRO_ONLY

/*
 *  CPUˑ^C}W[iH8pj
 */

/*
 *  ^C}l̓\̌^
 */

typedef UH	CLOCK;

/*
 *  ^C}̒Pʂ\ɕϊ
 *  	jsp/kernel/time_manage.cłgp
 */

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ^C}̒Pʂ\ɕϊ
 */

#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */

#define MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  \]pVXeoۂ̏Ԃ̌ςl
 *	iPʂ͓\j
 *	Ӂi{͕NbNɈˑj
 */

#define GET_TOLERANCE	100
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  vCIeBxݒp̃f[^
 *      {͊݃Rg[ˑ𕪗ׂ
 *
 *      {hw_timer.hɎ̂LqׂA
 *      hw_timer.hCN[ht@CłׂĎ̉
 *@@@̈LĂ܂߁Âcpu_config.cɋLqB
 */
extern const IRC TIMER_IRC;

/*
 *  ^C}ݗṽNA
 *	TCRWX^IMFArbg1ǂݏoɂO
 */

Inline void
hw_timer_int_clear(void)
{
    /* GRARyA}b`̊荞ݗvtONA */
    bitclr((UB *)SYSTEM_TIMER_IFR, SYSTEM_TIMER_IF_BIT);
}

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */

Inline void
hw_timer_initialize(void)
{
    /* ^C}~ */
    bitclr((UB *)SYSTEM_TIMER_TSTR, SYSTEM_TIMER_STR_BIT);

    /*  GRARyA}b`ŃJE^NAAݒ */
    sil_wrb_mem((VP)SYSTEM_TIMER_TCR, SYSTEM_TIMER_TCR_BIT);

    /*  GRARyA}b`ɂ銄ݗv */
    sil_wrb_mem((VP)SYSTEM_TIMER_IER, SYSTEM_TIMER_IE);

    /*  GRARyA}b`ɂ[qo͋֎~ */
    sil_wrb_mem((VP)SYSTEM_TIMER_TIOR, SYSTEM_TIMER_TIOR_BIT);

    /*  GRAWX^ݒiJE^ڕWlj  	*/
    sil_wrh_mem((VP)SYSTEM_TIMER_GR, CLOCK_PER_TICK);

    sil_wrh_mem((VP)SYSTEM_TIMER_CNT, 0);	/* JE^NA	*/

    hw_timer_int_clear();			/*  ݗvNA	*/

    /*
     *  vCIeBEx̐ݒ
     *  {͊݃Rg[ˑ𕪗ׂ
     */
    define_int_plevel(&TIMER_IRC);

    /* ^C}X^[g */
    bitset((UB *)SYSTEM_TIMER_TSTR, SYSTEM_TIMER_STR_BIT);
}

/*
 *  ^C}̒~
 */

Inline void
hw_timer_terminate(void)
{
    					/* ^C}~ */
    bitclr((UB *)SYSTEM_TIMER_TSTR, SYSTEM_TIMER_STR_BIT);
    hw_timer_int_clear();		/* 荞ݗvNA */
}

/*
 *  ^C}̌ݒl̓ǂݏo
 *
 *  ݋֎~ԒŌĂяoƁD
 */

Inline CLOCK
hw_timer_get_current(void)
{
	return((CLOCK)(sil_reh_mem((VP)SYSTEM_TIMER_CNT)));
}

/*
 *  ^C}ݗṽ`FbN
 */

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	UB ifr = sil_reb_mem((VP)SYSTEM_TIMER_IFR);
	return(ifr & SYSTEM_TIMER_IF);
}

#endif	/* of #ifndef _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
