/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *  vZbTˑW[(H8Sp)
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ^XNReLXgł̊݃}XN
 */
#ifdef SUPPORT_CHG_IPM
volatile IPM	task_intmask = 0;		/* IPM -> UBF8rbg */
#endif /* SUPPORT_CHG_IPM */

/*
 *  ^XNReLXgł̊݃}XN
 */
volatile IPM	int_intmask = 0;

/*
 *  ݃lXgJE^
 */
volatile UB	intnest = 1;

/*
 *  CPUbNԂ\tO
 *  @E݋֎~iJ[lǗ݂̊̂݁j
 *  @@@
 *  @Eiscpulocked == TRUE
 *  @@@̂ƂCPUbNԂƂB
 */
volatile BOOL     iscpulocked = TRUE;

/*
 *  vZbTˑ̏
 */
void cpu_initialize(void) {

        /*
         *  ȉ4̓X^[gAbv[`ŏςłB
         *  @@E݃lXgJE^ intnest = 1;
         *  @@E^XNReLXg̊݃}XN int_intmask = 0;
         *  @@E^XNReLXg̊݃}XN task_intmask = 0;
         *  @@@@ichg_ipmT|[gꍇj
         *  @@ECPUbNtO iscpulocked = TRUE;
         */

	/* ݐ䃂[h̐ݒ */
	h8s_wrb_reg(SYSCR, SYS_SYSCR);

	/* ݃x̏ */
	h8s_wrb_reg(IPRA, 0);
	h8s_wrb_reg(IPRB, 0);
	h8s_wrb_reg(IPRC, 0);
	h8s_wrb_reg(IPRD, 0);
	h8s_wrb_reg(IPRE, 0);
	h8s_wrb_reg(IPRF, 0);
	h8s_wrb_reg(IPRG, 0);
	h8s_wrb_reg(IPRH, 0);
	h8s_wrb_reg(IPRI, 0);
	h8s_wrb_reg(IPRJ, 0);
	h8s_wrb_reg(IPRK, 0);
}

/*
 *  vZbTˑ̏I
 */
void cpu_terminate(void) {
}

/*
 * ԑ҂
 * @@ӎF
 * @@@WłdlytimUINT^16rbgȂ̂ŁA
 * @@@UW^ɕύXĂB
 * @@@sil_dly_nse()͓sil_dly_nse_long()ĂяoB
 */
void sil_dly_nse(UINT dlytim) {
	sil_dly_nse_long((UW)dlytim);
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ݃}XN̕ύX
 *
 *@IPMɐݒłl0`MAX_IPMłB
 *@݃vCIeBx(MAX_IPM+1)ȏ݂̊̓J[lǗO
 *@łB
 *
 *  IPM  0 ȊO̎ɂC^XNfBXpb`͕ۗȂD
 *  fBXpb`֎~ꍇɂ́Cloc_cpu ɂCPUbNԂ
 *  ΂悢DIPM ́C
 *  ^XNfBXpb`ɂāCVsԂɂȂ^XNֈp
 *  D̂߁C^XNsɁCʂ̃^XNɂ IPM ύX
 *  ꍇDJSPJ[lł́CIPM ̕ύX̓^XNO[`
 *  ɂĂN̂CɂĈȂ󋵂͏Ȃ
 *  vD
 *@IPM ̒lɂă^XNfBXpb`֎~ꍇɂ́Cdis_dsp
 *  p΂悢D
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
        ER      ercd = E_OK;

        LOG_CHG_IPM_ENTER(ipm);
        CHECK_TSKCTX_UNL();
        CHECK_PAR(ipm <= MAX_IPM);

        t_lock_cpu();
        task_intmask = ipm;
        t_unlock_cpu();

    exit:
        LOG_CHG_IPM_LEAVE(ercd)
        return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
        ER      ercd = E_OK;

        LOG_GET_IPM_ENTER(p_ipm);
        CHECK_TSKCTX_UNL();

        t_lock_cpu();
        *p_ipm = task_intmask;
        t_unlock_cpu();

    exit:
        LOG_GET_IPM_LEAVE(ercd, *p_ipm);
        return(ercd);
}


#endif /* SUPPORT_CHG_IPM */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*
 * o^ĂȂ荞݂ƌĂяo
 */
void 
cpu_experr(EXCSTACK *sp)
{
    UW sp2, pc, ccr, tmp;
    
    sp2 = (UW)sp + OFFSET_SP;
    tmp = sp->pc;
    ccr = (tmp >> 24U) & 0xff;	/*  1oCg  */
    pc = tmp & 0x00ffffffUL;	/*  3oCg  */
    
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC  = 0x%08lx SP  = 0x%08lx CCR  = 0x%02x",
                       (VP)pc, (VP)sp2, (INT)ccr);
    syslog(LOG_EMERG, "EXR  = 0x%02x", (INT)(sp->exr));
    syslog(LOG_EMERG, "ER0 = 0x%08lx ER1 = 0x%08lx ER2 = 0x%08lx ER3 = 0x%08lx",
           (VP)(sp->er0), (VP)(sp->er1), (VP)(sp->er2), (VP)(sp->er3));
    syslog(LOG_EMERG, "ER4 = 0x%08lx ER5 = 0x%08lx ER6 = 0x%08lx",
                       (VP)(sp->er4), (VP)(sp->er5), (VP)(sp->er6));
    while(1)
    	;
}


/*============================================================================*/
/*  fobOpR[h  */

#ifdef TEST_CPU_INSN

volatile UB ccr, exr;
volatile IPM intmask;

void test_cpu_insn(void)
{
	ccr = current_ccr();
	set_ccr(0xf);
	ccr = current_ccr();

	exr = current_exr();
	set_exr(0x7);
	exr = current_exr();

	intmask = current_intmask();
	set_intmask(0x3);
	intmask = current_intmask();
	
	disint();
	enaint();
	
	_disint_();
}

#endif /* TEST_CPU_INSN */


#ifdef TEST_CPU_CONFIG

volatile BOOL b;
volatile ER err;
volatile IPM ipm;

void dummy(void)
{
}

void test_cpu_config(void)
{
	b = sense_context();
	dummy();
	intnest = 1;
	dummy();
	b = sense_context();
	dummy();
	intnest = 0;
	dummy();
	b = sense_context();
	dummy();

	b = t_sense_lock();
	dummy();
	t_lock_cpu();
	dummy();
	b = t_sense_lock();
	dummy();
	t_unlock_cpu();
	dummy();
	b = t_sense_lock();
	dummy();

	i_lock_cpu();
	dummy();
	b = i_sense_lock();
	dummy();
	i_unlock_cpu();
	dummy();
	b = i_sense_lock();
	dummy();
	
	err = chg_ipm(6);
	dummy();
	err = get_ipm(&ipm);
	dummy();
	err = chg_ipm(3);
	dummy();
	err = get_ipm(&ipm);
	dummy();
	err = chg_ipm(8);
	dummy();
}

#endif /* TEST_CPU_CONFIG */

#ifdef TEST_H8S_SIL

volatile UB ddr;

void test_h8s_sil(void)
{
	ddr = sil_reb_ddr(IO_PORT7);
	sil_wrb_ddr(IO_PORT7, 0xff);
	ddr = sil_reb_ddr(IO_PORT7);
	sil_anb_ddr(IO_PORT7, 0xf);
	ddr = sil_reb_ddr(IO_PORT7);
	sil_orb_ddr(IO_PORT7, 0x80);
	ddr = sil_reb_ddr(IO_PORT7);
}

#endif /* TEST_H8S_SIL */



