/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _H8S_SCI_H_
#define _H8S_SCI_H_

/*
 *  H8S VAR~jP[VC^tF[X(SCI)֘A̒`
 */

#include <s_services.h>		/* foCXhCopWCN[ht@C */

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_control_block	SIOPCB;

#endif /* _MACRO_ONLY */

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND	1u		/* M\R[obN */
#define SIO_ERDY_RCV	2u		/* MʒmR[obN */

#ifndef _MACRO_ONLY

/*
 *  SIOhCȍ[`
 */
extern void	h8s_sci_initialize(void);

/*
 *  I[vĂ|[g邩H
 */
extern BOOL	h8s_sci_openflag(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*h8s_sci_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void	h8s_sci_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL	h8s_sci_snd_chr(SIOPCB *siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern INT	h8s_sci_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void	h8s_sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void	h8s_sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*  @svH  */
/*
 *  SIO̊݃T[rX[`
 */
extern void	h8s_sci_isr_in(void);
extern void	h8s_sci_isr_out(void);

/*
 *  SIO̎MG[݃T[rX[`
 */
extern void	h8s_sci_isr_error(void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void	h8s_sci_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void	h8s_sci_ierdy_rcv(VP_INT exinf);

/*
 *  J[lNp̏ (sys_putcŗp)
 */
extern void	h8s_sci_init(void);

/*
 *  VAI/O|[gւ̕Mi|[Oj
 */
extern void	h8s_sci_putchar_pol(char c);

#endif /* _MACRO_ONLY */

#endif /* _H8S_SCI_H_ */
