/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *  vZbTˑW[(H8Sp)
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ^XNReLXgł̊݃}XN
 */
#ifdef SUPPORT_CHG_IPM
IPM	task_intmask;		/* IPM -> UBF8rbg */
#endif /* SUPPORT_CHG_IPM */

/*
 *  ^XNReLXgł̊݃}XN
 */
IPM	int_intmask;

/*
 *  ݃lXgJE^
 */
UW	intnest;

/*
 *  vZbTˑ̏
 */
void cpu_initialize() {

#ifdef SUPPORT_CHG_IPM
	/* ^XNReLXgł̊݃}XN̏ */
	task_intmask = 0x00;
#endif /* SUPPORT_CHG_IPM */

	/* ݁^CPUOlXgJE^̏ */
	intnest = 1;

	/* ݃x̏ */
	icu_set_ilv( (VP) IPRA, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRA, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRB, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRB, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRC, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRC, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRD, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRD, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRE, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRE, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRF, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRF, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRG, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRG, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRH, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRH, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRI, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRI, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRJ, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRJ, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRK, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRK, IPR_LOW, 0 );
}

/*
 *  vZbTˑ̏I
 */
void cpu_terminate() {
}

/*
 *  ԑ҂
 */
void sil_dly_nse(UINT dlytim) {
	/* er0 = dlytim */
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM1) );
	Asm("		ble	sil_dly_nse_2");
				/* dlytim < SIL_DLY_TIM1 Ȃ烋[vI */
	Asm("	sil_dly_nse_1:");
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM2) );
	Asm("		bgt	sil_dly_nse_1");
				/* dlytim > SIL_DLY_TIM2 Ȃ烋[vs */
	Asm("	sil_dly_nse_2:");
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ݃}XN̕ύX
 *
 *  Echg_ipm gāA݃}XN MAX_IPM iNMI X^u[gu[N ȊO
 *    ׂ̂Ă݂̊֎~jȏɕύX邱Ƃ͂ł܂BNMI X^u[g
 *    u[NȊÔׂĂ݂̊֎~ꍇɂ́Aloc_cpuɂCPUbN
 *    ԂɂĂB
 *  E݃}XN 0 ȊO̎łĂA^XNfBXpb`͕ۗ܂B
 *    ̂ƂA݃}XN̏Ԃ́A^XNfBXpb`ɂĐVsԂ
 *    Ȃ^XNցA̓sxAp܂B
 *    ̂߁A^XNsɁA݂AfBXpb`̕ʂ̃^XN
 *    ɂĊ݃}XNύXꍇ܂B
 *    TOPPERS/JSP J[lł́A݃}XN̕ύX̓^XNO[`ɂ
 *    ĂN̂ŁCɂĈȂ󋵂͏ȂƎv܂B
 *  E݃}XN̒lɂă^XNfBXpb`֎~ꍇɂ́Adis_dsp 
 *    pĂB
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR( /*(0 <= ipm) &&*/ (ipm <= MAX_IPM) );
	/* IPM^ ́Aunsigned Œ`Ă̂ŁARgAEg
	   Ƃ́AɐĂ邽߁AWarnning B
	   Aǐ̖肩AIɋLqĂB */

	t_lock_cpu();
	task_intmask = ipm;
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd)
	return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = task_intmask;
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*
 * o^ĂȂ荞݂ƌĂяo
 */
void cpu_experr(EXCSTACK *sp)
{
	syslog( LOG_EMERG, "Unexpected interrupt." );
	syslog( LOG_EMERG, "SP  = %08x PC  = %08x CCR = %08x",
				sp - 34, sp->pc,  sp->ccr );
	syslog( LOG_EMERG, "ER0 = %08x ER1 = %08x ER2 = %08x ER3 = %08x",
				sp->er0, sp->er1, sp->er2, sp->er3 );
	syslog( LOG_EMERG, "ER4 = %08x ER5 = %08x ER6 = %08x ",
				sp->er4, sp->er5, sp->er6 );

	while(1);
}

/*
 *  ubN색Cu
 *	(ItIs̗p)
 *
 *  ֐̎dĺCANSI C Cu̎dlƓDWCû̂
 *  gǂ\D
 *
 */
VP _dummy_memcpy(VP dest, VP src, UINT len)
{
	VB	*d = (VB *)dest;
	VB	*s = (VB *)src;

	while (len-- > 0) {
		*d++ = *s++;
	}

	return(dest);
}
