/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/* LɂėpĂAMAX_IPM  cpu_config.h Œ` */

#ifndef _MACRO_ONLY

/*
 *  䃌WX^̑֐
 */

/* RfVR[hWX^iCCRǰݒl̓Ǐo */
Inline UB current_ccr(void)
{
	UB	ccr;

	Asm( "stc.b	ccr, %0l" : "=r"(ccr) );

	return(ccr);
}

/* RfBVR[hWX^iCCRǰݒl̕ύX */
Inline void set_ccr(UB ccr)
{
	Asm( "ldc.b	%0l, ccr" ::"r"(ccr) );
}

/* GNXehWX^iEXRǰݒl̓Ǐo */
Inline UB current_exr(void)
{
	UB	exr;

	Asm( "stc.b	exr, %0l" : "=r"(exr) );

	return(exr);
}

/* RfVR[hWX^iEXRǰݒl̕ύX */
Inline void set_exr(UB exr)
{
	Asm( "ldc.b	%0l, exr" :: "r"(exr) );
}

/*
 *  ݃}XN색Cu (݃[hQp)
 */

/* ݂̊݃}XN̓Ǐo */
Inline IPM current_intmask(void)
{
	return(  (IPM)  (current_exr() &  EXR_I_MASK) );
}

/* ݃}XN̐ݒ */
Inline void set_intmask(IPM intmask)
{
	set_exr( (IPM) ((current_exr() & ~EXR_I_MASK) | intmask ) );
}

/* J[lǗׂ̂Ă̊  ݃xMAX_IPM ȉ̊ */

/* J[lǗׂ̂Ă݂̊֎~ (NMI)  */
Inline void disint(void)
{
	/* set_intmask( (IPM) MAX_IPM ); */
	set_exr( (IPM) ((current_exr() & ~EXR_I_MASK) | MAX_IPM ) );
}

/* J[lǗׂ̂Ă݂̊ (NMI) */
/*   ̏́AAJ[lǗ̗L킸AׂĂ݂̊
     邱ƂɂȂĂB */
Inline void enaint()
{
	/* set_intmask( (IPM) 0 ); */
	set_exr( (IPM)  (current_exr() & ~EXR_I_MASK) );
}

/*
 *  ݃bNԂ̐p֐
 */

/* ׂĂ݂̊֎~ (NMI) */
Inline void _disint_()
{
	/* set_intmask( (IPM) 7 ); */
	set_exr( (IPM) (current_exr() | EXR_I_MASK) );
}

/*
 *  rbgp֐
 */

/* rbgNA */
Inline void bitclr(UW addr, UB bit)
{
	Asm( "bclr %1l, @%0" :: "r"(addr), "r"(bit) );
}

/* rbgZbg */
Inline void bitset(UW addr, UB bit)
{
	Asm( "bset %1l, @%0" :: "r"(addr), "r"(bit) );
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_INSN_H_ */
