/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"
#include "offset.h"

	.h8300s
	.text
	.align 2

/*
 *  ^XNfBXpb`
 *  Edispatch ́A݃lXgJE^ = 0ACPUbNԁi݋֎~ԁj
 *    ĂяoȂ΂ȂȂB
 *  Eexit_and_dispatch ́C݃lXgJE^ = 0ACPUbNԁi݋֎~
 *    ԁjŌĂяôłBAJ[lNɑΉ邽߁C
 *    ݃lXgJE^ = 1 ŌĂяoꍇɂΉĂB
 */

	.global _dispatch
	.global	_exit_and_dispatch

/* ^XNfBXpb`𖾎IɌĂяo */
_dispatch:
	push.l	er2			/* er2`6 ۑ */
	push.l	er3
	push.l	er4
	push.l	er5
	push.l	er6

	mov.l	@_runtsk, er0		/* er0 = runtsk */
	mov.l	sp, @(TCB_sp, er0)	/* runtsk->sp = sp
					   (^XNX^bN|C^ۑ) */
	mov.l	#dispatch_r, er1
	mov.l	er1, @(TCB_pc, er0)	/* runtsk->pc = dispatch_r
					   (^XN̎sĊJԒnۑ) */

	bra     dispatcher_1

/* ݎs̃ReLXĝĂāA^XNfBXpb`Ăяo */
_exit_and_dispatch:
	sub.l	er0, er0
	mov.l	er0, @_intnest		/* ݃lXgJE^ = 0 */

dispatcher_1:
	/* ɂ CPUbNi荞݋֎~jŗ邱 */
	mov.l	@_schedtsk, er0		/* er0 = schedtsk */
	or.l	er0, er0		/* 蕔 (s\^XN̗L) */
	beq	dispatcher_2		/* schedtsk ȂAݑ҂ */

	mov.l	er0, @_runtsk		/* runtsk = er0 (= schedtsk)
					   (^XNXCb`̎s) */
	mov.l	@(TCB_sp, er0), sp	/* sp = runtsk->sp
					   (^XNX^bN|C^) */
	mov.l	@(TCB_pc, er0), er0	/* er0 = runtsk->pc
					   (^XN̎sĊJԒn̎擾) */
					/* sĊJԒn͈ȉ3ʂ
					   EfBXpb`̏o  dispatch_r
					   E݁^Ȍo    ret_int_r
					   E^XNN        activate_r
					 */

	jmp	@er0			/* ^XN̎sĊJԒnփWv */

	/*
	 *  sׂ^XN܂ő҂
	 *    ŃReLXg؂芷̂́C
	 *      EŔ銄ݏɂǂ̃X^bNgƂ̉
	 *      E݃nhł̃^XNfBXpb`̖h~
	 *    Ƃ̈ӖD
	 */ 
dispatcher_2:
	sub.l	er0, er0
	mov.l	er0, @_runtsk		/* runtsk = NULL */

	mov.l	#STACKTOP, sp		/* ݃X^bNɐؑ */

	sub.l	er0, er0
	inc.l	#1, er0
	mov.l	er0, @_intnest		/* ݃lXgJE^ = 1 */

dispatcher_2_enable_interrupt:
#ifdef SUPPORT_CHG_IPM
	ldc.b	@_task_intmask, exr	/* unlock_cpu(݋) */
#else /* SUPPORT_CHG_IPM */
	ldc.b	#0, exr			/* unlock_cpu(݋) */
#endif /* SUPPORT_CHG_IPM */
	sleep				/* ݑ҂ */
	ldc.b	#MAX_IPM, exr		/* lock_cpu  (݋֎~) */

	mov.l	@_reqflg, er0		/* er0 = reqflg  */
	or.l	er0, er0		/* 蕔 (fBXpb`v) */
	beq	dispatcher_2_enable_interrupt
					/* fBXpb`vA
					   [v̐擪փWv */

	sub.l	er0, er0		/* er0 = 0 (= NULL) */
	mov.l	er0, @_reqflg		/* reqflg = NULL (reqflgNA) */
	mov.l	er0, @_intnest		/* ݃lXgJE^ = 0 */

	bra	dispatcher_1		/* fBXpb`փWv */

/*
 *  ^XNReLXgւ̕AifBXpb`oj
 */
dispatch_r:
	pop.l	er6			/* er2`6 𕜌 */
	pop.l	er5
	pop.l	er4
	pop.l	er3
	pop.l	er2

	/* ^XNOṽ`FbN */
	mov.l	@_runtsk, er0		/* er0 = runtsk */

	mov.b	@(TCB_enatex, er0), r1l	/* r1l = runtsk->enatex */
	btst	#TCB_enatex_bit, r1l	/* TCB_enatex == 1 H */
	beq	dispatch_r_1		/* ^XNO֎~̎AWv */

	mov.l	@(TCB_texptn, er0), er1	/* er1 = runtsk->texptn */
	beq	dispatch_r_1		/* ^XNOvAWv */

	jmp	@_call_texrtn		/* ^XNO[`̌ďo */

dispatch_r_1:
        rts				/* dispatch Ăяo֖߂ */

/*============================================================================*/

/*
 *  ݃nho
 *    ɗƂ́ACPU bNԂŁA
 *      er0(r0l) : ݗv̊荞݃x̒l
 *      er1      : ݃nh̃AhX
 *    ĂBier0, er1 ̓X^bNɕۑς݁j
 */

	.global ret_main
	.global	_ret_int_r	/* monitor  */

ret_main:
	push.l	er2			/* c̃WX^ۑ */
	push.l  er3
	push.l	er4
	push.l	er5
	push.l	er6
		/* ƁAH8S/2600 ɂ macl, mach WX^̕ۑ
		   ōsKv邩m܂BiAlBj
		   J̐ɂAmFłĂ܂B */

	mov.l	@_intnest, er2		/* er2 = intnest */
	mov.l	er2, er3		/* er3(= er2)́ȀŗpB */
	inc.l	#1, er2			/* ݃lXgJE^ += 1 */
	mov.l	er2, @_intnest

	or.l	er3, er3		/* 蕔
					   (ݔ̃ReLXg) */
	beq	first_exception		/* i݂̊̎AWv */

/* d݂̏ */
multipul_exception:
	ldc.b	r0l, exr		/* (݂̊݃xȏ)݋ */

	jsr	@er1			/* ݃nhďo */

	ldc.b	#MAX_IPM, exr		/* lock_cpu  (݋֎~) */

	mov.l	@_intnest, er0		/* er0 = intnest */
	dec.l	#1, er0			/* ݃lXgJE^ -= 1 */
	mov.l	er0, @_intnest

	jmp	ret_to_task_int

/* i݂̊̏ꍇ */
first_exception:

	mov.l	sp, er2			/* er2 = ^XNX^bN|C^ */
	mov.l	#STACKTOP, sp		/* ݃X^bNɐؑ */
	push.l	er2			/* ^XNX^bN|C^
					   ݃X^bNɑޔ */

	ldc.b	r0l, exr		/* (݂̊݃xȏ)݋ */

	jsr	@er1			/* ݃nhďo */

	ldc.b	#MAX_IPM, exr		/* lock_cpu  (݋֎~) */

	mov.l	@sp, sp			/* ^XNX^bNɐؑ */

	mov.l	@_intnest, er0		/* er0 = intnest */
	dec.l	#1, er0			/* ݃lXgJE^ -= 1 */
	mov.l	er0, @_intnest

	/* fBXpb`v/^XNOv(reqflg)̔ */
	mov.l	@_reqflg, er0		/* er0 = reqflg */
	or.l	er0, er0		/* 蕔 */
	bne	occur_dispatch_or_tsk_exception
					/* reqflg = TRUE ̎AWv */
					/* L̏AOR Ő̎
					   ExfBXpb`
					   E^XNOv */

	/* WX^̕ */
ret_to_task_int:
	pop.l	er6			/*  +0:er6 */
	pop.l	er5			/*  +4:er5 */
	pop.l	er4			/*  +8:er4 */
	pop.l	er3			/* +12:er3 */
	pop.l	er2			/* +16:er2 */
	pop.l	er1			/* +20:er1 */
	pop.l	er0			/* +24:er0 */
					/* +28:EXR -> EXR_offset = 28 */
	rte				/* ݔꏊɖ߂ */
			/* EXR ̕(unlock_cpu )̓n[hEFAsB */

/*
 *  ݏoɂxfBXpb`/^XNOɊւ鏈
 */
occur_dispatch_or_tsk_exception:

/* ݔ̔ */
	mov.b	@(EXR_offset, sp), r0l	/* r01 = X^bNEXR */
	and.b	#EXR_I_MASK, r0l	/* r01 = X^bN̊荞݃}XN */

#ifdef SUPPORT_CHG_IPM			/* r1l = ^XNReLXg
					         ݃}XN */
	mov.b	@_task_intmask, r1l
#else /* SUPPORT_CHG_IPM */
	mov.b	#0, r1l
#endif /* SUPPORT_CHG_IPM */

	cmp.b	r0l, r1l		/* 蕔 (ݔ) */

	bne	ret_to_task_int		/* ݔꏊA^XNReLXg
					   łȂAWv */
		/* _Iȕ́Ato_int_routine ɂ SUPPORT_CHG_IPM
		   }Nň͂܂ꂽ̒łBRXg̖肩A{I
		   ɓȂ̂ŁAret_to_task_int ƋLqB */

	sub.l	er0, er0		/* er0 = NULL (= 0) */
	mov.l	er0, @_reqflg		/* reqflg = NULL (reqflgNA) */

/* xfBXpb`Ɋւ锻 */
	/* fBXpb`֎~/̔ */
	mov.l	@_enadsp, er0		/* er0 = enadsp */
	or.l	er0, er0		/* 蕔 */
	beq	to_tsk_exc		/* fBXpb`֎~ȂWv */

	/* XPW[Oʂ̔ */
	mov.l	@_runtsk, er0		/* er0 = runtsk	*/
	mov.l	@_schedtsk, er1		/* er1 = schedtsk */
	cmp.l	er0, er1		/* 蕔 */
	beq	to_tsk_exc		/* runtsk == schedtsk ȂWv */

/* xfBXpb`ꍇ */
occur_dispatch:
#ifdef H8S_2600				/* H8S_2600̓RpCIvV` */
	/* ϘaWX^̑ޔ */
	/* er0 ͉Lɂėp̂ŔjłȂ */
	stmac	mach, er1
	push.l	er1
	stmac	macl, er1
	push.l	er1
#endif /* H8S_2600 */

	mov.l	sp, @(TCB_sp, er0)	/* runtsk->sp = sp
					   (^XNX^bN|C^ۑ) */

	mov.l	#ret_int_r, er1
	mov.l	er1, @(TCB_pc, er0)	/* runtsk->pc = ret_int_r
					   (^XN̎sĊJԒnۑ) */

	jmp	dispatcher_1		/* fBXpbeďo */

/* xfBXpb`ɂăfBXpb`^XNReLXg̊Jnn_ */
_ret_int_r:	/* monitor  */
ret_int_r:

#ifdef H8S_2600				/* H8S_2600̓RpCIvV` */
	/* ϘaWX^̕ */
	pop.l	er0
	ldmac	er0, macl
	pop.l	er0
	ldmac	er0, mach
#endif /* H8S_2600 */

/* xfBXpb`Ȃꍇ̊Jnn_ */

/* ^XNOɊւ锻 */
to_tsk_exc:
	mov.l	@_runtsk, er0		/* er0 = runtsk */

	/* ^XNO֎~/̔ */
	mov.b	@(TCB_enatex, er0), r1l	/* r1l = runtsk->enatex */
	btst	#TCB_enatex_bit, r1l	/* TCB_enatex == 1 H */
	beq	to_int_routine		/* ^XNO֎~̎AWv */

	/* ^XNOv̗L̔ */
	mov.l	@(TCB_texptn, er0), er1	/* er1 = runtsk->texptn */
	beq	to_int_routine		/* ^XNOvAWv */

	jsr	@_call_texrtn		/* ^XNO[`̌ďo */

to_int_routine:

/* chg_ipm ̘b́AxfBXpb`̃^XN̖Ȃ̂ŁAɋLqB */
#ifdef SUPPORT_CHG_IPM
	/* 荞݃nhIɕʂ̃^XNփXCb`ƂɁA
	   荞݃}XN𐮍鏈 */
	/* FfBXpb`F
		^XN`->荞݃nh->^XNa->^XN`
	       F
		̎Ƀ^XNaŁA݃}XN̕ύXsꂽꍇɁA
		̊݃}XNɊւA^XNa^XN`ւ
		p߂ɕKvB*/
	mov.b	@_task_intmask, r1l	/* r1l = task_intmask */
		/* task_intmaskFCHG_IPM ɂύXꂽ\̂
				 ݃}XN */
	mov.b	r1l, @(EXR_offset, sp)
		/* X^bN EXR ɏ㏑B */
		/* FEXR ̃g[Xrbg T ͕ۑȂB */
#endif /* SUPPORT_CHG_IPM */

	jmp	ret_to_task_int		/* ^XNReLXgւ̕A */

/*============================================================================*/

/*
 *  ^XNN
 */

	.global _activate_r

_activate_r:
	/* ɗƂ́ACPUbNɂȂĂB */

	mov.l	#_ext_tsk, er0
	push.l	er0				/* ^XN̖߂Ԓnݒ */

	/* ^XN֌W̐ݒ菀 */
	mov.l	@_runtsk, er2			/* er2 = runtsk */
	mov.l	@(TCB_tinib, er2), er2		/* er2 = runtsk->tinib */

	/* ^XNNԒn̐ݒ */
	mov.l	@(TINIB_task, er2), er1		/* er1 = runtsk->tinib->task */

	/* ^XNւ̈igjݒ */
	mov.l	@(TINIB_exinf, er2), er0	/* er0 = runtsk->tinib->exinf */

#ifdef SUPPORT_CHG_IPM
	ldc.b	@_task_intmask, exr		/* unlock_cpu(݋) */
#else /* SUPPORT_CHG_IPM */
	ldc.b	#0, exr				/* unlock_cpu(݋) */
#endif /* SUPPORT_CHG_IPM */

	jmp	@er1				/* ^XNN */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*
 *  no_reg_exception()
 *    CPUOƂēo^ĂȂOƌĂяoB
 *    O_ PCAer0`7 o͂ăJ[l~B
 */
	.global no_reg_exception

no_reg_exception:

	push.l	er0			/* er0`6ۑ	*/
	push.l	er1
	push.l	er2
	push.l	er3
	push.l	er4
	push.l	er5
	push.l	er6

	mov.l	sp, er0			/* ɃX^bN|C^ݒ	*/
	/* CPUO_ SP ́A
	   34(= 4*7(er) + 1(exr) + 1(\) + 1(ccr) + 3(pc) )  */

	jsr	@_cpu_experr		/* cpu_experr()̌Ăяo */

