/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _MISPO_H8S_2350_H_
#define _MISPO_H8S_2350_H_

/*
 *  MISPO H8S/2350 ]{[hp`
 */

#define MISPO_H8S_2350

/*
 *  CPU NbN
 */
#define CPU_CLOCK	20000			/* kHz = 20MHz*/

/*
 *  ^C}ɋNbN (NbN/4ŃJEg)
 */
#define TIMER_CLOCK	((CPU_CLOCK)/4)		/* 20MHz / 4 = 5MHz = 5000kHz */

/*
 *  |[gQ̐ݒp}N
 *    sys_support.SŁA|[gQݒ肷̂ɗpB
 *    ̃|[gɂ́ALEDڑĂ̂ŁASďo͕ɐݒ肷B
 */
#define	PORT2_INIT								\
	mov.l	#(H8S_BASE_ADDR + P2DDR), er0					\
	mov.b	#(P27DDR|P26DDR|P25DDR|P24DDR|P23DDR|P22DDR|P21DDR|P20DDR), r1l	\
	mov.b	r1l, @er0

/*
 *  DIPXCb`ALEDp}N
 */
#define dipsw_read()	h8s_reb_mem( (VP) P1DR )

#define led_read()	h8s_reb_mem( (VP) P2DR )
#define led_write(c)	h8s_wrb_mem( (VP) P2DR, c )

#endif /* _MISPO_H8S_2350_H_ */
