/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sfruart.c,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	OAKS32 UARTpVAI/OW[
 */
#include <s_services.h>
#include "oaks32.h"
#include <sfruart.h>

/*
 *  foCXI[ṽgCJEg
 *
 *  500񃊃gC΁A\ɏID
 */
#define	SFRUART_COUNT	500

/*
 * VARg[WX^̐ݒl 
 */
#define	MR_DEF		0x05	/* NbNA񓯊A8rbgApeBȂAX[vȂ */
#define MR_DISABLE_DEF	0x00	/* VAW[ */
#define	C0_DEF		0x10	/* RTS/CTSgp, JEg\[Xf1, Mݗv́uMobt@v */
#define	C1_DEF		0x00	/* VAM֎~ */
#define	BRG1_DEF	48	/* 30000000/{(UxBRG+1)*16} = 38400 */
#define	BRG2_DEF	97	/* 30000000/{(UxBRG+1)*16} = 19200 */

#define	TB_LEVEL	4	/* M݃x */
#define	RB_LEVEL	5	/* M݃x */
#define DISABLE_LEVEL	0	/* ݋֎~x */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	UH  cntrl_addr;	/* 䃌WX^̔Ԓn */
	UH  tic_addr;	/* Mݐ䃌WX^̔Ԓn */
	UH  ric_addr;	/* Mݐ䃌WX^̔Ԓn */

	UB  mr_def;	/* ftHg̐ݒl (MR) */
	UB  c0_def;	/* ftHg̐ݒl (C0) */
	UB  brg_def;	/* ftHg̐ݒl (BRG) */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT exinf;	/* g */
	UB     uc1;	/* M䃌WX^UiC1̐ݒl */
};

/*
 *  VAI/O|[gubN
 *
 *  ID = 1 uart0CID = 2 uart1ɑΉĂD
 */
static const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ TADR_SFR_UART0_BASE, (TADR_SFR_INT_BASE+TADR_SFR_S0TIC_OFFSET),
	  (TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET), MR_DEF, C0_DEF, BRG1_DEF },
#if TNUM_SIOP>1
	{ TADR_SFR_UART1_BASE, (TADR_SFR_INT_BASE+TADR_SFR_S1TIC_OFFSET),
	  (TADR_SFR_INT_BASE+TADR_SFR_S1RIC_OFFSET), MR_DEF, C0_DEF, BRG1_DEF }
#endif
};

/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOhCȍ[`
 */
void
sfruart_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->uc1 = C1_DEF;
		/*
		 * IɃ|[gsĂ
		 */
		/* 荞݋֎~ */
		sil_wrb_mem((VP)(siopcb->siopinib->tic_addr), DISABLE_LEVEL);
		sil_wrb_mem((VP)(siopcb->siopinib->ric_addr), DISABLE_LEVEL);
		/* M֎~ */
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);
	}
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sfruart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb;
	const SIOPINIB	*siopinib;
	int i;

	siopcb = get_siopcb(siopid);
	siopinib = siopcb->siopinib;

	/* M֎~ */
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET),
	   sil_reb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET))&~(TBIT_UiC1_TE | TBIT_UiC1_RE));

	/* |[gݒ(샂[hAʐMx) */
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UMR_OFFSET), siopinib->mr_def);
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UC0_OFFSET), siopinib->c0_def);
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UBRG_OFFSET), siopinib->brg_def);

	/*
	 *  VA݂̐ݒ
	 */
	sil_wrb_mem((VP)(siopinib->tic_addr), TB_LEVEL);
	sil_wrb_mem((VP)(siopinib->ric_addr), RB_LEVEL);

	/* I[v̓R[obN֎~ */
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);

	/*
	 * _~[f[^M
	 */
	sil_reb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_URB_OFFSET));
	sil_reb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_URB_OFFSET));

	for(i = 0 ; i < SFRUART_COUNT ; i++){	/* I[vMREADY܂ő҂ */
		if(sil_reb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)
			break;
	}

	siopcb->exinf = exinf;
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sfruart_cls_por(SIOPCB *siopcb)
{
	const SIOPINIB	*siopinib;

	siopinib = siopcb->siopinib;

	/* 荞݋֎~ */
	sil_wrb_mem((VP)(siopinib->tic_addr), DISABLE_LEVEL);
	sil_wrb_mem((VP)(siopinib->ric_addr), DISABLE_LEVEL);

	/* M֎~ */
	siopcb->uc1 = C1_DEF;
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);

	/* VAW[𖳌ɂ */
	sil_wrb_mem((VP)(siopinib->cntrl_addr+TADR_SFR_UMR_OFFSET), MR_DISABLE_DEF);
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
sfruart_snd_chr(SIOPCB *siopcb, char c)
{
	if(sil_reb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI){
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UTB_OFFSET), c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
sfruart_rcv_chr(SIOPCB *siopcb)
{
	if(sil_reb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_RI){
		return((INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_URB_OFFSET)));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sfruart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		siopcb->uc1 |= TBIT_UiC1_TE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);
		break;
	case SIO_ERDY_RCV:
		siopcb->uc1 |= TBIT_UiC1_RE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);
		break;
	default:
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sfruart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		siopcb->uc1 &= ~TBIT_UiC1_TE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);
		break;
	case SIO_ERDY_RCV:
		siopcb->uc1 &= ~TBIT_UiC1_RE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl_addr+TADR_SFR_UC1_OFFSET), siopcb->uc1);
		break;
	default:
		break;
	}
}

/*
 *  uart0̎M
 */
void serial_in_handler1(void)
{
	SIOPCB *siopcb = &siopcb_table[0];
	if((siopcb->uc1 & TBIT_UiC1_RE) != 0) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sfruart_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  uart0̑M
 */
void serial_out_handler1(void)
{
	SIOPCB *siopcb = &siopcb_table[0];

	if((siopcb->uc1 & TBIT_UiC1_TE) != 0) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		sfruart_ierdy_snd(siopcb->exinf);
	}
}

#if TNUM_SIOP > 1
/*
 *  uart1̎M
 */
void serial_in_handler2(void)
{
	SIOPCB *siopcb = &siopcb_table[1];
	if((siopcb->uc1 & TBIT_UiC1_RE) != 0){
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sfruart_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  uart1̑M
 */
void serial_out_handler2(void)
{
	SIOPCB *siopcb = &siopcb_table[1];
	if((siopcb->uc1 & TBIT_UiC1_TE) != 0) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		sfruart_ierdy_snd(siopcb->exinf);
	}
}
#endif
