/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006 by Monami Software Limited Partnership, JAPAN	
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */

/*
 *	vZbTˑW[ AZuꕔiM32Rpj
 */

#define	_MACRO_ONLY

#include <cpu_rename.h>

#include <m32rasm.inc>
#include <s_services.h>

#include "offset.h"

#define _trap_handler_0 _kernel__trap_handler_0
#define _trap_handler_1 _kernel__trap_handler_1
#define _trap_handler_2 _kernel__trap_handler_2
#define _trap_handler_3 _kernel__trap_handler_3
#define _trap_handler_4 _kernel__trap_handler_4
#define _trap_handler_5 _kernel__trap_handler_5
#define _trap_handler_6 _kernel__trap_handler_6
#define _trap_handler_7 _kernel__trap_handler_7
#define _trap_handler_8 _kernel__trap_handler_8
#define _trap_handler_9 _kernel__trap_handler_9
#define _trap_handler_10 _kernel__trap_handler_10
#define _trap_handler_11 _kernel__trap_handler_11
#define _trap_handler_12 _kernel__trap_handler_12
#define _trap_handler_13 _kernel__trap_handler_13
#define _trap_handler_14 _kernel__trap_handler_14
#define _trap_handler_15 _kernel__trap_handler_15

	.extern	_kernel_runtsk
	.extern	_kernel_schedtsk
	.extern	_kernel_reqflg
	.extern _kernel_enaflg
	.extern	InterruptHandlerEntry
	.extern	ExceptionHandlerEntry
	.extern	ext_tsk
		
/*
 *  EITxN^Gg̒`
 */
	.section ".vector","ax"
	.global	  reset
	.extern   start

	.balign 0x10
reset:
	bra		start

	.balign 0x10
vector_entry_SBI:
    /* 
	 *  VXeu[N
	 */
	bra 	vector_entry_SBI

	.balign 0x10
vector_entry_RIE:
    /* 
	 *  \񖽗ߗOiReserved Instruction Exceptionj
	 */
	stmdb	"r0,r1"
	ldi		r1, #(EXC_RIE*4-4)
	bra		_exception_handler

	.balign 0x10
vector_entry_AE:
    /* 
	 *  AhXOiAddress Exceptionj
	 */
	stmdb	"r0,r1"
	ldi		r1, #(EXC_AE*4-4)
	bra		_exception_handler

	.balign 0x10
vector_entry_trap:
    /*
	 *  gbvxN^Gg
	 */
	bra		_trap_handler_0
	bra		_trap_handler_1
	bra		_trap_handler_2
	bra		_trap_handler_3
	bra		_trap_handler_4
	bra		_trap_handler_5
	bra		_trap_handler_6
	bra		_trap_handler_7
	bra		_trap_handler_8
	bra		_trap_handler_9
	bra		_trap_handler_10
	bra		_trap_handler_11
	bra		_trap_handler_12
	bra		_trap_handler_13
	bra		_trap_handler_14
	bra		_trap_handler_15

/*
 *  ݃xN^GgƊ݃nhN^A
 *
 *  ݔ̃n[hEGA̓
 *
 *  pswWX^smCieCpmCcrbgbsmCbieCbpmCbcrbgɑޔ
 *  Dbpcɂ͊ݔpclD
 *
 *	bsm <- sm
 *  bie <- ie
 *  bpm <- pm
 *  bc <- c
 *  bpc <- ݔpcl
 *
 *	pswWX^smCieCpmCcrbgȉ̂悤ɍXVD
 *
 *	sm <- 0
 *  ie <- 0
 *  pm <- 0
 *  c <- 0
 *
 *@WX^̐ςݕ
 *  r0-r1iƗ̈j
 *  r0-r7Cr14Cacc(hi/lo)CbpcCpswCICUISTSCpswi݃nhďoOj
 *  
 *  ڂpswȊÓCݔ̃ReLXgɑΉX^bN
 *  ޔD2ڂpsẃC݃nh̎sɕA邽߂ɁC
 *  K݃X^bNɑޔDxfBXpb`ꍇɂ́CL
 *  WX^ȊOɂCr8-r13ޔăfBXpb`ĂяoD
 */
	.balign 0x10
interrupt_handler:

	/* 
	 *  ƗpWX^̑ޔ 
	 *
	 *  ŏɍƗpWX^X^bNɑޔDݔ́CK
	 *  ݃X^bNɂȂ̂ŁCőޔƗpWX^͊
	 *  ݃X^bNɐς܂D
	 */
	stmdb	"r0,r1"

	/* 
	 *  ݔ̃ReLXg
	 *
	 *  pswbsmrbg犄ݔɎgpĂX^bN擾
	 *  Dbsm0̏ꍇ́C݃X^bNgpĂƂɂȂ
	 *  ŁC݃ReLXgŊ݂ƔfDbsm1̏
	 *  ́C[UX^bNgpĂƂɂȂ̂ŁC^XNRe
	 *  LXgŊ݂ƔfD҂̏ꍇ́CƗ̈ir0
	 *  r1j̐ςݒ͕KvȂD
	 */
	mvfc	r0, psw
	and3	r1, r0, 0x8000
	beqz	r1, L1

	/* 
	 *  ޔWX^̃[UX^bNւ̐ςݒ  
	 *
	 *  ^XNReLXgŊ݂ꍇ́C݃X^bNɑ
	 *  ƗpWX^r0r1[UX^bNɐςݒKvD
	 */

	or3		r0, r0, 0x80		
	mvtc	r0, psw				/* [UX^bNɐؑցisp = spuj */

	mvfc	r1, spi
	ld		r0, @(4, r1)		/* ޔr0݃X^bNo */
	st		r0, @-sp			/* r0[UX^bNɐς */
	ld		r0, @r1				/* ޔr1݃X^bNo */
	st		r0, @-sp			/* r1[UX^bNɐς */
	addi	r1, 8				/* ݃X^bNƃX^bNޔOɖ߂ */
	mvtc	r1, spi				/* ݃X^bNʒuspiɕۑ */
	mvfc	r0, psw

L1:
	/* 
	 *  ReLXg̑ޔ
	 * 
	 *  r2-r7, r14, acch, accl, bpc, psw, ݃}XNiICUISTSj,psw
	 *  ̏ɃX^bNɑޔDł́CKpswr0ɕۑĂ
	 *  D
	 */
	stmdb	"r2,r3,r4,r5,r6,r7,r14"
	mvfachi	r1
	st		r1, @-sp			/* acchޔ */
	mvfaclo	r1
	st		r1, @-sp			/* acclޔ */
	mvfc	r1, bpc
	st		r1, @-sp			/* bpcޔ */
	st 		r0, @-sp			/* pswޔ */

	ld24	r1, ICUISTS
	ld		r0, @r1				/* ݃}XNǂݍ݁iݗv̓NAj*/
	st		r0, @-sp			/* ݃}XNޔ */

	lea		r1, InterruptHandlerEntry /* ݃nhe[u̐擪AhXo */
	srli	r0, 22				/* ݗvԍ擾 */
	addi	r0, -1				/* ݃nhe[ũCfbNXvZ */
	slli	r0, 2				/* ݃nhe[ũItZbgvZ */
	add		r1, r0				/* ݃nhe[ů݃nh̃AhXvZ */
	ld		r1, @r1				/* ݃nh̋NԒno */

L2:
	/*
	 *  ݃nȟďo
	 *
	 *  pswޔC݃X^bN, ݋ɂĊ݃nh
	 *  ĂяoD݃nh̖߂Ԓneit_handler_rƂD
	 *  ŁCēxpswޔ̂́Ceit_handler_r̍ŏŁCgp
	 *  X^bN߂Kv邽߂ŁCK݃X^bNɑޔĂ
	 *  D
	 */
	mvfc	r2, psw						
	and3	r3, r2, 0xff7f				
	mvtc	r3, psw						/* ݃X^bN */
	st		r2, @-sp					/* psw݃X^bNɑޔ */
	lea		r14, eit_handler_r 			/* ߂Ԓnݒ */
	or3		r3, r3, 0x40				
	mvtc	r3, psw						/* ݋ */
	jmp		r1							/* nhN */

	.text
	.align 4
eit_handler_r:
	/*
	 *  EITnh̕A
	 *
	 *  EITnh̎sIƌĂяoDݔ̃R
	 *  eLXgCݗv̗LCfBXpb`^֎~ԂCK
	 *  ؂ȕAsȂD
	 */
	ld		r0, @sp+
	mvtc	r0, psw			/* ݃X^bNpsw𕜋AiEIT
							   ̃ReLXgɖ߂D݂͋֎~ԁj
							    */

	ld24 	r1, ICUIMASK
	ld 		r2, @sp+
	st 		r2, @r1			/* ݃}XN̕A */

	and3	r0, r0, 0x8000
	beqz	r0, recover_int	/* EIT̃ReLXg݃ReL
							   Xgł΁Cd݂łƔfC
							   ɋʕA */

	/* 
	 *  ^XNReLXgւ̕A[`
	 *
	 *  fBXpb`^^XNONvȂꍇ́CɋʕA[
	 *  `ɔԁDxfBXpb`sȂDfBXpb`v
	 *  ΋ʂ̕Airecover_intjsȂD
	 */
	lea		r0, _kernel_reqflg
	ld		r1, @r0
	beqz	r1, recover_int		/* ʕA[` */

	/* 
	 *  fBXpb`^^XNONvꍇ̏
	 *
	 *  ܂CfBXpb`vtOireqflgjNADāCfB
	 *  Xpb`tOienadspjFALSȄꍇƁCruntskschedtsk 
	 *  ꍇɂ́CfBXpb`ɁC^XNON[`
	 *  ֔ԁDfBXpb`ĂCruntskschedtskقȂ
	 *  ꍇɂ́CxfBXpb`sD
	 */
	ldi		r1, #0
	st		r1, @r0				/* reqflgNA */

	lea 	r0,  _kernel_enadsp
	ld 		r0, @r0
	beqz 	r0, recover_task 	/* enaflg̃`FbN */

	lea		r0, _kernel_runtsk
	lea		r1, _kernel_schedtsk
	ld		r0, @r0	
    ld		r1, @r1
    beq		r0, r1, recover_task	/* runtskschedtskꍇ̓^
								       XNON */

	/*
	 *  O^ݏoł̒xfBXpb`
	 *
	 *  ޔĂȂc̃WX^ޔCsԃ^XNpcsp
	 *  ޔĂfBXpb`ĂяoD
	 */
	stmdb	"r8,r9,r10,r11,r12,r13"

	lea		r0, _kernel_runtsk
	ld		r0, @r0

	lea		r1, recover_task_r
	st		r1, @(TCB_pc, r0)
	st		sp, @(TCB_sp, r0)
	bra		_kernel_exit_and_dispatch

	.align 4
recover_task_r:
	ldmia	"r13,r12,r11,r10,r9,r8"

recover_task:
	/* 
	 *  ^XNON
	 *
	 *  ŁCenatexTRUEŁCtexptn0łȂ΁C^XNO[
	 *  `ĂяoDcalltex̏eiruntsk->enatexTRUEŁC
	 *  runtsk->texptn0łȂꍇɁCcall_texrtnĂԁjɃC
	 *  CWJǂC̊ȈՉ̂߂calltex 
	 *  ĂяoD
	 */
	bl		_kernel_calltex

recover_int:
	/* 
	 *  EITʕAiDx݂ւ̕A܂ށj
	 *
	 *  ޔԁir2-r7, r14, acch, accl, bpc, pswj̋tŃX^b
	 *  NoĕAD܂CƗpWX^ir0Cr1jA
	 *  D
	 */
	ld 		r0, @sp+
	mvtc 	r0, psw						/* psw𕜋A */
	ld		r0, @sp+			
	mvtc	r0, bpc						/* bpc𕜋A */
	ld		r0, @sp+	
	mvtaclo	r0							/* accl𕜋A */
	ld		r0, @sp+
	mvtachi	r0							/* acchl𕜋A */
	ldmia	"r14,r7,r6,r5,r4,r3,r2"		/* ̑̃WX^𕜋A */
	ldmia	"r1,r0"						/* ƗpWX^̕A */
	rte									/* ݏ畜A */

	.section ".vector","ax"
	/*
	 *  gbṽGg : gbvԍ̊i[
	 */
	.irp num,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
		.align	4

	_kernel__trap_handler_\num:
		stmdb	"r0,r1"
		ldi		r1, #((\num + EXC_TRAP00 - 1) * 4)
		bra		_exception_handler
	.endr
		
/*
 *  O^gbvnh
 *
 *  Oꍇɂ́CXNb`WX^ޔėOvir1
 *  ĂjɑΉOnhĂяoDOnh̕
 *  ÁC݃nh̕AƋʁieit_handler_rjłD
 *
 *  Õn[hEGA̓
 *
 *  pswWX^smCieCpmCcrbgbsmCbieCbpmCbcrbgɑޔ
 *  Dbpcɂ͗ON߂pclD
 *
 *	bsm <- sm
 *  bie <- ie
 *  bpm <- pm
 *  bc <- c
 *  bpc <- ON߂̃AhX
 *
 *	pswWX^smCieCpmCcrbgȉ̂悤ɍXVD
 *
 *	sm <- s
 *  ie <- 0
 *  pm <- 0
 *  c <- 0
 *
 *  WX^̐ςݕ
 *
 *  r0-r1iƗ̈CxN^̍ŏőޔj
 *  r2-r7Cr14Cacc(hi/lo)CbpcCpswCICUIMASKiOnhďoOj
 *
 *  ŁCICUISTSł͂ȂICUIMASKޔ̂́COɊO
 *  ݂ꍇɁCICUISTS̓Ǎ݂ɂ芄ݗvNA
 *  Ă܂̂h߂łD
 */
_exception_handler:

	stmdb 	"r2,r3,r4,r5,r6,r7,r14"
	mvfachi r0
	st 		r0, @-sp
	mvfaclo r0
	st 		r0, @-sp
	mvfc 	r0, bpc
	st 		r0, @-sp
	mvfc 	r2, psw
	st 		r2, @-sp
	ld24 	r0, ICUIMASK
	ld 		r0, @r0
	st 		r0, @-sp

	lea		r0, ExceptionHandlerEntry
	add		r0, r1
	ld		r1, @r0				/* Onh̃AhX擾 */

	mv 		r0, sp				/* X^bN̈ʒuOnḧ
								   ɐݒ */
	and3 	r3, r2, 0x7f00
	srli 	r3, 8
	mvtc 	r3, psw 			/* ݃X^bNC݋Ԃ */
	st 		r2, @-sp			/* Opsw݃X^bNɑޔ */
	lea 	r14, eit_handler_r 
	jmp 	r1
				
Function _kernel_dispatch
	/*
	 *  ^XNؑւ̂߂̑ޔ
	 *
	 *  ̃[`́C^XNReLXgCCPUbNԁCfBXpb
	 *  `ԂŌĂяoDďoł͕ۑȂWX^X^b
	 *  NɑޔCpcspTCBɑޔDpc̓fBXpb`o
	 *  idispatch_rjɐݒ肷D
	 */
	stmdb	"r8,r9,r10,r11,r12,r13,r14"

	lea 	r0, _kernel_runtsk
	lea		r1, dispatch_r
	ld		r0, @r0
	st		r1, @(TCB_pc, r0)		/* A鎞dispatch_rɋAĂ */
	st		sp, @(TCB_sp, r0)		/* X^bN|C^ޔ */

Function _kernel_exit_and_dispatch
	/*
	 *  ^XNؑւ̑O
	 *
	 *  schedtskłȂ`FbNDschedtskłȂꍇ́C
	 *  ^XNؑւɈڂD̏ꍇ́C݂ă[v
	 *  ɈڂD
	 */	
	xor		r0, r0
	mvtc	r0, psw						/* ݋֎~C݃X^bN */
	
	lea		r1,  _kernel_schedtsk
L6:	ld		r0, @r1
	bnez	r0, L7						/* schedtsk̗L`FbN */

	/* 
	 *  Nׂ^XNȂꍇ̏
	 *
	 *  Nׂ^XNȂꍇ́C݂ă[vD[
	 *  v̓rŊ݂Cs\^XN҂D
	 */
	ldi		r0, 0x40
	mvtc	r0, psw						/* ݋ */
	xor		r0, r0
	mvtc	r0, psw						/* ݋֎~ */

	lea 	r0, _kernel_reqflg
	xor 	r2, r2
	st 		r2, @r0 					/* reqflg = 0 */
	bl 		L6

L7:
    /* 
	 *  ^XNؑւ
	 *
	 *  s^XNiruntskjɍōD揇ʃ^XNischedtskjݒ肵C
	 *  X^bN[UX^bNɐؑւDruntskTCBsppc𕜋A
	 *  Dł́Cr0 = schedtskłD
	 */
	lea		r2, _kernel_runtsk
	st		r0, @r2 					/* runtsk = schedtsk */

	ldi 	r1, 0x80
	mvtc 	r1, psw 					/* [UX^bNC݋֎~ */

	ld		sp, @(TCB_sp, r0)			/* X^bN|C^𕜋A */
	ld		r0, @(TCB_pc, r0)			/* vOJE^𕜋A */
	jmp		r0

	.align 4
Label dispatch_r
	/* 
	 *  fBXpb`̏o
	 * 
	 *  dispatchőޔWX^𕜋AC^XNO[`
	 *  яoD
	 */
	bl 		_kernel_calltex 
    ldmia 	"r14,r13,r12,r11,r10,r9,r8" 
	rts

Function _kernel_activate_r
	/*
	 *  ^XN̋N[`
	 *
	 *  runtsk̃^XNubN^XN֐Ɗgo
	 *  āCgWX^ir0jɐݒ肷Dext_tskĂяo
	 *  Ƀ^XNIꍇ邽߁C^XN֐̖߂Ԓn
	 *  ext_tskɐݒ肷DNSĊĂC݂
	 *  ă^XN֐ɔԁD
	 */
	lea		r2, _kernel_runtsk
	ld		r2, @r2
	ld		r2, @(TCB_tinib, r2)		/* r2 = runtsk->tinib */
	ld		r0, @(TINIB_exinf, r2)
	ld		r1, @(TINIB_task,  r2)

	lea		r14, ext_tsk				/* ^XN̖߂Ԓnext_tsk */

	ldi 	r2, 0xc0
	mvtc 	r2, psw						/* [UX^bNC݋ */
	jmp		r1							/* ^XN֐ */
