/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

/*
 *  ^[QbgVXeˑW[ AZuꕔim3a_za36pj
 */

#define	_MACRO_ONLY

#include <m32rasm.inc>

/*
 *  gpSFR`
 */
#define BSEL0CR		0x00ef5000	/* BSEL0䃌WX^ */
#define SDRF0		0x00ef6000	/* SDRAMtbV䃌WX^0 */
#define SDRF1		0x00ef6004	/* SDRAMtbV䃌WX^1 */
#define SDIR0		0x00ef6008	/* SDRAMWX^0 */
#define SDIR1		0x00ef600c	/* SDRAMWX^1 */
#define SD0ADR		0x00ef6020	/* SDRAM0AhXWX^ */
#define SD0ER		0x00ef6024	/* SDRAM0ANZXCl[uWX^ */
#define SD0TR		0x00ef6028	/* SDRAM0^C~OWX^ */
#define SD0MOD		0x00ef602c	/* SDRAM0[hWX^ */
#define SD1ADR		0x00ef6040	/* SDRAM1AhXWX^ */
#define SD1ER		0x00ef6044	/* SDRAM1ANZXCl[uWX^ */
#define SD1TR		0x00ef6048	/* SDRAM1^C~OWX^ */
#define SD1MOD		0x00ef604c	/* SDRAM1[hWX^ */
#define MCCR		0xfffffffc	/* LbV䃌WX^ */
#define ICUIMASK	0x00eff01c	/* ݃}XNWX^	*/

/*
 *	SDRAMݒ}N`
 */
#define SDRF1_VAL	0x00010017	/* SDRAMtbV䃌WX^1ݒl	*/
#define	SDIR0_VAL	0x00000001	/* SDRAMWX^0ݒl			*/
#define	SD0ADR_VAL	0x04000004	/* SDRAM0AhXWX^ݒl			*/
#define SD0TR_VAL	0x00020102	/* SDRAM0^C~OWX^ݒl		*/
#define SD0MOD_VAL	0x00000020	/* SDRAM0[hWX^ݒl			*/

/*
 *	ubNZNgRg[̐ݒl
 */
#define BSEL0CR_VAL	0x01011100

/*
 *  n[hEFA
 *
 *  dataCbssZNVSDRAM̈ɔzuꍇɂ́CfobK
 *  SDRAMD̏ꍇ́Chardware_init_hookł͉ȂD
 */
#if 0
Function hardware_init_hook

	/*
	 * ubNZNgRg[̐ݒ
	 */
	mLdadr	r2, BSEL0CR_VAL
	ld24	r3, #BSEL0CR
	st		r2, @r3

	/*
	 *  LbV[h̐ݒ
	 */
	ldi	r0, #0x00   /* LbVOFF */
	ldi	r2, #MCCR	/* găAhX[h */
	st	r0, @r2		/* /f[^LbV[hI */

	/*
	 *  OSDRAM̐ݒ 
	 */
	/* --- SDRAM -- */
	ld24	r2, #SDIR0		/* SDRAMWX^0 */
	mLdadr	r3, SDIR0_VAL	/* v`[WEGCg(DPC)       3BCLK	*/
							/* I[gtbV(DARFC)     8		*/
							/* I[gtbVvԊu(DARFI) 8BCLK	*/
	st		r3, @r2		/* ݒ	*/

	ld24	r2, #SDIR1			/* H'00EF600c	*/
	ldi		r3, #0x00000001		/* Jn	*/
	st		r3, @r2

	/* --- SDRAMV[PX҂ -- */
wait_sdram:
	ldh		r3, @r2
	bnez	r3, wait_sdram		/* IH */

	/* -- SDRAM[hWX^ZbgR}hs */
	ld24	r2, #SD0MOD			/* SDRAM0[hWX^					*/
	mLdadr	r3, SD0MOD_VAL			/* o[Xg[h						*/
								/* CL=2									*/
								/* o[Xg^CvFV[PV		*/
								/* o[Xg							*/
	st		r3, @r2				/* ݒ	*/

	/* ---- SDRAM^C~OWX^ݒ -- */
	ld24	r2, #SD0TR			/* SDRAM^C~OWX^							*/
	mLdadr	r3, SD0TR_VAL		/* RASANeBu(DRAS)             3BCLK		*/
								/* RAS-CAS[eV(DRCD)             1BCLK		*/
								/* RASv`[W(DPCG)               1BCLK		*/
								/* CgJo(DWR)             2BCLK		*/
								/* SDRAMRg[CAS[eV(DCL) 2BCLK		*/
	st      r3, @r2			/* ݒ	*/

	/* --- SDRAM̈ݒ(H'0400000032MoCg,32bitBUS)	*/
	ld24	r2, #SD0ADR		/* SDRAM0AhXWX^							*/
	mLdadr	r3, SD0ADR_VAL		/* 擪AhX(DADR)         H'0400 xxxx			*/
								/* f[^oXI(DBSZ)     32rbg				*/
								/* `lTCYݒ(DSZ)    64MoCg				*/
	st		r3, @r2			/* ݒ	*/

	/* ---- I[gtbVLAvԊu:1344NbNɐݒ	*/
	ld24	r2, #SDRF1		/* SDRAMtbV䃌WX^1					*/
	mLdadr	r3, SDRF1_VAL		/* I[gtbV(DRFEN)	1(Lj			*/
								/* I[gtbVEFCg(DREFW) 8BCLK			*/
								/* I[gtbVvԊu(DRFC)  1344BCLK		*/
	st		r3, @r2

	/* SDRAMANZXL */
	ld24	r2, #SD0ER			/* SDRAMANZXCl[uWX^	*/
	ldi		r3, #0x01			/* ݒlWX^Ɋi[			*/
	st		r3, @r2
	rts
#endif
		
Function software_init_hook
	ld24 	r0, ICUIMASK + 1
	ldi 	r1, 7
	stb 	r1, @r0 			/* ݃}XNSɐݒ */
	rts
