/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 *	vZbTˑW[ AZuꕔiM68040pj
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ^XNfBXpb`
 *
 *  dispatch ́C}X^[hE݋֎~ԂŌĂяoȂ΂Ȃ
 *  Dexit_and_dispatch C}X^[hE݋֎~ԂŌĂяo
 *  ł邪CJ[lNɑΉ邽߁C݃[hŌĂяo
 *  ꍇɂΉĂD
 */
	.text
	.globl dispatch
	.globl exit_and_dispatch
dispatch:
	movem.l %d2-%d7/%a2-%a6, -(%sp)	/* WX^ۑ */
	move.l runtsk, %a0		/* A0  runtsk  */
	move.l %sp, TCB_msp(%a0)	/* ^XNX^bNۑ */
	move.l #dispatch_r, TCB_pc(%a0)	/* sĊJԒnۑ */
	jbra dispatcher

dispatch_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6	/* WX^𕜋A */
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq dispatch_r_1		/* enatex  FALSE Ȃ烊^[ */
	tst.l TCB_texptn(%a0)		/* texptn  0 łȂ           */
	jbne call_texrtn		/*   ^XNO[`̌ďo */
dispatch_r_1:
	rts

exit_and_dispatch:
	or.w #0x1000, %sr		/* }X^[h */
dispatcher:
	/*
	 *  ł̓}X^[hE݋֎~ԂłȂ΂ȂȂD
	 */
	move.l schedtsk, %a0
	move.l %a0, runtsk		/* schedtsk  runtsk  */
	jbeq dispatcher_1		/* runtsk 邩H */
	move.l TCB_msp(%a0), %sp	/* ^XNX^bN𕜋A */
	move.l TCB_pc(%a0), %a1		/* sĊJԒn𕜋A */
	jmp (%a1)
dispatcher_1:
	stop #0x2000			/* ݑ҂i݃[hj */
	/*
	 *  Ŋ݃[hɐ؂芷̂́CŔ銄ݏ
	 *  ɂǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *   stop߂́CIPM  0 ɂ邪C{ task_intmask 
	 *  ݒ肷ׂłDM68040 ł́Cstop ߂̃p[^ɒ萔
	 *  ƂȂ߁Cނ 0 ɂĂistop ߂ 8
	 *  ׂāCtask_intmask ̒lŔѕ͂邪C܂
	 *  Ӌ`͂ȂƍljD
	 *
	 *  vZbT҂[hɈڍs鏈ƁC݋Ƃ́C
	 *  sɍsȂKviM68040 ł stop߂ŗsȂ
	 *  ̂ŖȂjDsɍsȂȂꍇC݂
	 *  Ɋ݂C̒Ń^XNs\ԂɂȂ
	 *  ƁCsׂ^XNɂ炸vZbT҂[
	 *  hɂȂĂ܂D
	 *
	 *  ݂҂Ԃ́Cruntsk  NULLi=0jɐݒ肵Ȃ΂Ȃ
	 *  ȂD̂悤ɐݒ肵ȂƁC݃nh iget_tid 
	 *  Ăяoۂ̓삪dlɍvȂȂD
	 */
	or.w #0x1700, %sr		/* }X^[hE݋֎~ */
	tst.l reqflg			/* reqflg  FALSE Ȃ */
	jbeq dispatcher_1		/*      dispatcher_1  */
	clr.l reqflg			/* reqflg  FALSE  */
	jbra dispatcher
	
/*
 *  ^XNN
 */
	.text
	.globl activate_r
activate_r:
	/*
	 *  ^XNN̓^XNO֎~Ă邽߁CŃ^
	 *  XNO[`Ăяo͐藧ȂD
	 */
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ̏ */
	move.w %sr, %d0			/* ݃}XN task_intmask  */
	and.w #~0x0700, %d0
	or.w task_intmask, %d0
	move.w %d0, %sr
#else /* SUPPORT_CHG_IPM */
	and.w #~0x0700, %sr		/* ݋ */
#endif /* SUPPORT_CHG_IPM */
	move.l (%sp)+, %a0		/* ^XN̋NԒn a0  */
	jmp (%a0)

/*
 *  ݃nh^CPUOnho
 *
 *  ret_int ͊݃[hE݋֎~ԂŁCret_exc ̓}X^[hE
 *  ݋֎~ԂŌĂяoȂ΂ȂȂD܂ ret_exc ́CXNb
 *  `WX^ۑԂŌĂяoƁD
 */
	.text
	.globl ret_int
	.globl ret_exc
ret_int:
	addq.l #8, %sp			/* X[AEFCt[̂Ă */
	or.w #0x1000, %sr		/* }X^[h */
	movem.l %d0-%d1/%a0-%a1, -(%sp)	/* XNb`WX^ۑ */
ret_exc:
	clr.l reqflg			/* reqflg  FALSE  */
	move.l runtsk, %a0		/* A0  runtsk */
	tst.l enadsp			/* enadsp  FALSE Ȃ */
	jbeq ret_int_1			/*         ret_int_1  */
	cmp.l schedtsk, %a0		/* runtsk  schedtsk Ȃ */
	jbeq ret_int_1			/*                  ret_int_1  */
	movem.l %d2-%d7/%a2-%a6, -(%sp)	/* c̃WX^ۑ */
	move.l %sp, TCB_msp(%a0)	/* ^XNX^bNۑ */
	move.l #ret_int_r, TCB_pc(%a0)	/* sĊJԒnۑ */
	jbra dispatcher

ret_int_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6	/* WX^𕜋A */
ret_int_1:
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq ret_int_2			/* enatex  FALSE Ȃ烊^[ */
	tst.l TCB_texptn(%a0)		/* texptn  0 Ȃ烊^[ */
	jbeq ret_int_2
	jsr call_texrtn			/* ^XNO[`̌ďo */
ret_int_2:
#ifdef SUPPORT_CHG_IPM
	move.w 16(%sp), %d0		/* ߂̊݃}XN */
	and.w #~0x0700, %d0		/*        task_intmask  */
	or.w task_intmask, %d0
	move.w %d0, 16(%sp)
#endif /* SUPPORT_CHG_IPM */
	movem.l (%sp)+, %d0-%d1/%a0-%a1	/* XNb`WX^𕜋A */
	rte

/*
 *  ԑ҂
 */
	.globl _sil_dly_nse
_sil_dly_nse:
	subi.l #SIL_DLY_TIM1, %d0	/* D0  SIL_DLY_TIM1  */
	jbhi _sil_dly_nse_1		/* ʂ 0 ȉȂ烊^[ */
	rts
_sil_dly_nse_1:
	subi.l #SIL_DLY_TIM2, %d0	/* D0  SIL_DLY_TIM2  */
	jbhi _sil_dly_nse_1		/* ʂ 0 傫΃[v */
	rts
