/* 
 *
 *  TOPPERS/JSP Kernel
 *     Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 * L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 * ɂČ\Ă GNU General Public License  Version 2 ɋL
 * qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 * ς̂܂ށDȉjgpEEρEĔzziȉC
 * pƌĂԁj邱Ƃ𖳏ŋD
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *     \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *     XR[hɊ܂܂Ă邱ƁD
 * (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *     pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *     ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *     ̖ۏ؋Kfڂ邱ƁD
 * (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *     płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *     ƁD
 *   (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *       쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *   (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *       񍐂邱ƁD
 * (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *     QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 * {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 * TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 * ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 * ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#define _MACRO_ONLY
        
/*
 *  AvP[VƋʂ̃CN[ht@C
 */
#include <kernel.h>
                
/*
 *  ^[Qbgˑ̒`
 */
#include <t_config.h>

#include "jsp_kernel.h"
#include "offset.h"
#include <microblaze_asm.inc>
#include <microblaze.h>


/*
 * INTC̐݌vɂāC
 *
 *  ۑ郌WX^
 *  R3-R4   Return Valus        (Volatile)
 *  R5-R10  Passing parameters  (Volatile)
 *  R11-R12 Temporaries         (Volatile)
 *  R14     Return address for interrupt
 *  R15     Return address for Sub-routine
 *  R16     Return address for Trap(Debugger)
 *  R17     Return address for Exeptions
 * ?R18     Reserved for Assember    
 */

#define STACK_TOP (STACKTOP - 0x4) 

#define INTC_ISR (INTC_BASE + INTC_INT_STATUS_REG)
#define INTC_IPR (INTC_BASE + INTC_INT_PENDING_REG)
#define INTC_IER (INTC_BASE + INTC_INT_ENABLE_REG)
#define INTC_IAR (INTC_BASE + INTC_INT_ACK_REG)
#define INTC_SIE (INTC_BASE + INTC_SET_INT_ENABLE)
#define INTC_CIE (INTC_BASE + INTC_CLEAR_INT_ENABLE)
#define INTC_IVR (INTC_BASE + INTC_INT_VECTOR_REG)
#define INTC_MER (INTC_BASE + INTC_MASTER_ENABLE_REG)


/*
 *  OGg
 *  Not Support!
 */
	.text
	.globl exception_entry
	.align 2
exception_entry:
	nop
	



	.text
	.globl interrupt_entry
	.align 2
interrupt_entry:
/*
 * X^bN|C^̐؂ւKv
 */
	addik r1,r1,-64
	swi r3,  r1, 60
	swi r4,  r1, 56
	swi r5,  r1, 52
	swi r6,  r1, 48
	swi r7,  r1, 44
	swi r8,  r1, 40
	swi r9,  r1, 36
	swi r10, r1, 32
	swi r11, r1, 28
	swi r12, r1, 24
	swi r14, r1, 20
	swi r15, r1, 16
	swi r16, r1, 12
	swi r17, r1, 8
	swi r18, r1, 4
	mfs r3,  rmsr     /* msr̕ۑ */
	swi r3,  r1, 0

	lwi   r5,  r13, interrupt_count
	bgti  r5,  nest_int      /* lXg񐔂1ȏȂX^bN؂ւȂ */
	
	/*
	 * X^bN|C^؂ւ
	 */
	la    r4,  r0, STACK_TOP   /* ^XNƗ̃X^bN̓ǂݍ */
	sw    r1,  r0, r4          /* ^XNX^bN̕ۑ             */
	Mov   r1,  r4              /* X^bN|C^؂ւ         */
nest_int:
	/* 
     * ݃lXg񐔂̃CNg
	 */
	addi  r5,  r5,  1 
	swi   r5,  r13, interrupt_count

	lwi   r3,  r0, INTC_IVR    /* xN^̓ǂݍ                 */
	add   r3,  r3, r3          /* xN^4{                      */
	add   r3,  r3, r3	        
	lwi   r5,  r3, int_handler_table /* nhAhX̓ǂݍ */
	lwi   r6,  r3, int_bit_table     /* }XNrbg̓ǂݍ     */
	swi   r6,  r0, INTC_CIE          /* ݂}XN     */
	ori   r4,  r0, 0x02 | MSR_CACHE_SETTING /* r4 = 0x02           */
	Push  r6                         /* }XNrbgX^bN   */

	mts   rmsr,r4                    /* ݋(MSR(IE)Zbg)*/

	brald r15, r5             /* nhĂяo */
	 nop

    la    r4, r0, MSR_CACHE_SETTING  
	mts   rmsr,r4                    /* ݋֎~                 */

//    ori   r4,  r0, 0x03       /* r4 = 0x03                         */
//    swi   r4,  r0, INTC_MER   /* INTC_MER = 0x0 INTCX^[g       */

	Pop   r6                         /* }XNrbg̎o     */
//	swi   r6,  r0, INTC_IAR          /* ACK                        */        
	swi   r6,  r0, INTC_SIE          /* ݂̋           */

	/*
	 *  ݃lXg񐔂̃fNg
     */
	lwi   r5,  r13, interrupt_count
	addi  r5,  r5,  -1 
	swi   r5,  r13, interrupt_count
	
	bgti  r5,  ret_to_task_int      /* lXg񐔂1ȏȂ߂ */

	lw    r1,  r0, r1	            /* X^bN|C^߂    */  
	lwi   r4,  r13, reqflg          /* reqflg ̃`FbN         */
	beqi  r4,  ret_to_task_int      /* FALSE Ȃ ^XNɖ߂   */
	bri   ret_int                   /* TRUE Ȃ ret_int       */
ret_to_task_int:
	lwi  r3,  r1, 0
	mts  rmsr,r3
	lwi  r18, r1, 4
	lwi  r17, r1, 8
	lwi  r16, r1, 12
	lwi  r15, r1, 16
	lwi  r14, r1, 20
	lwi  r12, r1, 24
	lwi  r11, r1, 28
	lwi  r10, r1, 32
	lwi  r9,  r1, 36
	lwi  r8,  r1, 40
	lwi  r7,  r1, 44
	lwi  r6,  r1, 48
	lwi  r5,  r1, 52
	lwi  r4,  r1, 56
	lwi  r3,  r1, 60
	rtid r14,0 
	addik r1,r1,64



	/*
	 * o^݂̊ƌĂяo
	 * Not Yet!
	 */
	.globl no_reg_interrupt
	.align 2
no_reg_interrupt:
	nop


	/*
	 * ^XNfBXpb`
	 * 
	 * dispatch ́Cinterrupt_count = 0 
     * MSR IE=0 ̊݋֎~ԂŌĂяoȂ΂ȂȂD
	 * exit_and_dispatch lɁCinterrupt_count = 0 ݋֎~Ԃ
     * Ăяôł邪CJ[lNɑΉ邽߁C
     * interrupt_count = 1 ŌĂяoꍇɂΉĂD
	 *    
	 */
	
	.globl dispatch
	.align  2
dispatch:
	addi  r1,  r1,  -64  /* XNb`WX^ȊOۑ */
	swi   r15, r1,  60
	mfs   r3,  rmsr      /* msr̕ۑ(LbV̐ݒ̕ۑ) */
	swi   r3,  r1,  56                
	swi   r18, r1,  52   /* Kv? */
	swi   r19, r1,  48
	swi   r20, r1,  44
	swi   r21, r1,  40
	swi   r22, r1,  36
	swi   r23, r1,  32
	swi   r24, r1,  28
	swi   r25, r1,  24
	swi   r26, r1,  20
	swi   r27, r1,  16
	swi   r28, r1,  12
	swi   r29, r1,  8
	swi   r30, r1,  4
	swi   r31, r1,  0
	lwi   r4 , r13, runtsk     /* r4 <- runtsk */
	swi   r1 , r4,  TCB_sp 	   /* ^XNX^bNTCBɕۑ */	
	la    r5 , r0,  dispatch_r /* sĊJԒnۑ */
	swi   r5 , r4,  TCB_pc     /* sĊJԒnTCBɕۑ   */
	bri   dispatcher

dispatch_r:
	lwi  r31,  r1, 0      /* WX^𕜋A */
	lwi  r30,  r1, 4
	lwi  r29,  r1, 8
	lwi  r28,  r1, 12
	lwi  r27,  r1, 16
	lwi  r26,  r1, 20
	lwi  r25,  r1, 24
	lwi  r24,  r1, 28
	lwi  r23,  r1, 32
	lwi  r22,  r1, 36
	lwi  r21,  r1, 40
	lwi  r20,  r1, 44
	lwi  r19,  r1, 48
	lwi  r18,  r1, 52
    lwi  r3,   r1, 56   /* MSR߂(LbV̐ݒ߂) */
    mts  rmsr,r3            
	addi r1,   r1, 60   /* X^bN|C^߂ */
	/*
	 *  ^XNO[`̋N
	 *  dispatch_r  dispatcher Ăяo邽߁C
	 *  tcb ̃AhX r4 ɓĂ
     *  Not Yet!
	 */
	lwi  r5,  r4,  TCB_enatex  /* r5 <- enatex                 */
	andi r6,  r5,  TCB_enatex_mask  
	beqi r6,  dispatch_r_1     /* enatex  FALSE Ȃ烊^[ */
	lwi  r7,  r4,  TCB_texptn  /* r5 <- texptn                 */
	beqi r7,  dispatch_r_1     /* texptn  0 łȂ       */
	brlid r15  call_texrtn     /* ^XNO[`̌Ăяo */	
	 nop
dispatch_r_1:
	Pop     r15
	rtsd	r15,8 
	 nop



	.globl exit_and_dispatch
exit_and_dispatch:
	/* interrupt_count NA */
	swi   r0,  r13, interrupt_count 
dispatcher:
	/*
	 * ͊݋֎~ŗ邱
	 */
	lwi  r4,  r13, schedtsk  /* r4 <- schedtsk              */
	swi  r4,  r13, runtsk    /* schedtsk  runtsk        */        
	beqi r4,  dispatcher_1   /* schedtsk 邩           */
	lwi  r1,  r4,  TCB_sp    /* TCB^XNX^bN𕜋A */
	lwi  r5,  r4,  TCB_pc    /* TCBsĊJԒn𕜋A   */
	bra  r5	  
dispatcher_1:
	/*
	 * Ŋ݃[hɐ؂ւ̂́CŔ銄ݏ
     * ɂǂ̃X^bNgƂ̉ƁC݃nh
	 * ̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 */
	la   r1,  r0,  STACKTOP         /* ݃X^bNɕύX             */
	la   r6,  r0,  1                /* interrupt_count 1            */
	swi  r6,  r13, interrupt_count
	la   r5,  r0, 0x02 | MSR_CACHE_SETTING /* IE = '1'               */
	la   r4,  r0, MSR_CACHE_SETTING        /* IE = '0'               */        
dispatcher_2:
	mts   rmsr, r5   /* ݋(MSR(IE)Zbg)      */
	nop
	nop
	mts   rmsr, r4                  /* ݋֎~(MSR(IE)NA)      */
	lwi   r6,  r13,  reqflg         /* r6 <- reqflg                     */
	beqi  r6,  dispatcher_2         /* reqflg  FALSE Ȃ             */
	swi   r0,  r13, interrupt_count /* interrupt_count NA         */
	swi   r0,  r13,  reqflg         /* reqflg  FALSE                */	
	bri   dispatcher

	/*
	 *  ݃nh/CPUOnho
	 * 
	 * ߂悪^XN reqflg ZbgĂꍇ݂̂ɂD
	 * interrupt_count = 0C݋֎~ԁCXNb`WX^ۑ
	 * ԂŌĂяoƁD
	 */
	.align 2
	.globl ret_int
	.globl ret_exc
ret_exc:
ret_int:
	swi  r0,  r13,  reqflg   /* reqflg  FALSE  */
	lwi  r4,  r13,  runtsk   /* r4 <- runtsk        */
	lwi  r6,  r13,  enadsp   /* r6 <- enadsp        */
	beqi r6,  ret_int_1      /* enadsp  FALSE Ȃ ret_int_1  */
	lwi  r5,  r13,  schedtsk /* r5 <- schedtsk                    */
	sub  r6,  r5,   r4       /* runtsk  schedtsk Ȃ     */
	beqi r6,  ret_int_1      /* ret_int_1                       */
	addi  r1,  r1,  -52      /* c̃WX^ۑ          */
	swi   r19, r1,  48
	swi   r20, r1,  44
	swi   r21, r1,  40
	swi   r22, r1,  36
	swi   r23, r1,  32
	swi   r24, r1,  28
	swi   r25, r1,  24
	swi   r26, r1,  20
	swi   r27, r1,  16
	swi   r28, r1,  12
	swi   r29, r1,  8
	swi   r30, r1,  4
	swi   r31, r1,  0	
	swi   r1 , r4,  TCB_sp 	   /* ^XNX^bNTCBɕۑ */	
	la    r6 , r0,  ret_int_r  /* sĊJԒnۑ */
	swi   r6 , r4,  TCB_pc     /* sĊJԒnTCBɕۑ   */
	bri   dispatcher

ret_int_r:	
	lwi  r31,  r1,  0      /* WX^𕜋A */
	lwi  r30,  r1,  4
	lwi  r29,  r1,  8
	lwi  r28,  r1,  12
	lwi  r27,  r1,  16
	lwi  r26,  r1,  20
	lwi  r25,  r1,  24
	lwi  r24,  r1,  28
	lwi  r23,  r1,  32
	lwi  r22,  r1,  36
	lwi  r21,  r1,  40
	lwi  r20,  r1,  44
	lwi  r19,  r1,  48
	addi r1,   r1,  52
	lwi  r3,   r1,   0    /* MSR ߂iLbV̐ݒ߂j*/
	mts  rmsr, r3                
ret_int_1:
	/*
	 * ^XNO[`̋N
	 * ret_int_r  dispatcher Ăяo邽߁C
	 * tcb ̃AhX r4 ɓĂ
	 */
	lwi  r5,  r4,  TCB_enatex  /* r5 <- enatex                 */
	andi r6,  r5,  TCB_enatex_mask  
	beqi r6,  ret_int_2        /* enatex  FALSE Ȃ烊^[ */
	lwi  r7,  r4,  TCB_texptn  /* r5 <- texptn                 */
	beqi r7,  ret_int_2        /* texptn  0 łȂ       */
	brlid r15  call_texrtn     /* ^XNO[`̌Ăяo */	
	 nop
ret_int_2:
	lwi  r3,  r1, 0    /* MSR ߂iIE=0Ŋ݋֎~ɂȂj*/
	mts  rmsr,r3
	lwi  r18, r1, 4
	lwi  r17, r1, 8
	lwi  r16, r1, 12
	lwi  r15, r1, 16
	lwi  r14, r1, 20
	lwi  r12, r1, 24
	lwi  r11, r1, 28
	lwi  r10, r1, 32
	lwi  r9,  r1, 36
	lwi  r8,  r1, 40
	lwi  r7,  r1, 44
	lwi  r6,  r1, 48
	lwi  r5,  r1, 52
	lwi  r4,  r1, 56
	lwi  r3,  r1, 60
	rtid r14,0 
	 addik r1,r1,64	



	/*
	 * ^XNN
     *   
     *  X^bN̎
     *  Microblaze Processor Reference Guide 52`53
     *  ֐ďốCr5`r10 Ɋi[D
     *  ƓɌďo̓X^bNt[Ɉ̊i[ꏊmۂKv
     *  Dɂ̏ɂ̓NWX^(R15)̗̈̕悪KvƂȂD
     *  ďo͍Xɑ̊֐Ăяoꍇ r5`r10 ̗̈ɕۑ
     * D
     *  Low Address
     *             --------------------
     *  new_sp -> | Link Register(R15) |
     *             --------------------
     *            |   Arg1p̗̈     |
     *             --------------------
     *            |   Arg2p̗̈     |
     *             --------------------        
     *            |      ....          |
     *             --------------------
     *  High Address
	 */

	.text
	.globl activate_r
	.align 2
activate_r:
	ori   r4,  r0, 0x02 | MSR_CACHE_SETTING  /* msȑl        */
	mts   rmsr,r4              /* ݋(MSR(IE)Zbg)      */
    lw    r11, r1, r0          /* ^XN̎sԒn                 */
    lwi   r5,  r1,  4          /* iexinfj                    */
	la    r15, r0,  ext_tsk -8 /* ^XN̖߂               */
	bra   r11                  /* ^XN̎sJn                 */


        
    /*
     * ԑ҂
     */
     .globl _sil_dly_nse
_sil_dly_nse:
     addi   r5, r5, -SIL_DLY_TIM1
     bgti   r5, _sil_dly_nse_1
     rtsd   r15, 8
      nop  
_sil_dly_nse_1:
     addi   r5, r5, -SIL_DLY_TIM2
     bgti   r5, _sil_dly_nse_1
     rtsd   r15, 8
      nop          
