/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: microblaze.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*                                                                              * Microblaze WytFphCo
 */
#include <s_services.h>
#include <microblaze.h>


/*
 * UART Litep ȈՃhCo
 */

/*                                                                       
 * VAI/O|[gubN                                         
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {{}};

/*                                                                      
 *  VAI/O|[gǗubÑGA                                
 */
SIOPCB  siopcb_table[TNUM_SIOP];

/*                                                                          
 *  VAI/O|[gIDǗubNo߂̃}N                  
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))

Inline void
uart_ena_int(void){
  sil_wrw_mem((VP)UARTLITE_CTREG,
              sil_rew_mem((VP)UARTLITE_CTREG) | UARTLITE_ENABLE_INTR);
}

Inline void
uart_dis_int(void){
  sil_wrw_mem((VP)UARTLITE_CTREG,
              sil_rew_mem((VP)UARTLITE_CTREG) & ~UARTLITE_ENABLE_INTR);
}

/*
 * M?                                                       
 */
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    return((sil_rew_mem((VP)UARTLITE_SRREG) &
            UARTLITE_RX_FIFO_VALID_DATA) != 0);

}

/*                                                                             
 * 𑗐Mł邩?                                                         
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
  return((sil_rew_mem((VP)UARTLITE_SRREG) & UARTLITE_TX_FIFO_FULL) == 0);
}

/*                                                                             
 *  M̎o                                                     
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return((UB)sil_rew_mem((VP)UARTLITE_RXREG));
}

/*                                                                            
 *  M镶̏                                                    
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
  sil_wrw_mem((VP)UARTLITE_TXREG, c);
}

/*
 * M֐
 * UART Lite ɂ͑M݂ʂɋ֎~@\͂Ȃ
 * ̂߁CMIɂ͕K1񊄍݂  
 */
/*                                                                             
 *  M݋                                                             
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
  
}

/*                                                                             
 *  M݋֎~                                                             
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{

}


/*                                                                             
 *  SIOhCȍ[`                                                
 *  1|[gȂ߁C܂Ӗ͂Ȃ                                      
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*                                                                         
     *  VAI/O|[gǗubN̏                                  
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}


SIOPCB   *
uart_opn_por(ID siopid, VP_INT exinf){

    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    /*
     *  Mobt@NA
     */
    sil_wrw_mem((VP)UARTLITE_CTREG, UARTLITE_RST_RX_FIFO
                | UARTLITE_RST_TX_FIFO | UARTLITE_ENABLE_INTR);
    
//    sil_wrw_mem((VP)UARTLITE_CTREG, UARTLITE_RST_RX_FIFO
//                | UARTLITE_RST_TX_FIFO );
    
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}


void
uart_cls_por(SIOPCB *siopcb){
  sil_wrw_mem((VP)UARTLITE_CTREG, ~UARTLITE_ENABLE_INTR);   /* ݋֎~    */
  siopcb->openflag = FALSE;
  siopcb->sendflag = FALSE;
}



/*                                                                             
 *  VAI/O|[gւ̕M                                            
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, INT chr)
{
    if(uart_putready(siopcb)){
        uart_putchar(siopcb, (UB) chr);
        return(TRUE);
    }
    return(FALSE);
}


/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  OPB_UARTLITE ͑MƎM݂ʂɋ/֎~@\͎Ȃ
 */

/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{

}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{

}


/*                                                                            
 *  VAI/O|[gɑ΂銄ݏ                                       
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    /*
     * GbŴ݂ߊݏOACK
     */
    intc_ack_interrupt(1 << (UARTINTLVL - 1));
    
    if (uart_getready(siopcb)) {
        /*
         *  MʒmR[obN[`ĂяoD
         */
        uart_ierdy_rcv(siopcb->exinf);
    }

    if (uart_putready(siopcb)) {
        /*
         *  M\R[obN[`ĂяoD
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*                                                                             
 *  SIO̊݃T[rX[`                                                
 */
void
uart_isr()
{
    if (siopcb_table[0].openflag) {
        uart_isr_siop(&(siopcb_table[0]));
    }
}

