/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include <cpu_insn.h>

/*
 *  chg_ipm/get_ipm T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#ifndef _MACRO_ONLY

/*  ^XNReLXgubN̒`  */
typedef struct task_context_block {
        VP	sp;             /* X^bN|C^ */
        FP	pc;             /* vOJE^ */
} CTXB;

#endif /* _MACRO_ONLY */

/*  TCB ̃tB[h̃rbg̒`  */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */

/*
 *  VXeԎQ
 */

#ifndef _MACRO_ONLY

/*
 *  ReLXgQ
 *    ݃lXgJE^ǂݏoɊ݂ĂA߂Ƃɂ
 *    ReLXgɖ߂ĂB
 */
Inline BOOL sense_context() {

	UW intnest;

	Asm("move %0, "str_k0 :"=r"(intnest));

	return(intnest > 0);
}

Inline BOOL sense_lock() {

	return(!(current_sr() & SR_IE));
}

#endif /* _MACRO_ONLY */

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *    CPUbNԂ̔f́AXe[^XWX^IErbgpĔfĂB
 */

#ifndef _MACRO_ONLY

Inline void t_lock_cpu() {

	disint();		/* cpu_insn.h */
}

Inline void t_unlock_cpu() {

	enaint();		/* cpu_insn.h */
}

#endif /* _MACRO_ONLY */

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

#define i_lock_cpu	t_lock_cpu
#define i_unlock_cpu	t_unlock_cpu

/*
 *  ^XNfBXpb`
 */

#ifndef _MACRO_ONLY

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *    dispatch ́A^XNReLXgĂяoꂽT[rXR[ŁA
 *    CPUbNԂŌĂяoȂ΂ȂȂB
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *    exit_and_dispatch ́ACPUbNԂŌĂяoȂ΂ȂȂB
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*  ݃nh^݃}XN[e[u  */
extern INT_TABLE int_table[ TMAX_ALL_INTNO ];

/*  Onh[e[u  */
extern FP	 exc_table[ TMAX_CORE_EXCNO ];

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ(ݗvԍ)intno ̊݃nh̋NԒninthdrɐݒB
 */

Inline void define_inh(INTNO intno, FP inthdr) {

	int_table[intno].inthdr = inthdr;
}

/*
 *   CPUOnh̐ݒ
 */

Inline void define_exc(EXCNO excno, FP exchdr) {

	exc_table[excno] = exchdr;
}

#endif /* _MACRO_ONLY */

/*
 *  ݃nh̏o̐}N
 */

#define	INTHDR_ENTRY(inthdr)  extern void inthdr(void)
#define INT_ENTRY(inthdr) inthdr

/*
 *  CPUOnh̏o̐}N
 *
 */
#define	EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)
#define	EXC_ENTRY(exchdr)     exchdr

/*
 *  CPUO̔̃VXeԂ̎Q
 */

#ifndef _MACRO_ONLY

/*
 *  CPUO̔̃ReLXg
 */
Inline BOOL exc_sense_context(VP p_excinf) {

	UW  nest;

	Asm( "move %0, "str_k0 : "=r"(nest) );

	return( nest > 1 );
		/* 1Ɣr̂́AݎsCPUO݃̕lXg
		   JE^CNgĂ邽 */
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL exc_sense_lock(VP p_excinf) {

	/* StatusWX^́AX^bN22Ԗڂɐς܂ĂB
	   exc_stack(mips3.h), cpu_support.S Q */
	return( !( *((UW *)p_excinf + 21) & SR_IE) );
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*  vZbTRA{݃Rg[ɐݒ肷銄݃}XÑ`FbN  */
#define CHECK_IPM(ipm)	     CHECK_CORE_IPM( (ipm.core >> 8) & 0xff );	\
			     CHECK_ICU_IPM( ipm.icu )

#ifndef _MACRO_ONLY

/*
 *  荞݃x̐ݒiʕ͌ĂяoȂj
 */

Inline void all_set_ilv(INTNO intno, IPM *ipm) {

	/*  MIPSRA intmask e[u̐ݒ  */
	int_table[intno].intmask = SR_BEV | (ipm->core) | SR_IE;
			/* ݃xN^Akseg1ɎĂ邽߁ABEV=1 */

	/*  ݃Rg[̊݃}XNe[u̐ݒ  */
	/*  i݃x̐ݒj  */
	icu_set_ilv( intno, &(ipm->icu) );
}

#endif /* _MACRO_ONLY */

/*
 *  Oo͗p̊֐
 */

#ifndef _MACRO_ONLY

/* o^ĂȂ݁EÕOo (cpu_config.c, cpu_support.S) */
extern void     cpu_experr( EXCSTACK *sp, UW SR, UW CR );

#endif /* _MACRO_ONLY */

#endif /* _CPU_CONFIG_H_ */
