/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _MIPS3_H_
#define _MIPS3_H_

#include <util.h>

/*
 *  MIPS3 p`
 */

/* CPURA̓WX^̖ */
#define zero    $0      /* 펞[ */
#define at      $1      /* AZũe| */
#define v0      $2      /* ֐̖߂l */
#define v1      $3
#define a0      $4      /* ֐̈ */
#define a1      $5
#define a2      $6
#define a3      $7
#define t0      $8      /* e|WX^ tx (x=0-9)F֐ĂяoŔj */
#define t1      $9
#define t2      $10
#define t3      $11
#define t4      $12
#define t5      $13
#define t6      $14
#define t7      $15
#define s0      $16     /* sx (x=0-7) : ֐ĂяoŕsςȃWX^ */
#define s1      $17
#define s2      $18
#define s3      $19
#define s4      $20
#define s5      $21
#define s6      $22
#define s7      $23
#define t8      $24     /* e|WX^ tx (x=0-9)F֐ĂяoŔj */
#define t9      $25
#define k0      $26     /* OSpɗ\ς */
#define kt0     $26
#define k1      $27
#define kt1     $27
#define gp      $28     /* ϐ̈̃x[XAhX */
#define sp      $29     /* X^bN|C^ */
#define fp      $30     /* t[|C^ */
/*  */
#define s8      $30     /* s8 : ֐ĂяoŕsςȃWX^ */
#define ra      $31     /* ֐̖߂AhX */

/* CP0̓WX^̖ */
#define Index           $0
#define Random          $1
#define EntryLo0        $2
#define EntryLo1        $3
#define Context         $4
#define PageMask        $5
#define Wired           $6
#define Error           $7
#define BadVAddr        $8
#define Count           $9
#define EntryHi         $10
#define Compare         $11
#define Status          $12
#define Cause           $13
#define EPC             $14
#define PRId            $15
#define Config          $16
#define LLAddr          $17
#define WatchLo         $18
#define WatchHi         $19
#define XContext        $20
/* $21-$24 - \ */
#define Performance     $25
#define ParityErr       $26
#define CacheErr        $27
#define TagLo           $28
#define TagHi           $29
#define ErrorEPC        $30
/* $31 - \ */

/*  CCAZuŎgꍇ̒`  */
#define str_k0		"$26"
#define str_Status	"$12"

/*  Xe[^XWX^֌W  */
#define SR_IE		BIT0			/*  IErbg  */
#define SR_EXL		BIT1			/*  EXLrbg  */
#define SR_ERL		BIT2			/*  ERLrbg  */

#define SR_EXL_IE	(SR_EXL | SR_IE)	/*  EXL,IErbg  */
#define SR_ERL_EXL	(SR_ERL | SR_EXL)	/*  ERL,EXLrbg  */
#define SR_ERL_EXL_IE	(SR_ERL_EXL | SR_IE)	/*  ERL,EXL,IErbg  */
#define SR_IM		0xff00			/*  IMrbgo}XN  */

#define SR_UX		BIT5			/*  UXrbg  */
#define SR_SX		BIT6			/*  SXrbg  */
#define SR_KX		BIT7			/*  SXrbg  */
#define SR_DE		BIT16			/*  DErbg  */
#define SR_SR		BIT20			/*  SRrbg  */
#define SR_BEV		BIT22			/*  BEVrbg  */
#define SR_RE		BIT25			/*  RErbg  */
#define SR_CU0		BIT28			/*  CU0rbg  */
#define SR_CU1		BIT29			/*  CU1rbg  */
#define SR_CU2		BIT30			/*  CU2rbg  */
#define SR_XX		BIT31			/*  XXrbg  */

/*  WX^֌W  */
#define Cause_IP0       BIT8    /*  IP0rbg  */
#define Cause_IP1       BIT9    /*  IP1rbg  */
#define Cause_IP2       BIT10   /*  IP2rbg  */
#define Cause_IP3       BIT11   /*  IP3rbg  */
#define Cause_IP4       BIT12   /*  IP4rbg  */
#define Cause_IP5       BIT13   /*  IP5rbg  */
#define Cause_IP6       BIT14   /*  IP6rbg  */
#define Cause_IP7       BIT15   /*  IP7rbg  */

/*  O荞݂ɑ΂IPrbg̕ʖ  */
#define Cause_Int0	Cause_IP2  /*  Int0vrbg  */
#define Cause_Int1	Cause_IP3  /*  Int1vrbg  */
#define Cause_Int2	Cause_IP4  /*  Int2vrbg  */
#define Cause_Int3	Cause_IP5  /*  Int3vrbg  */
#define Cause_Int4	Cause_IP6  /*  Int4vrbg  */

/*  WX^猴R[ho}XN  */
#define ExcCode_mask    0x7c

/* OR[h */
#define Int     0       /* 荞ݗO */
#define Mod     1       /* TLBύXO */
#define TLBL    2       /* TLBsvO ([h܂͖߃tFb`) */
#define TLBS    3       /* TLBsvO (XgA) */
#define AdEL    4       /* AhXG[O ([h܂͖߃tFb`) */
#define AdES    5       /* AhXG[O (XgA) */
#define IBE     6       /* oXG[O (߃tFb`) */
#define DBE     7       /* oXG[O (f[^̃[h܂̓XgA) */
#define Sys     8       /* VXeR[O */
#define Bp      9       /* uCN|CgO */
#define RI      10      /* \񖽗ߗO */
#define CpU     11      /* RvZbTgpsO */
#define Ov      12      /* ZI[o[t[O */
#define Tr      13      /* gbvO */
/* 14 - \ */
#define FPE     15      /* _O */
/* 16-22 - \ */
#define WATCH   23      /* EHb`O */
/* 24-31 - \ */

/*  ݗvԍ  */
#define INTNO_IP0               0
#define INTNO_IP1               1
#define INTNO_IP2               2
#define INTNO_IP3               3
#define INTNO_IP4               4
#define INTNO_IP5               5
#define INTNO_IP6               6
#define INTNO_IP7               7

/*  RÅ݂̖{i\tgEFA݂܂ށj */
#define TMAX_CORE_INTNO		8

/*
 *  MIPS3RÃXe[^XWX^ɐݒ\ȍō݋rbgp^[
 */
#define MAX_IPM  0xff

/*
 *  MIPS3RAɐݒ肷銄݃}XÑ`FbN
 */
#define CHECK_CORE_IPM(ipm)  CHECK_PAR(0 <= (ipm) && (ipm) <= MAX_IPM)

/*
 *  CPUO̎ސ
 */
#define TMAX_CORE_EXCNO	32u

/*
 *  Oõ͎X^bN\̒`
 *    cpu_config.hɂcpu_experr֐Acpu_support.SQƂ̂ƁB
 */
#ifndef _MACRO_ONLY

typedef struct exc_stack {

	/*  WX^Q̒`  */
	UW	sp;
	UW	at;
	UW	v0;
	UW	v1;
	UW	a0;
	UW	a1;
	UW	a2;
	UW	a3;
	UW	t0;
	UW	t1;
	UW	t2;
	UW	t3;
	UW	t4;
	UW	t5;
	UW	t6;
	UW	t7;
	UW	t8;
	UW	t9;
	UW	gp;
	UW	fp;
	UW	ra;

	UW	CP0_Status;
	UW	CP0_EPC;

	UW	hi;
	UW	lo;

} EXCSTACK;

#endif /* _MACRO_ONLY */

#endif /* _MIPS3_H_ */
