/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _MIPS3_SIL_H_
#define _MIPS3_SIL_H_

#include <kz_vr4131pci_01.h>	/* VR4131_BASE_ADDR */

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

/*
 *  VR4131pʃANZXC^tF[X
 */
#define vr4131_reb_mem(x)	sil_reb_mem( (VP)(VR4131_BASE_ADDR + x) )
#define vr4131_wrb_mem(x, y)	sil_wrb_mem( (VP)(VR4131_BASE_ADDR + x), y )

#define vr4131_reh_mem(x)	sil_reh_mem( (VP)(VR4131_BASE_ADDR + x) )
#define vr4131_wrh_mem(x, y)	sil_wrh_mem( (VP)(VR4131_BASE_ADDR + x), y )

/* AZup SIL */
#define ASM_SIL(x)	(VR4131_BASE_ADDR + x)

/*
 *  VR4131pʃWX^֐
 */
#define vr4131_orb( mem, val )	vr4131_wrb_mem( mem, vr4131_reb_mem( mem ) | val )
#define vr4131_andb( mem, val )	vr4131_wrb_mem( mem, vr4131_reb_mem( mem ) & val )

#define vr4131_orh( mem, val )	vr4131_wrh_mem( mem, vr4131_reh_mem( mem ) | val )
#define vr4131_andh( mem, val )	vr4131_wrh_mem( mem, vr4131_reh_mem( mem ) & val )

#endif /* _MIPS3_SIL_H_ */
