/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  vZbTˑW[ AZuꕔiPowerPCpj
 *@@@@@J[lŎgp`
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  TCB\̂̃ItZbg̃`FbN
 *@@@15rbgɎ܂ĂȂƕgNA
 *@@@҂铮ɂȂȂB
 */
#define CHECK_OFFSET(offset)	(((offset)&~0x8fff) != 0)
#if CHECK_OFFSET(TCB_pc) || CHECK_OFFSET(TCB_sp) 		\
    || CHECK_OFFSET(TCB_enatex) || CHECK_OFFSET(TCB_texptn) 	\
    || CHECK_OFFSET(TCB_tinib) || CHECK_OFFSET(TINIB_task) 	\
    || CHECK_OFFSET(TINIB_exinf) 
	ŃRpCG[
#endif


/*
 *@ȎOőޔ郌WX^
 *@@@ėpWX^Fgpr0-1,3-12
 *@@@ꃌWX^FLR,CTR,XER,SRR0,SRR1
 */
#define NUM_REG			17

/*  WX^Ҕ̂ɕKvȃoCg  */
#define GPR0_12_SPRG_AREA_SIZE  (NUM_REG*4 + 4)  
		/*  +4͗OvԍۑXy[X  */
		/*  ӁF4oCgEɂȂĂ  */

#define GPR13_31_AREA_SIZE      (19*4)  /*  gpr13-31  */

    /*
     *@
     *@@@MPC860͕_WX^Ȃ߁A̕
     *@@@eXgĂȂ
     */
#ifdef SUPPORT_FLOATING_POINT_REG
/*  n[hEFAŕ_WX^Ăꍇ  */
#define FPR_AREA_SIZE       (32*8+8)    /*  fpr0-31,FPSCR  */
#define FPR0_13_AREA_SIZE   (14*8+8)    /*  fpr0-14,FPSCR  */
#define FPR14_31_AREA_SIZE  (18*8)      /*  fpr15-31  */

#else   /*  SUPPORT_FLOATING_POINT_REG  */
/*  n[hEFAŕ_WX^ĂȂꍇ  */
#define FPR_AREA_SIZE       0           /*  fpr0-31,FPSCR  */
#define FPR0_13_AREA_SIZE   0           /*  fpr0-14,FPSCR  */
#define FPR14_31_AREA_SIZE  0           /*  fpr15-31  */
#endif  /* SUPPORT_FLOATING_POINT_REG */    

/*
 *  ݁ACPUOt̃WX^̑Ҕ
 *@@
 *@@@_WX^̑Ҕ̓fBXpb`ĂяoƂ
 *@@@i^XNXCb`̉\ƂĵݍsB
 *@@@݃nhCPUOnhŕ_WX^
 *@@@gpꍇ́Aenhŕ_WX^̑Ҕ^
 *@@@sƁB
 *@@@
 *@@@r4SRR1CPUOCPUbNԔʂɂgpB
 *@@@
 */
#define SAVE_GPR0_12_SPRG                   \
    subi    sp, sp, GPR0_12_SPRG_AREA_SIZE; \
    stw     r0, 0*4(sp);                    \
    stw     r3, 1*4(sp);                    \
    stw     r4, 2*4(sp);                    \
    stw     r5, 3*4(sp);                    \
    stw     r6, 4*4(sp);                    \
    stw     r7, 5*4(sp);                    \
    stw     r8, 6*4(sp);                    \
    stw     r9, 7*4(sp);                    \
    stw     r10, 8*4(sp);                   \
    stw     r11, 9*4(sp);                   \
    stw     r12,10*4(sp);                   \
    mfspr   r3, SRR0;                       \
    stw     r3, 11*4(sp);                   \
    mfspr   r4, SRR1;                       \
    stw     r4, 12*4(sp);                   \
    mfspr   r5, LR;                         \
    stw     r5, 13*4(sp);                   \
    mfspr   r6, CTR;                        \
    stw     r6, 14*4(sp);                   \
    mfcr    r7;             /*  CR  */      \
    stw     r7, 15*4(sp);                   \
    mfspr   r8, XER;                        \
    stw     r8, 16*4(sp)


/*  
 *  ݁ACPUOt̃WX^̕
 *  @@igpr0-1,3-12, ꃌWX^̕j
 *  
 *  @@fBXpb`ĂяoȂꍇ
 */
#define LOAD_R0_12_SPRG                         \
    /*  ꃌWX^̕  */                  \
    lwz     r3, 11*4(sp);                       \
    mtspr   SRR0, r3;                           \
    lwz     r4, 12*4(sp);                       \
    mtspr   SRR1, r4;                           \
    lwz     r5, 13*4(sp);                       \
    mtspr   LR, r5;                             \
    lwz     r6, 14*4(sp);                       \
    mtspr   CTR, r6;                            \
    lwz     r7, 15*4(sp);                       \
    mtcr    r7;             /*  CR  */          \
    lwz     r8, 16*4(sp);                       \
    mtspr   XER, r8;                            \
    /*  ėpWX^gpr0-1,3-12̕  */       \
    lwz     r0, 0*4(sp);                        \
    lwz     r3, 1*4(sp);                        \
    lwz     r4, 2*4(sp);                        \
    lwz     r5, 3*4(sp);                        \
    lwz     r6, 4*4(sp);                        \
    lwz     r7, 5*4(sp);                        \
    lwz     r8, 6*4(sp);                        \
    lwz     r9, 7*4(sp);                        \
    lwz     r10, 8*4(sp);                       \
    lwz     r11, 9*4(sp);                       \
    lwz     r12, 10*4(sp)
    /*  }N`܂  */


/*
 *  CPUO̓̓AeOxN^ɔzuO
 *  
 *  @}N
 *  @@exc_noFOԍ
 *  @
 *  @WX^蓖
 *  @@SPRG2Fexc_tableiCPUO[xN^e[u̐擪AhXj
 *  @@CTRFCꃋ[`̐擪AhX
 *  @@r3FCPUOnḧ
 *  @@r4FSRR1̃Rs[
 */
#define MAKE_EXCEPTION_ENTRY(exe_no)                            \
    SAVE_GPR0_12_SPRG;  /*  XNb`WX^̑Ҕ  */        \
                        /*  ir4SRR1Rs[j  */      \
    mr  r3, sp;         /*  CPUOnḧݒ  */       \
    /*  Cꃋ[`̐擪AhXݒ  */                     \
    mfspr   r5, SPRG2;  /*  r5SPRG2Fexc_table  */            \
                        /*  [xN^e[uǂݏo  */      \
    lwz     r6, (exe_no<<2)(r5);                                \
    li      r7, exe_no; /*  Ovԍ̕ۑ  */              \
    stw     r7, NUM_REG*4(sp)    /*  (cpu_experr()Ŏgp)  */

/*
 *  CPUO̓̓AeOxN^ɔzuȂ
 *  Oւ̕
 *  
 *  OxN^̔zuɂĂb߂ɂ镪iO0x07ff,ffffj
 *  ͂ȂꍇB̏ꍇ͐ΔԒnw肵ĕ򂷂B
 */
#ifdef ABSOLUTE_JUMP_EXC_ENTRY
#define JUMP_EXC_ENTRY(label)			\
		LI32(r8, label);		\
		mtctr r8;			\
		bctr

#else	/*  ABSOLUTE_JUMP_EXE_ENTRY  */
#define JUMP_EXC_ENTRY(label)	b label
#endif	/*  ABSOLUTE_JUMP_EXE_ENTRY  */

/*  
 *   OxN^̒`
 */   

#ifndef IBM_PPC_EMB_ENV
/*  
 *   IWiPowerPCA[LeN`̏ꍇ
 *   @@g[MPCV[YAIPM PowerPC6xx/7xxV[Y
 *   @@ɊYB
 */   

/*
 *  OxN^e[u̐擪AhX
 *  @@}VXe[^XWX^MSRIPrbg
 *  @@@@0̂ƂF0x0000,0000Ԓn
 *  @@@@1̂ƂF0xfff0,0000Ԓn
 * @@@̃ItZbgɂȂ
 */
#define EXCEPTION_VECTOR_BASE   0x100

/*
 *  VXeZbgO
 */
    .section ".exception_vector","rxai"
    .align 2
    .org 0x100 - EXCEPTION_VECTOR_BASE

System_reset_exception:
    JUMP_EXC_ENTRY(start)               /*  X^[gAbv[`  */

/*
 *  }VE`FbNO
 */
    .org 0x200 - EXCEPTION_VECTOR_BASE

Machine_check_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_MACHINE_CHECK)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  DSIO
 *  @f[^EEANZX
 *  @f[^TLBG[^~X
 */
    .org 0x300 - EXCEPTION_VECTOR_BASE

DSI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_DSI)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ISIO
 *  @߃tFb`
 *  @TLBG[^~X
 */
    .org 0x400 - EXCEPTION_VECTOR_BASE

ISI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_ISI)
    JUMP_EXC_ENTRY(Exception_Entry)


/*
 *  O
 *  @ׂĂ̊O荞݂œԒnɕ򂷂
 */
    .org 0x500 - EXCEPTION_VECTOR_BASE

External_interrupt:
    SAVE_GPR0_12_SPRG           /*  WX^̑Ҕ  */
    /*
     *  {͂ő̏sA0x100oCgi64߁j
     *  ACgȌ邽߁AExternal_interrupt_1:ōs
     *  B
     */
    JUMP_EXC_ENTRY(External_interrupt_1)

/*
 *  ACgO
 */
    .org 0x600 - EXCEPTION_VECTOR_BASE

Alignment_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_ALIGNMENT)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  vOO
 *  @@Floating point enabled
 *  @@Illegal instruction
 *  @@Privileged instruction
 *  @@Trap instruction
 */
    .org 0x700 - EXCEPTION_VECTOR_BASE

Program_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_PROGRAM)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  _gps
 */
    .org 0x800 - EXCEPTION_VECTOR_BASE

Floating_point_unavailable:
    MAKE_EXCEPTION_ENTRY(EXC_NO_FLOATING_POINT_UNAVAILABLE)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  fN^O
 */
    .org 0x900 - EXCEPTION_VECTOR_BASE

Decrementer_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_DECREMENTER)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  Cve[VŗL̗O0x00a00
 */
#ifdef IMPLEMENT_EXCEPTION_00A00
    .org 0xa00 - EXCEPTION_VECTOR_BASE

Implementation_exception_00a00:
    MAKE_EXCEPTION_ENTRY(EXC_NO_IMPLEMENT_EXCEPTION_00A00)
    JUMP_EXC_ENTRY(Exception_Entry)

#endif /* IMPLEMENT_EXCEPTION_00A00 */


/*
 *  VXeR[
 */
    .org 0xc00 - EXCEPTION_VECTOR_BASE

System_call:
    MAKE_EXCEPTION_ENTRY(EXC_NO_SYSTEM_CALL)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  g[XiIvVj
 */
    .org 0xd00 - EXCEPTION_VECTOR_BASE

Trace_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_TRACE)
    JUMP_EXC_ENTRY(Exception_Entry)


/*
 *  _⏕
 */
    .org 0xe00 - EXCEPTION_VECTOR_BASE

Floating_point_assist:
    MAKE_EXCEPTION_ENTRY(EXC_NO_FLOATING_POINT_ASSIST)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  Cve[Vp̏ 0x01000-0x2ffff
 *    Cve[VŗL̗OxN^iPƂ͌Ȃj
 *    ̗prɎgp
 */
#ifdef IMPLEMENT_EXCEPTION_01000_PROC
    .org 0x1000 - EXCEPTION_VECTOR_BASE

    IMPLEMENT_EXCEPTION_01000_PROC
    
#endif /* IMPLEMENT_EXCEPTION_01000_PROC */

#else	/*  IBM_PPC_EMB_ENV  */

/*  
 *   The IBM PowerPC Embedded Environment̏ꍇ
 *   @IBMnPowerPC40xV[YΉ
 */   

/*
 *  OxN^e[u̐擪AhX
 *   @ The IBM PowerPC Embedded Environment̏ꍇ
 *  @@@EOxN^̐擪AhXEVPRWX^Őݒ肷
 *  @@@E}VXe[^XWX^MSRIPrbgȂ
 */
#define EXCEPTION_VECTOR_BASE   0x100

/*
 *  Critical Interrupt
 *  @ItZbgF0x100
 *  @Critical Interrupt̓Cve[VˑȂ̂
 *  @e̓}N`ĂB
 *  @@}NFCRITICAL_INTERRUPT_EXCEPTION_PROC
 *  @̏e0x100oCg𒴂Ă͂ȂB
 *  @iꍇ͎c̕ʂ̏ꏊɔzuāA
 *  @@ɕ򂷂邱Ɓj
 *
 *  @Critical Interrupt̓J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 */
    .section ".exception_vector","rxai"
    .align 2
    .org 0x100 - EXCEPTION_VECTOR_BASE

Critical_Interrupt_exception:
    CRITICAL_INTERRUPT_EXCEPTION_PROC
    /*  ӁF^[߂rfci(Return From Critical Interrupt)  */

/*
 *  }VE`FbNO
 *  @̏e0x100oCg𒴂Ă͂ȂB
 *  @iꍇ͎c̕ʂ̏ꏊɔzuāA
 *  @@ɕ򂷂邱Ɓj
 *
 *  @J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 */
    .org 0x200 - EXCEPTION_VECTOR_BASE

Machine_check_exception:
    MACHINE_CHECK_PROC

/*
 *  Data storageO
 *  @f[^EEANZX
 */
    .org 0x300 - EXCEPTION_VECTOR_BASE

DSI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_DATA_STORAGE)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  Instruction storageO
 *  @߃tFb`
 */
    .org 0x400 - EXCEPTION_VECTOR_BASE

ISI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_INSTRUCTION_STORAGE)
    JUMP_EXC_ENTRY(Exception_Entry)


/*
 *  O
 *  @ׂĂ̊O荞݂œԒnɕ򂷂
 */
    .org 0x500 - EXCEPTION_VECTOR_BASE

External_interrupt:
    SAVE_GPR0_12_SPRG           /*  WX^̑Ҕ  */
    /*
     *  {͂ő̏sA0x100oCgi64߁j
     *  ACgȌ邽߁AExternal_interrupt_1:ōs
     *  B
     */
    JUMP_EXC_ENTRY(External_interrupt_1)

/*
 *  ACgO
 */
    .org 0x600 - EXCEPTION_VECTOR_BASE

Alignment_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_ALIGNMENT)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  vOO
 *  @@Illegal instruction
 *  @@Privileged instruction
 *  @@Trap instruction
 *  @@Floating point enabled
 *  @@Floating point unimplemented
 *  @@Auxiliary processor unavailable
 *  @@Auxiliary processor enabled
 */
    .org 0x700 - EXCEPTION_VECTOR_BASE

Program_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_PROGRAM)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  _gps
 */
#ifdef SUPPORT_IBM_PPC_EMB_APU	/*  APU@͗p\  */
    .org 0x800 - EXCEPTION_VECTOR_BASE

Floating_point_unavailable:
    MAKE_EXCEPTION_ENTRY(EXC_NO_FLOATING_POINT_UNAVAILABLE)
    JUMP_EXC_ENTRY(Exception_Entry)

#endif /* SUPPORT_IBM_PPC_EMB_APU */


/*
 *  VXeR[
 */
    .org 0xc00 - EXCEPTION_VECTOR_BASE

System_call:
    MAKE_EXCEPTION_ENTRY(EXC_NO_SYSTEM_CALL)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  Cve[Vp̏iItZbg 0xd00-0xff0j
 *    Cve[VŗL̗OxN^
 *    
 * @ ItZbg̎w@ɒӂ邱ƁB
 *  @̓Iɂ
 *     .org ItZbg - EXCEPTION_VECTOR_BASE
 * @ ̂悤Ɏw肷Bڂ̗͑Ov̊YQƁB
 *    Ⴆ΁APowerPC405ł̓ItZbg0xf20
 *    APU UnavailableȌzu
 */
#ifdef IMPLEMENT_EXCEPTION_D00_PROC

    IMPLEMENT_EXCEPTION_D00_PROC
    
#endif /* IMPLEMENT_EXCEPTION_D00_PROC */

/*
 *  Programmable Interval timer
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
    .org 0x1000 - EXCEPTION_VECTOR_BASE

Programmable_Interval_timer:
	PROGRAMMABLE_INTERVAL_TIMER_PROC

/*
 *  Fixed Interval timer
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
    .org 0x1010 - EXCEPTION_VECTOR_BASE

Fixed_Interval_timer:
	FIXED_INTERVAL_TIMER_PROC

/*
 *  Watchdog timer
 *  @ItZbgF0x1020
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 *
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 *  @J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 */
    .org 0x1020 - EXCEPTION_VECTOR_BASE

Watchdog_timer:
	WATCHDOG_TIMER_PROC

/*
 *  Data TLB miss
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
    .org 0x1100 - EXCEPTION_VECTOR_BASE

Data_TLB_miss:
	DATA_TLB_MISS_PROC

/*
 *  Instruction TLB miss
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
    .org 0x1200 - EXCEPTION_VECTOR_BASE

Instruction_TLB_miss:
	INSTRUCTION_TLB_MISS_PROC

/*
 *  DebugO
 *  @ItZbgF0x2000
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 *  @
 *  @v͈ȉ7
 *  @@Trap
 *  @@Instruction address compare
 *  @@Data address compare
 *  @@Instruction complete
 *  @@Branch taken
 *  @@Exception
 *  @@Unconditional debug event
 *  @
 *  @J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 *  @
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
    .org 0x2000 - EXCEPTION_VECTOR_BASE

Debug_exception:
	DEBUG_PROC


/*
 *  Cve[Vp̏iItZbg 0x2010-0x2ff0j
 *    Cve[VŗL̗OxN^iPƂ͌Ȃj
 *    ̗prɎgp
 *    
 * @ ItZbg̎w@ɒӂ邱ƁB
 *  @̓Iɂ
 *     .org ItZbg - EXCEPTION_VECTOR_BASE
 * @ ̂悤Ɏw肷Bڂ̗͑Ov̊YQƁB
 */
#ifdef IMPLEMENT_EXCEPTION_02010_PROC

    IMPLEMENT_EXCEPTION_02010_PROC
    
#endif /* IMPLEMENT_EXCEPTION_01000 */


/*
 *  System reset
 *    ZbgxN^0xffff,fffcԒnɌŒ肳Ă
 */
    .section ".system_reset_vector","rxai"
    .align 2
    
/*  ̍s(0xffff,fffc - 4oCg~4)ԒnɔzuB  */
jump_to_start:    
    LI32(r8, start)
    mtctr	r8
    bctrl

/*  ̍s0xffff,fffcԒnɔzuB  */
reset_vector:
    b		jump_to_start
    /*  ɂ1߂Ȃ̂őΕ򖽗߂uA  */
    /*  start[`ւ̕͏Ljump_to_startōsB  */


#endif	/*  IBM_PPC_EMB_ENV  */




/*
 *  CPUO[`̑
 *@@Ovɂ炸Aʂ̏
 *@@eOxN^獇āAc̏ōsB
 *@@@EvZbTRA̔ėpWX^ƓꃌWX^̑Ҕ
 *@@@ECꃋ[`
 *      @@E擪AhX̐ݒ
 *      @@E̐ݒ
 *@@ς񂾏Ԃłɗ
 *
 *  @WX^蓖āiׂĐݒς݂̏Ԃłɗj
 *  @@SPRG0F݁^ÕlXgJE^
 *  @@SPRG2Fexc_tableiCPUO[xN^e[u̐擪AhXj
 *  @@r3FCPUOnḧ
 *  @@r4FSRR1̃Rs[
 *  @@r6FCꃋ[`̐擪AhX
 *
 *  regflg `FbNOɊ荞݂֎~ȂƁAreqflg `FbN
 *  ɋNꂽ荞݃nhŃfBXpb`vꂽꍇɁA
 *  fBXpb`ȂB
 *  
 *  OxN^textZNVPCΕœ͂ȂȂƂ̂߁A
 *  Exception_EntryO[o錾ĂB
 *
 */

    .text
    .align 2
#ifdef ABSOLUTE_JUMP_EXC_ENTRY
    .global Exception_Entry
#endif	/*  ABSOLUTE_JUMP_EXC_ENTRY  */
    
Exception_Entry:
    mtctr   r6;         /*  CTRCꃋ[`̐擪AhX */
    /*  ݃lXgJE^̃CNg  */
    mfspr   r8, SPRG0   /*  SPRG0:݁^OlXgJE^  */
    addi    r8, r8, 1
    mtspr   SPRG0, r8

    /*  CPUÕReLXg̔  */
    cmpwi   crf0, r8, 1
    bne     exception_from_int

    /*  iCPUȌꍇ  */
exception_from_task:
    /*
     *  R[OERxVɍ킹āAX^bN|C^
     *@8oCg炵ĂB
     *@
     *         -8  ----------------------
     *            |      task sp         |
     *         -4  ----------------------@
     *            |                      |Cꃋ[`̌Ăяoɂ
     * STACKTOP  ----------------------   ܂
     *  
     */
    LI32(r9, STACKTOP-STACK_MARGIN)
    stw     sp, 0(r9)     /*  ^XNX^bN|C^̕ۑ  */
    mr      sp, r9        /*  X^bN؂ւ  */


/*
 *  }N`FCPUOnȟďo
 *  @@@@@@i̗OƑdŐʏ
 *  
 *  e
 *  @Cꃋ[`Ăяo
 *  
 *  
 *  @  labelFxʗp
 *  @  @@@@iӏł̃}Ngpł悤ɂ邽߁j
 *  
 *  O
 *  @ r3=Cꃋ[`̈
 *  @ r4=SRR1
 *  @ CTR=Cꃋ[`̐擪AhX
 *  @@̏ԂŎgp
 *  
 *  l
 *  @CPUOnh̋NɂACPUbNԂύXĂ͂Ȃ
 *  @܂ACPUOCPUbNԂł΁ACPUbNԂ
 *  @܂܁ACPUOnhNB
 *  @iCPUOCPUbNԂł΁ACPUbNԂ
 *  @@܂܁ACPUOnhNBj
 *  @@
 */
#define _CALL_EXCEPTION_ROUTINE(label)                                  \
    andi.   r6, r4, MSR_EE;   /*  r4FSSR1̃Rs[  */                  \
    /* ʂ[Ȃ΁iCPUbNԂȂj */                   \
    /*  EQtOZbgiCPUbNԂȂ番j  */         \
    bne     exception_from_cpu_unlock_##label;                          \
                                                                        \
    /*  CPUOCPUbNԂꍇ  */                      \
    /*  CPUbNԂ̂܂܁ACPUOnhĂяo  */              \
    /*  @Cꃋ[`̖߂Ԓnݒ  */                         \
    LI32(r7, exit_CALL_EXCEPTION_ROUTINE_##label);                      \
    mtspr   LR, r7;                                                     \
    bctr;               /*  Cꃋ[`Ăяo  */                   \
    /* exit_CALL_EXCEPTION_ROUTINE_##labelԒnɖ߂Ă   */         \
                                                                        \
    /*  CPUOCPUbNԂꍇ  */                  \
exception_from_cpu_unlock_##label:;                                     \
    mfmsr   r10;                                                        \
    ori     r11, r10, MSR_EE;   /*  EErbgZbg  */                \
    mtmsr   r11;                /*  ݋  */                      \
    bctrl;                      /*  Cꃋ[`Ăяo  */           \
    mfmsr   r10;                                                        \
    xori    r11, r10, MSR_EE;   /*  EErbgNA  */                \
    mtmsr   r11;                /*  ݋֎~ (a)  */                  \
exit_CALL_EXCEPTION_ROUTINE_##label:     /*  }N̏ox  */  
    

/* }NlabelmɃ}NWJ邽߁A}N2dɂĂ */
#define CALL_EXCEPTION_ROUTINE(label)   _CALL_EXCEPTION_ROUTINE(label)
    
    /*  Cꃋ[`Ăяo  */
    CALL_EXCEPTION_ROUTINE(exception_from_task)
    /*
     *  ݋֎~Ŗ߂Ă
     *@@OCPUbNĂꍇ
     *@@L(a)sŊ݋֎~ɂĂ
     */
    li      r0, 0
    mtspr   SPRG0, r0           /*  ݃lXgJE^NA  */
    lwz     sp, 0(sp)           /*  X^bNؑ  */
    lis     r3, reqflg@ha
    lwz     r4, reqflg@l(r3)    /*  r4=reqflg  */
    cmpwi   crf0, r4, 0         /*  reqflg̃`FbN  */
    beq     ret_to_task_exc /*  fBXpb`vȂꍇ͕  */        
    stw     r0, reqflg@l(r3)    /*  reqflg̃NA  */
    b       ret_exc             /*  oփWv  */
    
/*  dȌꍇ  */
exception_from_int: 
    /*
     *  R[OERxVɍ킹āAX^bN|C^
     *@8oCg炵Ă
     *@
     *         -8  ----------------------
     *            |                      |
     *         -4  ----------------------@
     *            |                      |Cꃋ[`̌Ăяoɂ
     *       sp  ----------------------   ܂
     *  
     */
    subi    sp, sp, STACK_MARGIN

    /*  Cꃋ[`Ăяo  */
    CALL_EXCEPTION_ROUTINE(exception_from_int)
    /*
     *  ݋֎~Ŗ߂Ă
     *@@OCPUbNĂꍇ
     *@@L(a)sŊ݋֎~ɂĂ
     *  @
     *  @ret_to_task_excłCPUÕ^[rfiɂ
     *  @@@MSRSRR1
     *  @ƂȂ̂ŁÃReLXgɖ߂ƂɂCPUO
     *  @OCPUbN^bNԂ
     */
    			/*  X^bN|C^ɖ߂iLQƁj */
    addi    sp, sp, STACK_MARGIN
    mfspr   r3, SPRG0   /*  SPRG0:݁^OlXgJE^  */
    subi    r3, r3, 1   /*  ݃lXgJE^̃fBNg  */
    mtspr   SPRG0, r3
    b       ret_to_task_exc



/*
 *  ݏo[`̑
 *@@݃xN^0x100oCgi64ߕjȂ̂ŁA
 *@@c̏ōsB
 *@@݃Rg[ˑPł64߂Ɏ܂
 *@@mȂAǐlāAɋLqB
 *@@vZbTRA̔ėpWX^ƓꃌWX^̑Ҕ
 *@@ς񂾏Ԃłɗ
 *
 *  @ׂĂ̊O荞݂œԒnɕ򂷂
 *
 *  SPRG0WX^݁^ÕlXgJE^ƂĎgpB
 *
 *  regflg `FbNOɊ荞݂֎~ȂƁAreqflg `FbN
 *  ɋNꂽ荞݃nhŃfBXpb`vꂽꍇɁA
 *  fBXpb`ȂB
 *  
 *  OxN^textZNVPCΕœ͂ȂȂƂ̂߁A
 *  External_interrupt_1O[o錾ĂB
 *
 */

    .text
    .align 2
#ifdef ABSOLUTE_JUMP_EXC_ENTRY
    .global External_interrupt_1
#endif	/*  ABSOLUTE_JUMP_EXC_ENTRY  */

External_interrupt_1:
    /*  vZbTRÃWX^̑Ҕ͍ςł  */
    
    PUSH_ICU_IPM    /*  ݃Rg[ICUIPMҔ  */
    			/*  IPM̃f[^TCY̔@ɂ炸A */
    			/*  X^bN|C^4oCgE  */
    			/*  邱  */

    /*  ݃lXgJE^̃CNg  */
    mfspr   r3, SPRG0   /*  SPRG0:݁^OlXgJE^  */
    addi    r3, r3, 1
    mtspr   SPRG0, r3

    /*  ݌̃ReLXg̔  */
    cmpwi   crf0, r3, 1
    bne     interrupt_from_int

    /*  i݂̊̏ꍇ  */
interrupt_from_task:
    /*
     *  R[OERxVɍ킹āAX^bN|C^
     *@8oCg炵ĂB
     *@
     *         -8  ----------------------
     *            |      task sp         |
     *         -4  ----------------------@
     *            |                      |Cꃋ[`̌Ăяoɂ
     * STACKTOP  ----------------------   ܂
     *  
     */
    LI32(r4, STACKTOP-STACK_MARGIN)  /*  r4=STACKTOP  */
    stw     sp, 0(r4)     /*  ^XNX^bN|C^̕ۑ  */
    mr      sp, r4        /*  X^bN؂ւ  */

    /*
     *  ICUˑ̊ݏ 
     * @ e
     *  @@Eݗv̔
     *  @@E݃}XN̐ݒ
     *  @@E݋
     *  @@ECꃋ[`Ăяo
     *  @@E݋֎~
     *  @@E荞ݗvtÕNAiKvł΁j
     */
    PROC_ICU(FROM_TASK)
    /*  ݋֎~Ŗ߂Ă  */
    
    li      r0, 0
    mtspr   SPRG0, r0           /*  ݃lXgJE^NA  */
    lwz     sp, 0(sp)           /*  X^bNؑ  */
    POP_ICU_IPM                 /*  ݃Rg[ICUIPM𕜋A  */
    			        /*  IPM̃f[^TCY̔@ɂ炸A */
    			        /*  X^bN|C^4oCgE  */
    			        /*  邱  */
    lis     r3, reqflg@ha   
    lwz     r4, reqflg@l(r3)    /*  r4=reqflg  */
    cmpwi   crf0, r4, 0         /*  reqflg̃`FbN  */
    beq     ret_to_task_int /*  fBXpb`vȂꍇ͕  */        
    stw     r0, reqflg@l(r3)    /*  reqflg̃NA  */
    b       ret_int             /*  oփWv  */

            
    /*  d݂̏ꍇ  */
interrupt_from_int:
    /*
     *  R[OERxVɍ킹āAX^bN|C^
     *@8oCg炵Ă
     *@
     *         -8  ----------------------
     *            |                      |
     *         -4  ----------------------@
     *            |                      |Cꃋ[`̌Ăяoɂ
     *       sp  ----------------------   ܂
     *  
     */
    subi    sp, sp, STACK_MARGIN

    PROC_ICU(FROM_INT)  /*  ICUˑ̊ݏ  */
    /*  ݋֎~Ŗ߂Ă  */
    
    			/*  X^bN|C^ɖ߂iLQƁj */
    addi    sp, sp, STACK_MARGIN
    mfspr   r3, SPRG0   /*  SPRG0:݁^OlXgJE^  */
    subi    r3, r3, 1   /*  ݃lXgJE^̃fBNg  */
    mtspr   SPRG0, r3
    POP_ICU_IPM     /*  ݃Rg[ICUIPM𕜋A  */
    			/*  IPM̃f[^TCY̔@ɂ炸A */
    			/*  X^bN|C^4oCgE  */
    			/*  邱  */
    
    /*  
     *  fBXpb`Ă΂ɒPɊ݌iOjɖ߂ꍇ
     *
     *  rfi߂͓߂Ȃ̂ŁAL̃WX^̕Asp̉ZI
     *  猳̃ReLXgɖ߂B
     *  sp̉ZɍςŊ݋ɂȂSz͂ȂB
     *
     *    CPUO畜Aꍇ
     *  @@CPUÕ^[rfiɂ
     *  @@@MSRSRR1
     *  @@ƂȂ̂ŁÃReLXgɖ߂ƂɂCPUO
     *  @@OCPUbN^bNԂ
     */
ret_to_task_int:
ret_to_task_exc:
    LOAD_R0_12_SPRG     /*  gpr0-1,3-12, ꃌWX^̕  */
    addi    sp, sp, GPR0_12_SPRG_AREA_SIZE
    rfi     		/*  ݌֕A  */
    


/*  WX^Ҕ̂ɕKvȃoCg  */
                                    /*  gpr13-31,LR  */
#define GPR13_31_LR_AREA_SIZE   (GPR13_31_AREA_SIZE +4)

/*  
 *  }N`FėpWX^gpr13-31̑Ҕ
 */

#ifdef USE_MULTIPLE_WORD_LOAD_STORE
    /*  
     *  [h^XgAE}`v
     *@@Cve[VɂĂ͂ĒxȂ
     *@@܂̂ŒӂKv
     */

#if SIL_ENDIAN == SIL_ENDIAN_LITTLE
@@IŃRpCEG[
@@@gEGfBAE[hɂƂɂ͋@\Ȃ
@@@in[hEFAɂ鐧j
#endif


#define STORE_R13_31                                \
    stmw    r13, 0(sp)    /*  gpr13-31Ҕ  */

#else   /*  USE_MULTIPLE_WORD_LOAD_STORE  */
#define STORE_R13_31                                \
    stw     r13,  0*4(sp);                          \
    stw     r14,  1*4(sp);                          \
    stw     r15,  2*4(sp);                          \
    stw     r16,  3*4(sp);                          \
    stw     r17,  4*4(sp);                          \
    stw     r18,  5*4(sp);                          \
    stw     r19,  6*4(sp);                          \
    stw     r20,  7*4(sp);                          \
    stw     r21,  8*4(sp);                          \
    stw     r22,  9*4(sp);                          \
    stw     r23, 10*4(sp);                          \
    stw     r24, 11*4(sp);                          \
    stw     r25, 12*4(sp);                          \
    stw     r26, 13*4(sp);                          \
    stw     r27, 14*4(sp);                          \
    stw     r28, 15*4(sp);                          \
    stw     r29, 16*4(sp);                          \
    stw     r30, 17*4(sp);                          \
    stw     r31, 18*4(sp)                           
#endif  /*  USE_MULTIPLE_WORD_LOAD_STORE  */

    /*  }N`܂  */


/*  
 *  }N`FėpWX^gpr13-31̕
 */

#ifdef USE_MULTIPLE_WORD_LOAD_STORE
    /*  
     *  [h^XgAE}`v
     *@@Cve[VɂĂ͂ĒxȂ
     *@@܂̂ŒӂKv
     */
#define LOAD_R13_31                                 \
    lmw     r13, 0(sp)    /*  gpr13-31𕜌  */
    
#else   /*  USE_MULTIPLE_WORD_LOAD_STORE  */
#define LOAD_R13_31                                 \
    lwz     r13,  0*4(sp);                          \
    lwz     r14,  1*4(sp);                          \
    lwz     r15,  2*4(sp);                          \
    lwz     r16,  3*4(sp);                          \
    lwz     r17,  4*4(sp);                          \
    lwz     r18,  5*4(sp);                          \
    lwz     r19,  6*4(sp);                          \
    lwz     r20,  7*4(sp);                          \
    lwz     r21,  8*4(sp);                          \
    lwz     r22,  9*4(sp);                          \
    lwz     r23, 10*4(sp);                          \
    lwz     r24, 11*4(sp);                          \
    lwz     r25, 12*4(sp);                          \
    lwz     r26, 13*4(sp);                          \
    lwz     r27, 14*4(sp);                          \
    lwz     r28, 15*4(sp);                          \
    lwz     r29, 16*4(sp);                          \
    lwz     r30, 17*4(sp);                          \
    lwz     r31, 18*4(sp)
#endif  /*  USE_MULTIPLE_WORD_LOAD_STORE  */

    /*  }N`܂  */




/*
 *  ^XNfBXpb`
 *
 *  dispatch ́ASPRG0 = 0,݋֎~ԂŌĂяoȂ΂ȂȂD
 *  exit_and_dispatch CSPRG0 = 0E݋֎~ԂŌĂяô
 *  ł邪CJ[lNɑΉ邽߁CSPRG0 = 1ŌĂяoꍇ
 *  ɂΉĂD
 */

    .global dispatch
dispatch:
    /*  XNb`WX^̑Ҕ  */
    subi    sp, sp, GPR13_31_LR_AREA_SIZE + FPR14_31_AREA_SIZE
    STORE_R13_31                /*  gpr13-31̑Ҕ  */

    mfspr   r7, LR
    stw     r7, GPR13_31_LR_AREA_SIZE - 4(sp)   /*  LȒҔ  */

    /*  _WX^̑Ҕ  */
#ifdef SUPPORT_FLOATING_POINT_REG
    /*  n[hEFA_WX^Ăꍇ  */
    /*  F{Ȃ8oCgɃACg  */    
    stfd    f14,  0*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f15,  1*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f16,  2*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f17,  3*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f18,  4*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f19,  5*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f20,  6*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f21,  7*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f22,  8*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f23,  9*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f24, 10*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f25, 11*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f26, 12*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f27, 13*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f28, 14*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f29, 15*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f30, 16*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f31, 17*8+GPR13_31_LR_AREA_SIZE(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    lis     r3, runtsk@ha
    LI32(r4, dispatch_r)
    lwz     r5, runtsk@l(r3)    /*  r5 = runtsk  */
    stw     sp, TCB_sp(r5)      /*  runtsk->sp =  sp */
    stw     r4, TCB_pc(r5)      /*  runtsk->pc =  dispatch_r */
    b       dispatcher


    /*  fBXpb`̏o  */
    /*      X^bN|C^͍̕ςł  */
    /*  @@r10runtskČĂ΂  */
dispatch_r: 
    /*  XNb`WX^̕A  */

    /*  _WX^  */
#ifdef SUPPORT_FLOATING_POINT_REG    
    /*  n[hEFA_WX^Ăꍇ  */
    /*  F{Ȃ8oCgɃACg  */    
    lfd     f14,  0*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f15,  1*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f16,  2*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f17,  3*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f18,  4*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f19,  5*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f20,  6*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f21,  7*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f22,  8*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f23,  9*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f24, 10*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f25, 11*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f26, 12*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f27, 13*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f28, 14*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f29, 15*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f30, 16*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f31, 17*8+GPR13_31_LR_AREA_SIZE(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    /*  ėpWX^  */
    LOAD_R13_31

    /*  LR̕  */
    lwz     r7, GPR13_31_LR_AREA_SIZE - 4(sp)
    mtspr   LR, r7

    addi    sp, sp, GPR13_31_LR_AREA_SIZE + FPR14_31_AREA_SIZE

    /*
     *  ^XNOṽ`FbN
     *  dispatch_rdispatcherĂяo邽߁C
     *  runtskr10ɓĂD
     */                           
    lbz     r4, TCB_enatex(r10)         /*  r10=runtsk  */
    /*
     *  }XNf[^̃rbgƃGfBAmakeoffset.c
     *  BIT_BBBIT_LBŎw肵Ă
     */                                 
    andi.   r5, r4, TCB_enatex_mask     /*  r5 = runtsk->enatex  */
                    /* ʂ[Ȃ΁AEQtOZbg */

          /*  ^XNO֎~Ȃdispatch()̌Ăяoɖ߂  */
    beqlr               /*  iLRɖ߂Ԓni[Ăj  */
    lwz     r6, TCB_texptn(r10)          /*  r6 = runtsk->texptn  */
    cmpwi   crf0, r6, 0
                        /*  ^XNOvȂ */
                        /*  dispatch()̌Ăяoɖ߂  */
    beqlr               /*  iLRɖ߂Ԓni[Ăj  */

    b       call_texrtn /*  ^XNO[`Ăяo  */
    /*
     *  call_texrtn()炱ɂ͖߂ĂȂŁAdispatch()
     *@Ăяoi=LRWX^wԒnjɒږ߂B
     *@
     *@call_texrtn()̌Ăяoɂ(sp+3)`(ps+7)Ԓn̓e
     *@j󂳂邪Asp̈ʒudispatch()ĂяoƂƓ
     *@Ȃ̂ŖȂ
     *@
     *  sp  ----------------------  
     *       |                      |
     *    +4  ----------------------@
     *       |                      |call_texrtn()̌Ăяoɂ
     *    +8  ----------------------   ܂
     *  
     *  
     *@
 @@*@@^XNO[`ŕ_WX^gp
 @@*@@ꍇ́A^XNO[`ŕ_WX^
 @@*@@Ҕ^sƁB
     */


    .global exit_and_dispatch
exit_and_dispatch:
    li      r0, 0
    mtspr   SPRG0, r0           /*  lXgJE^NA  */
    
dispatcher:
    /*
     * ɂ͊荞݋֎~ŗ邱
     */
    LOAD_VAL32(r10, schedtsk)   /*  r10 = schedtsk  */
    lis     r5, runtsk@ha
	/*
	 * runtskschedtsk̂͂Q̈ӖB
	 * @(1) schedtsk != NULL̏ꍇ
	 * @@@@ʏ̃^XN؂ւsB
	 * @(2) schedtsk == NULL̏ꍇ
	 * @@@@runtskNULLĂB
	 * @@@@idispatcher_1ȍ~̊ݑ҂Ŋ݂A̒
	 * @@@@@iget_tid()R[ꂽƂɐTSK_NONEԂ
	 * @@@@@ɂ́AsԂ̃^XNȂɁAruntskNULLɂ
	 * @@@@@KvBj
	 */
    stw     r10, runtsk@l(r5)       /*  runtsk=schedtsk(=r10)  */

    cmpwi   crf0, r10, 0
    beq     dispatcher_1            /*  schedtskΊݑ҂  */

    lwz     r6, TCB_pc(r10)         /*  sĊJԒno  */
    mtctr   r6                      /*  CTR<-sĊJԒn  */
    lwz     sp, TCB_sp(r10)         /*  X^bN|C^𕜌  */
    bctr                            /*  WviLQƁj  */

    /*  
     *  sĊJԒn͈ȉ3ʂ
     *  @̏ꍇr10=runtskŌĂяo
     *  @@EfBXpb`̏o@dispatch_r
     *  @@E݁^Ȍo@@ret_int_r
     *  @@E^XNN@@@@activate_r
     */


    /*  
     *@sׂ^XN܂ő҂
     *
     *  Ŕ^XNReLXgɐ؂芷̂́CŔ銄
     *  ɂǂ̃X^bNgƂ̉ƁC݃nh
     *  ̃^XNfBXpb`̖h~Ƃ̈ӖD
     */ 
dispatcher_1:
    LI32(sp, STACKTOP)          /*  X^bN؂ւ  */
    li      r3, 1
    mtspr   SPRG0, r3           /*  lXgJE^1  */
    
    /*  [vŎg萔pӂĂ  */
    LI32(r4, reqflg)            /*  reqflg̃AhX  */
    li      r0, 0

dispatcher_2:
#ifdef SUPPORT_POWER_MANAGEMENT
                                /*  ȓd̓[hꍇ  */    
    /*  
     *  ݋Əȓd̓[hւ̈ڍs
     *  @E݂߂ĂɊ݋֎~s
     *  @Er0`r4̓ej󂵂Ă͂ȂȂ
     *
     *  
     *      u݋vƁuȓd̓[hւ̈ڍsvAg~bNɍs
     *      ȂvZbTł́Ã݂^C~OɂẮu݋
     *      vƁuȓd̓[hւ̈ڍsv̊ԂŊ݂󂯕tĂ
     *      AӐ}Ȃ`ŏȓd̓[hɈڍsĂ܂̂ŒӁB
     *      ݂ɂĎs\ȃ^XNĂvZbTX[
     *      v܂܂ŎsȂȂBiۂɂ̓^C}݂ɂ
     *      ȓd̓[h畜ÂŁA^XN҂鎞Ԃ͍ő
     *      ł^C}ݎŉBj
     */ 
    SAVE_POWPER
#else   /* SUPPORT_POWER_MANAGEMENT */    
                                /*  ȓd̓[hȂꍇ  */    
    mfmsr   r5
    ori     r6, r5, MSR_EE
    mtmsr   r6                  /*  ݋  */
    /*  Ŋ݂āA߂Ă  */
    mtmsr   r5                  /*  ݋֎~  */
#endif  /* SUPPORT_POWER_MANAGEMENT */    
    lwz     r6, 0(r4)           /*  r6 = reqflg  */
    cmpwi   crf0, r6, 0
               /*  fBXpb`vȂ΃[v̐擪  */
    beq     dispatcher_2
    stw     r0, 0(r4)           /*  reqflgNA  */
    mtspr   SPRG0, r0           /*  lXgJE^NA  */
    b       dispatcher          /*  sĊJԒnoփWv  */

	/*
	 *@ݑ҂̒OɍsX^bNؑւ̖߂sĂȂA
	 *@fBXpb`̏oTCBolX^bN|C
	 *@^ɐݒ肷̂ŖȂB
	 */



/* 
 *  荞݃nh/CPUOnho
 *
 * ߂悪^XNreqflgZbgĂꍇ݂̂ɂB
 * SPRG0 = 0,荞݋֎~,XNb`WX^ۑ
 * ԂŌĂяoƁB 
 *  
 *  ܂Ar10runtsk̒lĂret_int_1ɃWv邱
 */

ret_int:
ret_exc:
    LOAD_VAL32(r5, enadsp)  	/*  r5 = enadsp  */
    LOAD_VAL32(r10, runtsk) 	/*  r10 = runtsk  */
    cmpwi   crf0, r5, 0
    beq     ret_int_1           /*  fBXpb`֎~ȂWv  */
    
    LOAD_VAL32(r5, schedtsk)  	/*  r5 = schedtsk  */
    cmpw    crf0, r5, r10
    beq     ret_int_1           /*  runtsk=schedtskȂWv  */
    
    
    /*  c̃WX^ۑ  */

    subi    sp, sp, GPR13_31_AREA_SIZE + FPR_AREA_SIZE
    /*  ėpWX^̑Ҕ  */
    STORE_R13_31                /*  gpr13-31̑Ҕ  */

    /*  _WX^̑Ҕ  */
#ifdef SUPPORT_FLOATING_POINT_REG    
    /*  n[hEFA_WX^Ăꍇ  */
    /*  F{Ȃ8oCgɃACg  */    
    stfd    f0,   0*8+GPR13_31_AREA_SIZE(sp)
    stfd    f1,   1*8+GPR13_31_AREA_SIZE(sp)
    stfd    f2,   2*8+GPR13_31_AREA_SIZE(sp)
    stfd    f3,   3*8+GPR13_31_AREA_SIZE(sp)
    stfd    f4,   4*8+GPR13_31_AREA_SIZE(sp)
    stfd    f5,   5*8+GPR13_31_AREA_SIZE(sp)
    stfd    f6,   6*8+GPR13_31_AREA_SIZE(sp)
    stfd    f7,   7*8+GPR13_31_AREA_SIZE(sp)
    stfd    f8,   8*8+GPR13_31_AREA_SIZE(sp)
    stfd    f9,   9*8+GPR13_31_AREA_SIZE(sp)
    stfd    f10, 10*8+GPR13_31_AREA_SIZE(sp)
    stfd    f11, 11*8+GPR13_31_AREA_SIZE(sp)
    stfd    f12, 12*8+GPR13_31_AREA_SIZE(sp)
    stfd    f13, 13*8+GPR13_31_AREA_SIZE(sp)
    stfd    f14, 14*8+GPR13_31_AREA_SIZE(sp)
    stfd    f15, 15*8+GPR13_31_AREA_SIZE(sp)
    stfd    f16, 16*8+GPR13_31_AREA_SIZE(sp)
    stfd    f17, 17*8+GPR13_31_AREA_SIZE(sp)
    stfd    f18, 18*8+GPR13_31_AREA_SIZE(sp)
    stfd    f19, 19*8+GPR13_31_AREA_SIZE(sp)
    stfd    f20, 20*8+GPR13_31_AREA_SIZE(sp)
    stfd    f21, 21*8+GPR13_31_AREA_SIZE(sp)
    stfd    f22, 22*8+GPR13_31_AREA_SIZE(sp)
    stfd    f23, 23*8+GPR13_31_AREA_SIZE(sp)
    stfd    f24, 24*8+GPR13_31_AREA_SIZE(sp)
    stfd    f25, 25*8+GPR13_31_AREA_SIZE(sp)
    stfd    f26, 26*8+GPR13_31_AREA_SIZE(sp)
    stfd    f27, 27*8+GPR13_31_AREA_SIZE(sp)
    stfd    f28, 28*8+GPR13_31_AREA_SIZE(sp)
    stfd    f29, 29*8+GPR13_31_AREA_SIZE(sp)
    stfd    f30, 30*8+GPR13_31_AREA_SIZE(sp)
    stfd    f31, 31*8+GPR13_31_AREA_SIZE(sp)
    /*  
     * FPSCȒҔ  
     *
     *@@X^bN8oCggp͖̂ʂł邪A
     *@@stfiwx߂̓IvVȂ̂őIȂB
     *@@i܂AΉ郍[h߂Ȃ̂j
     *
     */
    mffs    f0              /*  f0̉2oCgFPSCR  */
                            /*  @(sp+ItZbg)f0  */
    stfd    f0, GPR13_31_AREA_SIZE+FPR0_13_AREA_SIZE-8(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    LI32(r5, ret_int_r)
                                /*  r10 = runtskłɗ  */
    stw     sp, TCB_sp(r10)      /*  runtsk->sp = sp  */
                                /*  ^XNX^bN|C^̕ۑ  */
    stw     r5, TCB_pc(r10)     /*  runtsk->pc = ret_int_r  */
                                /*  isĊJԒn̕ۑj  */

    b       dispatcher          /*  fBXpb`Ăяo  */


 /*  ݁^Ȍǒ㔼
  *     ret_int
  *     @EځAret_int_1ɍꍇ
  *     @EfBXpb`oRĂėꍇ
  *     @2ʂ肠
  *     @̏ꍇr10runtskĂ
  */
ret_int_r:

#ifdef SUPPORT_FLOATING_POINT_REG    
    /*  n[hEFA_WX^Ăꍇ  */

    /*  FPSCR̕  */
    lfd     f0, GPR13_31_AREA_SIZE+FPR0_13_AREA_SIZE-8(sp)
    mtfsf   0xf,f0          /*  FPSCRf0̉2oCg  */

    /*  _WX^̕  */
    lfd     f0,   0*8+GPR13_31_AREA_SIZE(sp)
    lfd     f1,   1*8+GPR13_31_AREA_SIZE(sp)
    lfd     f2,   2*8+GPR13_31_AREA_SIZE(sp)
    lfd     f3,   3*8+GPR13_31_AREA_SIZE(sp)
    lfd     f4,   4*8+GPR13_31_AREA_SIZE(sp)
    lfd     f5,   5*8+GPR13_31_AREA_SIZE(sp)
    lfd     f6,   6*8+GPR13_31_AREA_SIZE(sp)
    lfd     f7,   7*8+GPR13_31_AREA_SIZE(sp)
    lfd     f8,   8*8+GPR13_31_AREA_SIZE(sp)
    lfd     f9,   9*8+GPR13_31_AREA_SIZE(sp)
    lfd     f10, 10*8+GPR13_31_AREA_SIZE(sp)
    lfd     f11, 11*8+GPR13_31_AREA_SIZE(sp)
    lfd     f12, 12*8+GPR13_31_AREA_SIZE(sp)
    lfd     f13, 13*8+GPR13_31_AREA_SIZE(sp)
    lfd     f14, 14*8+GPR13_31_AREA_SIZE(sp)
    lfd     f15, 15*8+GPR13_31_AREA_SIZE(sp)
    lfd     f16, 16*8+GPR13_31_AREA_SIZE(sp)
    lfd     f17, 17*8+GPR13_31_AREA_SIZE(sp)
    lfd     f18, 18*8+GPR13_31_AREA_SIZE(sp)
    lfd     f19, 19*8+GPR13_31_AREA_SIZE(sp)
    lfd     f20, 20*8+GPR13_31_AREA_SIZE(sp)
    lfd     f21, 21*8+GPR13_31_AREA_SIZE(sp)
    lfd     f22, 22*8+GPR13_31_AREA_SIZE(sp)
    lfd     f23, 23*8+GPR13_31_AREA_SIZE(sp)
    lfd     f24, 24*8+GPR13_31_AREA_SIZE(sp)
    lfd     f25, 25*8+GPR13_31_AREA_SIZE(sp)
    lfd     f26, 26*8+GPR13_31_AREA_SIZE(sp)
    lfd     f27, 27*8+GPR13_31_AREA_SIZE(sp)
    lfd     f28, 28*8+GPR13_31_AREA_SIZE(sp)
    lfd     f29, 29*8+GPR13_31_AREA_SIZE(sp)
    lfd     f30, 30*8+GPR13_31_AREA_SIZE(sp)
    lfd     f31, 31*8+GPR13_31_AREA_SIZE(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    /*  ėpWX^̕  */
    LOAD_R13_31     /*  gpr13-31̕  */
    addi    sp, sp, GPR13_31_AREA_SIZE + FPR_AREA_SIZE

    /*  fBXpb`oRȂꍇ͂獇  */
    /*  ir10runtskԂłɗj  */
ret_int_1:
    /*  ^XNOṽ`FbN  */
                                    /*  r10 = runtsk  */
    lbz     r4, TCB_enatex(r10)
    /*
     *  }XNf[^̃rbgƃGfBAmakeoffset.c
     *  BIT_BBBIT_LBŎw肵Ă
     */                                 
    andi.   r5, r4, TCB_enatex_mask /*  r5 = runtsk->enatex  */
                            /* ʂ[Ȃ΁AEQtOZbg */
    beq     ret_int_2               /*  ^XNO֎~ȂWv  */
    lwz     r6, TCB_texptn(r10)      /*  r6 = runtsk->texptn  */
        /*  ^XNOvȂ΂ȂWv  */
    cmpwi   crf0, r6, 0
    beq     ret_int_2
    
    /*
     *  R[OERxVɍ킹āAX^bN|C^
     *@8oCg炵ĂB
     *@
     *    -8  ----------------------
     *       |                      |
     *    -4  ----------------------@
     *       |                      |call_texrtn()̌Ăяoɂ
     *  sp  ----------------------   ܂
     *  
     */
    subi    sp, sp, STACK_MARGIN

    bl      call_texrtn             /*  ^XNO[`Ăяo  */
		    	     /*  X^bN|C^ɖ߂iLQƁj */
    addi    sp, sp, STACK_MARGIN
    /*  
     *@
 @@*@@^XNO[`ŕ_WX^gp
 @@*@@ꍇ́A^XNO[`ŕ_WX^
 @@*@@Ҕ^sƁB
     */

ret_int_2:
    /*  
     *@call_texrtn()炱ɖ߂ėB(Laddi߂oRj
     *@icall_texrtn()Ă΂Ȃꍇ͒ڂɗj
     *
 @@*@@ʓIret_to_task_intƓɂȂA
 @@*@@ɂ܂Ƃ߂ƉǐȂ̂
 @@*@@ʁX̂܂܂ɂĂB
     */
    LOAD_R0_12_SPRG     /*  gpr0-1,3-12, ꃌWX^̕  */
    addi    sp, sp, GPR0_12_SPRG_AREA_SIZE
    /*  
     *  rfi߂͓߂Ȃ̂ŁAL̃WX^̕Asp̉ZI
     *  猳̃ReLXgɖ߂B
     *  sp̉ZɍςŊ݋ɂȂSz͂ȂB
     */
    rfi     /*  ݌֕A  */




/*
 *  ^XNN
 *  @fBXpb`ĂяôŁAr10ɂruntskĂ
 *  @X^bN|C^ݒς
 */ 

    .globl activate_r
activate_r:
                                    /*  r10 = runtsk (fBXpb`Őݒ) */
    lwz     r4, TCB_tinib(r10)      /*  r4 = runtsk->tinib  */

                                    /*  ^XNNԒn̐ݒ  */
    lwz     r5, TINIB_task(r4)      
    mtctr   r5                      /*  CTR = runtsk->tinib->task  */

                                    /*  ^XNւ̈igj  */
    lwz     r3, TINIB_exinf(r4)     /*  r3 = runtsk->tinib->TINIB_exinf  */

    /*
     *  LRWX^ext_tskݒ肷邱ƂɂAext_tsk
     *  Ă΂ȂŃ^XN̊֐𔲂ꍇext_tskɕ򂷂B
     */                                 
    LI32(r6, ext_tsk)
    mtspr   LR, r6                  /*  ^XN̖߂Ԓnݒ  */

    mfmsr   r8
    ori     r9, r8, MSR_EE
    mtmsr   r9                      /*  ݋  */

    bctr                            /*  Cꃋ[`Ăяo  */


/*
 *  ԑ҂ 
 *@@r3F҂ԂnsecPʂŎw肷
 */
    .globl sil_dly_nse
sil_dly_nse:
    LI32(r4, SIL_DLY_TIM1)
    sub.    r3, r3, r4          /* r3 SIL_DLY_TIM1 */
    blelr                       /* ʂ0ȉȂ烊^[ */

    LI32(r5, SIL_DLY_TIM2)
sil_dly_nse_1:
    sub.    r3, r3, r5          /* r3 SIL_DLY_TIM2 */
    bgt     sil_dly_nse_1       /* ʂ 0 傫΃[v */
    blr

/*  end of file  */
