/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[̃Tv
 *@@@@@J[lŎgp`
 *@@@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  [U[`
 */
#include <user_config.h>

/*
 *  J[l̓ʖ̃l[
 */
#include <sys_rename.h>

/*
 *  ^[QbgVXẽn[hEFA̒`
 */
//#include <******.h>
//#include <******.h>


/*
 *  NbZ[W̃^[QbgVXe
 */
#define	TARGET_NAME	"Target name"

/*
 *  ԑ҂̂߂̒`
 */
#define	SIL_DLY_TIM1	1425
#define	SIL_DLY_TIM2	 350

#ifndef _MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgD
 *@@ROMj^^GDB STUBďo͖
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`D
 *@@ROMj^^GDB STUBďo͖
 */
extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*  --------------------------------------------------------------  */
/*
 * PowerPCʕƂ̃C^[tF[X̒`
 */

/*
 *   MSȐl
 */
#define INIT_MSR    	0

/*
 *  ݂̖{
 */
#define TMAX_INTNO       10

/*
 *  ݏICUˑ
 *  @e
 *  @@Eݗv̔
 *  @@E݃}XN̐ݒ
 *  @@E݋
 *  @@ECꃋ[`Ăяo
 *  @@E݋֎~
 *  @@EiKvł΁j荞ݗvtÕNA
 *  @
 *  @
 *  @  labelFxʗp
 *  @  @@@@iӏł̃}Ngpł悤ɂ邽߁j
 */
#define _PROC_ICU(label)

/* }NlabelmɓWJ邽߁A}N2dɂĂ */
#define PROC_ICU(label) _PROC_ICU(label)


/*
 * 荞݃Rg[̃}XNIPM֘A̒`
 */

/*  IPM̑Ҕ  */
    /*  ӁFsp4oCgEɈێ  */
#define PUSH_ICU_IPM

/*  IPM̕  */
    /*  ӁFsp4oCgEɈێ  */
#define POP_ICU_IPM


#ifdef SUPPORT_CHG_IPM
/*
 * ICUɐݒ肷IPMp[^̃`FbN
 *
 *@C
 *  @if (ipm̒ls) {
 *	ercd = E_PAR;
 *	goto exit;
 *    }
 *@Ɠ̏s}N
 */
#define CHECK_IPM(ipm)

/*
 * 荞݃Rg[̃}XN擾
 */
#define GET_IPM(p_ipm)	

/*
 * 荞݃Rg[̃}XNݒ
 */
#define CHG_IPM(ipm)

#endif	/*  SUPPORT_CHG_IPM  */


#ifndef _MACRO_ONLY

/*
 *  ݃}XNp[xN^e[u
 *	ipm_tablê$(CPU)Ƃ̃C^[tF[XɊ܂܂Ȃ
 *@@@idefine_ipmɂABĂj
 */
extern IPM ipm_table[];

/*
 *  荞݃x̐ݒ
 *	ݔԍinhno݂̊󂯕tƂɊ݃Rg[
 *	IPMɐݒ肷l`B
 *	foCXhCȍŎgp邱Ƃz肵ĂB
 *
 *@@@
 *@@@@inhnoF݃nhԍ
 *@@@@ipmF݃}XN
 *
 */
Inline void
define_ipm(INHNO inhno, IPM ipm)
{
	ipm_table[inhno] = ipm;
}

#endif /* _MACRO_ONLY */

/*  
 *  ȓd̓[hւ̈ڍsƊ݋
 *  @sׂ^XNȂĊݑ҂ɂȂƂ
 *  @fBXpb`̒ŎgpB
 */ 
#define SAVE_POWPER	/*  eAZuŋLq  */


/* ----------------------------------------------------------------- */
/*
 * The IBM PowerPC Embedded Environmentp̒`
 */

/*
 * O[`̒`iK{j
 */

/*
 *  Critical Interrupt
 *  @ItZbgF0x100
 *  @Critical Interrupt̓Cve[VˑȂ̂
 *  @e̓}N`ĂB
 *  @@}NFCRITICAL_INTERRUPT_EXCEPTION_PROC
 *  @̏e0x100oCg𒴂Ă͂ȂB
 *  @iꍇ͎c̕ʂ̏ꏊɔzuāA
 *  @@ɕ򂷂邱Ɓj
 *
 *  @Critical Interrupt̓J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 */
#define CRITICAL_INTERRUPT_EXCEPTION_PROC	rfci
				/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */


/*
 *  }VE`FbNO
 *  @̏e0x100oCg𒴂Ă͂ȂB
 *  @iꍇ͎c̕ʂ̏ꏊɔzuāA
 *  @@ɕ򂷂邱Ɓj
 *
 *  @J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 */
#define MACHINE_CHECK_PROC	rfci
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 *  Programmable Interval timer
 *  @ItZbgF0x1000
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
#define PROGRAMMABLE_INTERVAL_TIMER_PROC
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 *  Fixed Interval timer
 *  @ItZbgF0x1010
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
#define FIXED_INTERVAL_TIMER_PROC
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 *  Watchdog timer
 *  @ItZbgF0x1020
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 *
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 *  @J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 */
#define WATCHDOG_TIMER_PROC	rfci
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 *  Data TLB miss
 *  @ItZbgF0x1100
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
#define DATA_TLB_MISS_PROC
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 *  Instruction TLB miss
 *  @ItZbgF0x1200
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
#define INSTRUCTION_TLB_MISS_PROC
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */


/*
 *  DebugO
 *  @ItZbgF0x2000
 *
 *@@ONXFCritical
 *  @@^[߂rfci(Return From Critical Interrupt)
 *  @@pB
 *  @
 *  @v͈ȉ7
 *  @@Trap
 *  @@Instruction address compare
 *  @@Data address compare
 *  @@Instruction complete
 *  @@Branch taken
 *  @@Exception
 *  @@Unconditional debug event
 *  @
 *  @J[lǗO̗OƂB
 *  @ȉ[`ŃT[rXR[gpȂBj
 *  @
 *  @0x10oCg̈悪蓖ĂĂȂ̂Œ
 */
#define DEBUG_PROC	rfci
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 *  Cve[Vp̏iItZbgF0xd00-0xff0j
 *    Cve[VŗL̗OxN^
 * @ ItZbg̎w@ɒӂ邱ƁB
 *  @̓Iɂ
 *     .org ItZbg - EXCEPTION_VECTOR_BASE
 * @ ̂悤Ɏw肷Bڂ̗͑Ov̊YQƁB
 *    Ⴆ΁APowerPC405ł̓ItZbg0xf20
 *    APU UnavailableȌzu
 */
//#define IMPLEMENT_EXCEPTION_D00_PROC
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */

/*
 * O[`̒`iIvVj
 */
/*
 *  Cve[Vp̏iItZbgF0x2010-0x2ff0j
 *    Cve[VŗL̗OxN^iPƂ͌Ȃj
 *    ̗prɎgp
 * @ ItZbg̎w@ɒӂ邱ƁB
 *  @̓Iɂ
 *     .org ItZbg - EXCEPTION_VECTOR_BASE
 * @ ̂悤Ɏw肷Bڂ̗͑Ov̊YQƁB
 */
// #define IMPLEMENT_EXCEPTION_02010_PROC
						/*  AZuŋLq  */
/*  ̃}N`̓foCXɍ킹ĊeĉB  */


#endif /* _SYS_CONFIG_H_ */

/*  end of file  */
