/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  L쌠҂́CFree Software Foundation ɂČ\Ă
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: mpc860elf.ld,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

OUTPUT_FORMAT("elf32-powerpc","elf32-powerpc","elf32-powerpc")
OUTPUT_ARCH(powerpc)

MEMORY
{
	ROM(rxai):ORIGIN = 0x10000000, LENGTH =  4M
	RAM(wxai):ORIGIN = 0x00000000, LENGTH = 16M
}

PROVIDE (__stack = 0) ;
PROVIDE(hardware_init_hook = 0);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);
PROVIDE(memcpy = _dummy_memcpy);
SECTIONS
{
    .exception_vector 0x10000100 :
    {
	*(.exception_vector)
    } >ROM
    .init :
    {
        KEEP (*(.init))
    } >ROM
    .text :
    {
        __text = . ;
        *(.text .stub .text.* .gnu.linkonce.t.*)
    } >ROM
    .fini :
    {
        KEEP (*(.fini))
    } >ROM
    _etext = . ;
    PROVIDE (etext = .) ;
    .rodata :
    {
        *(.rodata .rodata.* .gnu.linkonce.r.*)
    } >ROM
    . = ALIGN(4) ;

    __idata_start = . ;
    .data : AT(__idata_start) 
    {
        __data_start = . ;
        *(.data)
    } >RAM

    __isdata_start = . ;
    .sdata : AT(__idata_start + SIZEOF(.data)) 
    {
        __sdata_start = . ;
        *(.sdata)
    } >RAM

    .eh_frame : { KEEP (*(.eh_frame)) }
    .gcc_except_table : { *(.gcc_except_table) }
    .ctors :
    {
        KEEP (*crtbegin.o(.ctors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .ctors))
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
    }
    .dtors :
    {
        KEEP (*crtbegin.o(.dtors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .dtors))
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
    }
/*     __idata_end = __idata_start + SIZEOF(.data) ; */
    __idata_end = __idata_start + SIZEOF(.data) + SIZEOF(.sdata) ;
    _edata  = . ;
    PROVIDE (edata = .) ;
    . = ALIGN(4) ;
    __sbss_start = . ;
    .sbss :
    {
        *(.sbss)
    } >RAM
    __bss_start = . ;
    .bss :
    {
        *(.bss)
        *(COMMON)
    } >RAM
    _end = . ;
    __bss_end = . ;
    PROVIDE (end = .) ;
    .comment        0 : { *(.comment) }
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }
}
