/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[iMPC860T TB6102Spj
 *@@@@@J[lŎgp`
 *@@@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  [U[`
 */
#include <user_config.h>

/*
 *  J[l̓ʖ̃l[
 */
#include <sys_rename.h>

/*
 *  ^[QbgVXẽn[hEFA̒`
 */
#include <tb6102s.h>
#include <mpc860t.h>


/*
 *  NbZ[W̃^[QbgVXe
 */
#define	TARGET_NAME	"TANBAC TB6102S CompactPCI CPU Board"

/*
 *  ԑ҂̂߂̒`
 */
#ifdef DOWNLOAD_TO_RAM      /*  fobOp  */

#define	SIL_DLY_TIM1	1425
#define	SIL_DLY_TIM2	 350

#else /* DOWNLOAD_TO_RAM */ /*  ROM  */

#define	SIL_DLY_TIM1	3445
#define	SIL_DLY_TIM2	 867

#endif /* DOWNLOAD_TO_RAM */

#ifndef _MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgD
 *@@ROMj^^GDB STUBďo͖
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`D
 *@@ROMj^^GDB STUBďo͖
 */
extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*
 * @CPMւ̊ݗṽNA
 * @@CPM݃CT[rXWX^CISR̊YrbgɂPZbg
 * @@NAB
 */
#define CLEAR_IRQ_TO_ICU(device)		\
	mpc860_wrw_mem(CISR, CISR_BIT(device))	


/*
 * @o^ĂȂSIU݂ɂݒ
 * @@i݂̊Ƒd݂ŁAsp̎oقȂ
 */
#define SET_NO_REG_SIU_INTERRUPT_ARG_FROM_TASK	\
	lwz	r4, 0(sp)	/*  ݃X^bNsp𕜌  */

#define SET_NO_REG_SIU_INTERRUPT_ARG_FROM_INT	\
	addi	r4, sp, 8	/*  sp+8  */

/*
 * @o^ĂȂCPM݂ɂݒ
 * @@i݂̊Ƒd݂ŁAsp̎oقȂ
 */
#define SET_NO_REG_CPM_INTERRUPT_ARG_FROM_TASK	\
	lwz	r4, 8(sp)	/*  ݃X^bNsp𕜌  */

#define SET_NO_REG_CPM_INTERRUPT_ARG_FROM_INT	\
	addi	r4, sp, 16	/*  sp+16  */


#ifndef _MACRO_ONLY
/*
 * o^ĂȂݔ̃Oo
 * @@}NPROC_ICU̒ŌĂяoB
 *     ֐̌^̓vZbTɌ߂ėǂB
 *
 *     MPC860ł͊݃Rg[JXP[hڑĂ邽߁A
 *@@ e݃Rg[ɐp̊֐pӂB
 *
 */

/*  SIU݁iCPM݈ȊOj  */
extern void     no_reg_SIU_interrupt(INHNO intno, UW *sp);

/*  CPM  */
extern void     no_reg_CPM_interrupt(INHNO intno, UW *sp);

#endif /* _MACRO_ONLY */

#define EXCEPTION_VECTOR_START_SRC	0x10000100
#define EXCEPTION_VECTOR_END_SRC	0x10002000
#define EXCEPTION_VECTOR_START_DST	0x100



/*  --------------------------------------------------------------  */
/*
 * PowerPCʕƂ̃C^[tF[X̒`
 */

/*
 *   MSȐl
 */
#define INIT_MSR    	0

/*
 *  ݏICUˑ
 *  @e
 *  @@Eݗv̔
 *  @@E݃}XN̐ݒ
 *  @@E݋
 *  @@ECꃋ[`Ăяo
 *  @@E݋֎~
 *  @@EiKvł΁j荞ݗvtÕNA
 *  @
 *  @
 *  @  labelFxʗp
 *  @  @@@@iӏł̃}Ngpł悤ɂ邽߁j
 *  @
 *
 *  @MPC860̊݃A[LeN`
 *  @@EVXeEC^[tF[XEjbgSIU
 *  @@EʐMvZbTW[CPM
 *  @2KwɂȂĂ
 *  @
 *  @@MPC860ł̓VXeC^[tF[XjbgSIŮ݃}XN
 *  @@iSIU݃}XNWX^SIMASKĵ݂J[lŊǗB
 *  @@ʐMvZbTW[CPM̊݃}XN̊Ǘׂ͂
 *  @@n[hEFAsĂB
 *  @
 *  @CPM݃Rg[in[hEFAj̓
 *  @  @݂
 *  @  @@EݕۗWX^CIPR̊Yrbg̊YrbgZbg
 *  @  @@E݂̗Dx
 *  @  @@@@E݃}XNWX^CIMR
 *  @  @@@@ECT[rXWX^CISR
 *  @  @@@@ƔrĂSIUɒʒm
 *  @  @RAxN^WX^CIVRIACKrbgZbg
 *  @  @@ESIUւ̊ݗvNA
 *  @  @@ExN^WX^CIVRɃxN^ԍZbg
 *  @  @@ExN^WX^CIVRIACKrbgNA
 *  @  @@EݕۗWX^CIPR̊YrbgNA
 *  @  @@ECT[rXWX^CISR̊YrbgZbg
 *  @  @@@@ȌA艺ʂ݂̊}XN
 *  @  @@@@@@CPMɂĂ̓\tgEFAɂ}XN̕KvȂ
 *  @  @@
 *  @CPM݂ɊւẮASIUIPMɈꊇēlݒ肷
 *  @  @@
 *  @
 *  @WX^蓖āF
 *  @  SPRG1:[xN^e[u̐擪AhXint_table
 *  @  SPRG3:IPMe[u̐擪AhXipm_table
 *  @  r0FlO
 *  @  r3FWX^̈̐擪AhX
 *  @  r4F݃xN^ԍ~S
 *  @
 */
#define _PROC_ICU(label)                                                \
    /*  SIŮݗv  */                                         \
    lis     r3, IMMR_UPPER_2BYTE; /* WX^̈̐擪AhX */  \
        /*  xN^ԍ̓ǂݏo  */                                    \
        /*  SIVECWX^ɂ"xN^ԍ~4"i[Ă  */        \
    lbz     r4, TADR_SIU_SIVEC(r3); /*  r4xN^ԍ~4  */           \
                                                                        \
    /*  ݃}XN̐ݒ  */                                          \
    /*  @SIU݁Fݗv̒lIPMɐݒ肷  */      		\
    /*  @CPM݁FꊇēlSIUIPMɐݒ肷  */   		\
    mfspr   r5, SPRG3;      /*  r5ipm_table  */                       \
    srwi    r6, r4, 1;      /*  r6r4>>1iݔԍ~2{j  */        \
    lhzx    r7, r5, r6;     /*  r7F݃}XN  */                    \
    	/*  ݂̊݃}XNmFāA  */				\
    	/*  XAĂȂ݂͋Ȃ悤ɂ  */	\
    lhz     r8, TADR_SIU_SIMASK(r3);					\
    and     r9, r8, r7;							\
    sth     r9, TADR_SIU_SIMASK(r3);/*  ݃}XNݒ  */            \
                                                                        \
    /*  CPM݂ȂΕ  */                                         \
    cmpwi   crf0, r4, INHNO_CPM*4;                                      \
    beq     label##_CPM_INTERRUPT;                                      \
                                                                        \
    /*  SIU݁iCPM݈ȊOj̏ꍇ  */                            \
    /*  iSIUɒځAڑĂfoCX݂̊̏ꍇj  */     \
    mfspr   r8, SPRG1;  /*  r8SPRG1Fint_table  */                    \
                        /*  r4Fݔԍ~4  */                       \
    lwzx    r9, r8, r4; /*  r9FCꃋ[`̐擪AhX  */         \
    mtctr   r9;         /*  CTRr9  */                                 \
    mfmsr   r10;                                                        \
    ori     r11, r10, MSR_EE;   /*  EErbgZbg  */                \
    mtmsr   r11;                /*  ݋  */                      \
    cmpwi   crf0, r9, 0;	/*  ݃nho^Ă邩 */ \
    beq     label##_call_no_reg_SIU_interrupt; /*  `FbN  */         \
    bctrl;                      /*  Cꃋ[`Ăяo  */           \
    mfmsr   r10;                                                        \
    xori    r11, r10, MSR_EE;   /*  EErbgNA  */                \
    mtmsr   r11;        /*  ݋֎~  */                              \
    b       label##_exit;/*  PROC_ICU}N̏oփWv  */         \
                                                                        \
    /*                                                                  \
@@ *@@SIU݁iCPM݈ȊOjŊ݃nh                  \
@@ *@@o^ĂȂꍇ                                          \
@@ */                                                                 \
label##_call_no_reg_SIU_interrupt:;                                     \
    srwi    r3, r4, 2;          /*  r3ݔԍ  */                  \
    SET_NO_REG_SIU_INTERRUPT_ARG_##label;                               \
    LI32(r9, no_reg_SIU_interrupt);                                     \
    mtctr   r9;         /*  CTRr9  */                                 \
    bctr;                                                               \
    /*  ɂ͖߂ĂȂ  */                                        \
                                                                        \
    /*                                                                  \
@@ *@@CPM݂Ŋ݃nh                                   \
@@ *@@o^ĂȂꍇ                                          \
@@ */                                                                 \
label##_call_no_reg_CPM_interrupt:;                                     \
    srwi    r3, r4, 2;          /*  r3ݔԍ  */                  \
    SET_NO_REG_CPM_INTERRUPT_ARG_##label;                               \
    LI32(r9, no_reg_CPM_interrupt);                                     \
    mtctr   r9;         /*  CTRr9  */                                 \
    bctr;                                                               \
    /*  ɂ͖߂ĂȂ  */                                        \
                                                                        \
                                                                        \
    /*  CPM݂̏ꍇ  */                                             \
    /*  @@SIUIPM͐ݒς  */                                      \
    /*  @@CPMIPMݒ̓n[hEFAs  */                        \
label##_CPM_INTERRUPT:;                                                 \
    /*  CIVRWX^IACKrbgZbg  */                            \
    li      r5, TA_CPM_CIVR_IACK;                                       \
    sth     r5, TADR_CPM_CIVR(r3);                                      \
    /*  CPM݃xN^ԍǂݏo  */                                 \
            /*  ݃xN^WX^CIVRɂ̓xN^ԍ  */            \
            /*  11rbgVtgꂽԂŊi[Ă  */          \
    lhz     r6, TADR_CPM_CIVR(r3);  /*  r6xN^ԍ<<11  */          \
    srwi    r4, r6, 9;  /*  r4r6>>9iݔԍ~4{j  */            \
    stwu    r4, -STACK_MARGIN(sp); /*  xN^ԍۑ  */             \
    		/*  sp8oCg炷̂́ACꃋ[`  */		\
    		/*  sp+4Ԓnɏ݂s  */			\
        /*  CPM[J̃xN^ԍSIUŜ̃xN^ԍɕϊ  */      \
    addi    r5, r4, TMAX_SIU_INTNO*4;                                   \
    mfspr   r8, SPRG1;  /*  r8SPRG1Fint_table  */                    \
                        /*  r4Fݔԍ~4  */                       \
    lwzx    r9, r8, r5; /*  r9FCꃋ[`̐擪AhX  */         \
    mtctr   r9;         /*  CTRr9  */                                 \
    mfmsr   r10;                                                        \
    ori     r11, r10, MSR_EE;   /*  EErbgZbg  */                \
    mtmsr   r11;                /*  ݋  */                      \
    cmpwi   crf0, r9, 0;	/*  ݃nho^Ă邩 */ \
    beq     label##_call_no_reg_CPM_interrupt; /*  `FbN  */         \
    bctrl;                      /*  Cꃋ[`Ăяo  */           \
    mfmsr   r10;                                                        \
    xori    r11, r10, MSR_EE;   /*  EErbgNA  */                \
    mtmsr   r11;        /*  ݋֎~  */                              \
    /*  CT[rXWX^CISR̊YrbgNA  */                \
    /*      iPނƃNAj  */                          \
    lwz     r4, 0(sp);  /*  xN^ԍ~4ǂݏo  */                 \
    addi    sp, sp, STACK_MARGIN;                                       \
    srwi    r5, r4, 2;  /*  r5r4>>2iݔԍj  */                 \
    li      r6, 1;                                                      \
    slw     r7, r6, r5; /*  r71<<(ݔԍ)  */                     \
    lis     r3, IMMR_UPPER_2BYTE; /* WX^̈̐擪AhX */  \
    stw     r7, TADR_CPM_CISR(r3);                                      \
label##_exit:    /*  PROC_ICȔox  */

/* }NlabelmɓWJ邽߁A}N2dɂĂ */
#define PROC_ICU(label) _PROC_ICU(label)


/*
 * 荞݃Rg[̃}XNIPM֘A̒`
 *  @@MPC860ł̓VXeC^[tF[XjbgSIŮ݃}XN
 *  @@iSIU݃}XNWX^SIMASKĵ݃J[lŊǗB
 *  @@ʐMvZbTW[CPM̊݃}XN̊Ǘׂ͂ăn[h
 *  @@EFAsĂB
 */

/*  IPM̑Ҕ  */
#define PUSH_ICU_IPM                	\
    lis     r4, IMMR_UPPER_2BYTE;      	\
    lhz     r5, TADR_SIU_SIMASK(r4);    \
    sthu    r5, -4(sp)
    /*  XgAsp̍XV1߂Ŏs  */
    /*  ۑf[^2oCgł邪A  */
    /*  sp4oCgEɈێ邽߁AItZbg-4ƂĂ  */

/*  IPM̕  */
#define POP_ICU_IPM                 			\
    lhz     r4, 0(sp);              			\
    lis     r5, IMMR_UPPER_2BYTE;   			\
    addi    sp, sp, 4;           /*  LQ  */	\
    sth     r4, TADR_SIU_SIMASK(r5) 


#ifdef SUPPORT_CHG_IPM
/*
 * ICUɐݒ肷IPMp[^̃`FbN
 *
 *@C
 *  @if (ipm̒ls) {
 *	ercd = E_PAR;
 *	goto exit;
 *    }
 *@Ɠ̏s}N
 */
#define CHECK_IPM(ipm)
	/*  MPC860ł͉`FbNȂ  */

/*
 * 荞݃Rg[̃}XN擾
 */
#define GET_IPM(p_ipm)	*(p_ipm) = sil_reh_mem((VP)SIMASK)

/*
 * 荞݃Rg[̃}XNݒ
 */
#define CHG_IPM(ipm)	sil_wrh_mem((VP)SIMASK, ipm)

#endif	/*  SUPPORT_CHG_IPM  */


#ifndef _MACRO_ONLY

/*
 *  ݃}XNp[xN^e[u
 *	ipm_tablê$(CPU)Ƃ̃C^[tF[XɊ܂܂Ȃ
 *@@@idefine_ipmɂABĂj
 */
extern IPM ipm_table[];

/*
 *  荞݃x̐ݒ
 *	ݔԍinhno݂̊󂯕tƂɊ݃Rg[
 *	IPMɐݒ肷l`B
 *	foCXhCȍŎgp邱Ƃz肵ĂB
 *
 *@@@
 *@@@@inhnoF݃nhԍ
 *@@@@ipmF݃}XN
 *
 */
Inline void
define_ipm(INHNO inhno, IPM ipm)
{
	ipm_table[inhno] = ipm;
}

#endif /* _MACRO_ONLY */

/*  
 *  ȓd̓[hւ̈ڍsƊ݋
 *  @sׂ^XNȂĊݑ҂ɂȂƂ
 *  @fBXpb`̒ŎgpB
 *
 *  @E݂߂ĂɊ݋֎~s
 *  @Er0`r4̓ej󂵂Ă͂ȂȂ
 *  @
 *  @MCP860ł̓h[YE[E[hp
 *  @
 *  @WX^蓖
 *  @@r0FlO
 *  @@r5FWX^̐擪AhX
 *  @@r6FbNEL[[h0x55ccaa33
 */ 
#define SAVE_POWPER                                                 \
    lis     r5, IMMR_UPPER_2BYTE;                                   \
    LI32(r6, UNLOCK_KEY);                                           \
    stw     r6, TADR_SCCRK(r5);   /* SCCRAbN */              \
                                                                    \
    /* CRQEN=1FCP삷ƂAh[YEnCE[h    */      \
    /* PRQEN=1FݗvŃm[}EnCE[h        */      \
    lwz     r7, TADR_SCCR(r5);                                      \
    oris    r7, r7, (SCCR_CRQEN | SCCR_PRQEN)>>16;                  \
    stw     r7, TADR_SCCR(r5);                                      \
                                                                    \
    stw     r0, TADR_SCCRK(r5);     /* SCCRbN */                \
                                                                    \
    stw     r6, TADR_PLPRCRK(r5);   /* PLPRCAbN */           \
                                                                    \
    /* PLPRCR                                   */                  \
    /*    TMIST=0F݃\[XNAĂ   */                  \
    /*           h[YE[E[hɖ߂Ȃ */                  \
    lwz     r8, TADR_PLPRCR(r5);                                    \
    ori     r8, r8, PLPRCR_TIMIST;                                  \
    xori    r8, r8, PLPRCR_TIMIST;                                  \
    stw     r8, TADR_PLPRCR(r5);                                    \
                                                                    \
    /* h[YE[E[hɑJڂ邽߂̒lݒ   */              \
    /*      CSRC=1F                                */              \
    /*      LPM=01F                                */              \
    ori     r8, r8, (PLPRCR_CSRC | PLPRCR_LPM);                     \
    xori    r8, r8, PLPRCR_LPM10;                                   \
    stw     r8, TADR_PLPRCR(r5);                                    \
                                                                    \
    stw     r0, TADR_PLPRCRK(r5);   /* PLPRCbN */               \
                                                                    \
    /* ݋ƃh[YE[E[hւ̈ڍs */                  \
    mfmsr   r9;                                                     \
    ori     r9, r9, MSR_EE;         /*  EErbgZbg  */          \
    oris    r9, r9, MSR_POW>>16;    /*  POWrbgZbg  */         \
    mtmsr   r9;                                                     \
    /*  Ŋ݂ih[YE[E[hő҂j  */        \
    /*  @݂߂Ƃr9̒lɂȂĂ  */          \
                                                                    \
    /*  ݋֎~  */                                              \
    xori    r9, r9, MSR_EE;         /*  EErbgNA  */          \
    xoris   r9, r9, MSR_POW>>16;    /*  POWrbgNA  */         \
    mtmsr   r9


/*
 * Cve[VŗL̗O0x01000̏e`}N
 * @
 * }NIMPLEMENT_EXCEPTION_01000`Ăꍇ̂ݗLƂȂB
 * e̓vZbT̃Cve[VŗL̂̂Ȃ̂ŁA
 * J[lɂo͑}ꂸÃ}NŒ`e
 * ڌĂяoBi܂AJ[l̊ǗOj
 * ̂߁ȀŃJ[l̋@\Ăяoꍇ͖̓`
 * B
 * @
 * ItZbg0x01000ȍ~ɔzuOv͂PƂ͌ȂB2ȏ
 * ̗OxN^zuꍇAItZbg̎w@ɒӂ邱ƁB
 * @̓Iɂ
 *     .org ItZbg - EXCEPTION_VECTOR_BASE
 * ̂悤Ɏw肷Bڂcpu_support.S̊YQƁB
 * @
 */
#define MAKE_EXCEPTION_VECTOR(offset, name)	\
    .org offset - EXCEPTION_VECTOR_BASE;	\
name:;						\
  MAKE_EXCEPTION_ENTRY(offset)


#define IMPLEMENT_EXCEPTION_01000_PROC				\
software_emulation:;						\
  MAKE_EXCEPTION_ENTRY(0x1000);					\
								\
MAKE_EXCEPTION_VECTOR(0x1100, instruction_TLB_miss);		\
MAKE_EXCEPTION_VECTOR(0x1200, data_TLB_miss);			\
MAKE_EXCEPTION_VECTOR(0x1300, instruction_TLB_error);		\
MAKE_EXCEPTION_VECTOR(0x1400, data_TLB_error);			\
MAKE_EXCEPTION_VECTOR(0x1c00, data_break_point);		\
MAKE_EXCEPTION_VECTOR(0x1d00, instruction_break_point);		\
MAKE_EXCEPTION_VECTOR(0x1e00, peripheral_break_point);		\
MAKE_EXCEPTION_VECTOR(0x1f00, non_maskable_developement_port)


#endif /* _SYS_CONFIG_H_ */

/*  end of file  */
