/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[ AZuꕔ
 *@@@@@J[lŎgp`iMPC860T TB6102Spj
 *  
 *  @@{[hˑ𕪗ƁÃt@C͂قƂǋɂȂ
 *  @@܂̂ŁÂ܂܂ɂĂB
 *  
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"

/*
 *  R}hWX^MCRɐݒ肷WRITEIyR[h
 *
 *  @@@@OP=00FWRITE
 *  @@@@UM=0FUPMA
 *  @@@@MB=000FRUNR}ĥݗL
 *  @@@@MCLF=0FRUNR}ĥݗL
 *  @@@@MAD=0FACCfbNX
 *  @@@@@@@@iɂĂāAʂ̃f[^j
 *  
 */
#define MCR_WRITE_OP	0

/*
 *  ჌x̃^[QbgVXeˑ̏
 *
 *  X^[gAbvW[̒ŁC̏̑OɌĂяoD
 *  
 *  WX^蓖
 *  @@r10FWX^̈̐擪AhX
 *  
 */
    .text
    .globl hardware_init_hook
hardware_init_hook: 
    /*  ipm_tableSPRG3ɃRs[  */
    LI32(r4, ipm_table)
    mtspr   SPRG3, r4

    /*  }bvWX^IMMȐ  */
    /* @WX^̈̐擪AhX̐ݒ */  
    lis     r10, IMMR_UPPER_2BYTE /*  2oCg  */
    mtspr   IMMR, r10   /*  2oCg͏㏑Ăj󂳂Ȃ  */
    
#ifdef DOWNLOAD_TO_RAM      /*  fobOp  */
    
    /*
     *  RAMɃ_E[hꍇ
     *
     *  @@OxN^̃ItZbg0x000x,xxxxɂB
     */
    li      r5, 0
    mtmsr   r5		/*  MSR.IP0  */
    blr
    
#else /* DOWNLOAD_TO_RAM */ /*  ROM  */
    

    /*  oXRg[̏  */    

    /*
     *  \tgEFAEEHb`hbN^C}̏
     */

    /*  EHb`hbN^C}NA  */
    li      r6, SWSR_CLEAR1
    sth     r6, TADR_SIU_SWSR(r10)
    ori     r6, r0, SWSR_CLEAR2
    sth     r6, TADR_SIU_SWSR(r10)
    
    /*
     *  @EHb`hbN^C}fBZ[uɂ
     *  @  SYPCR.SWE0
     */
    lwz     r5, TADR_SIU_SYPCR(r10)
    ori	    r5, r5, SYPCR_SWE
    xori    r5, r5, SYPCR_SWE
    stw     r5, TADR_SIU_SYPCR(r10)


    /*
     *  FlashROMoXRg[̏
     *  @2MB
     *  @AhX}bvF0x1000,0000-0x101f,ffff
     *  @`bvZNgMFCS0
     *  @Rg[Fėp`bvEZNgE}VGPCM
     *  @16rbgANZX
     *  @
     *  @u[g`bvZNgCS0ɊւĂ
     *  @BR0OR0̏ɐݒ肵Ȃ΂ȂȂ
     *  @
     */

    /*
     *  OoXW̐ݒ
     *  @SCCR.EBDF=00FCLKOUTGCLK21̕
     */
    LI32(r4, UNLOCK_KEY)
    stw     r4, TADR_SCCRK(r10)     /* SCCRAbN */
    lwz     r5, TADR_SCCR(r10)
    oris    r6, r5, (SCCR_EBDF>>16)
    xoris   r7, r6, (SCCR_EBDF>>16)
    stw     r7, TADR_SCCR(r10)
    li      r0, 0
    stw     r0, TADR_SCCRK(r10)     /* SCCRbN */


    /*
     *  x[XWX^BR0 = 0x1000,0801
     *  @@BA=0x1000(0b)FANZX͈ 0x1000,0000`
     *  @@PS=10F|[gTCY 16rbg
     *  @@PARE=0FpeBEfBZ[u
     *  @@WP=0F[h^CgiیȂj@v
     *  @@MS=00FUPMAgp
     *  @@V=1FBR0,OR0L
     *
     *@@@n[hEFAE}jAɂBR0̓[hI[
     *@@@邪A炵
     */
    LI32(r3, 0x10000801)
    stw     r3, TADR_BR0(r10)

    /*
     *  IvVEWX^OR0 = 0xffe0,0936
     *  @@MA=0xffe0(0b)FANZX͈21rbgi2MBj
     *  @@CSNT=1F`bvEZNgElQ[g
     *  @@ACS=00FCSAhXCƓɏo
     *  @@BIH=1Fo[Xg֎~iGPCMȂZbgȂ΂ȂȂj
     *  @@SYC=3FTCN
     *  @@SETA=0F^O̓]ANmbW͍ŏ̃ANZXF
     *  @@TRLX=1F^C~Oɘa
     *  @@EHTR=1F[h̃z[hԉ
     */
    LI32(r4, 0xffe00936)
    stw     r4, TADR_OR0(r10)

    /*  MSR.IP=0(A20=L)̏ꍇ̐ΔԒnɃWv  */
    LI32(r5, activate_A20_line)
    mtctr   r5
    bctr
    
    /*  A20M̊  */
activate_A20_line:
    /*  ėpI/O@\IFPBPAR.DD270  */
    lhz     r6, (TADR_PBPAR + 2)(r10)
    andi.   r6, r6, (~PBPAR_DD27 & 0xffff)
    sth     r6, (TADR_PBPAR + 2)(r10)

    /*  o͕IiójFPBDIR.DR271  */
    lhz     r7, (TADR_PBDIR + 2)(r10)
    ori     r7, r7, PBDIR_DR27
    sth     r7, (TADR_PBDIR + 2)(r10)
    
    /*  ANeBuɃhCuFPBODR.OD270  */
    lhz     r8, (TADR_PBODR + 2)(r10)
    andi.   r8, r8, (~PBODR_OD27 & 0xffff)
    sth     r8, (TADR_PBODR + 2)(r10)
    
    /*  A20=1óFPBDAT.D271  */
    lhz     r9, (TADR_PBDAT + 2)(r10)
    ori     r9, r9, PBDAT_D27
    sth     r9, (TADR_PBDAT + 2)(r10)
    nop
    nop
    nop


    /*
     *  SDRAMoXRg[̏
     *  @50MHz
     *  @16MB
     *  @AhX}bvF0x0000,0000-0x00ff,ffff
     *  @`bvZNgMFCS2
     *  @Rg[F[UEvO}uE}VUPMA
     *  @32rbgANZX
     *  @
     *  @WX^蓖
     *  @@r10FWX^̈̐擪AhX
     *  @
     *  @l
     *  @@@UPMWX^ORxBRx̏ɐݒ肷
     *  @
     *  @
     */

    /*
     *  Rg[UPMA̐ݒ背WX^
     *  @
     *  @tbV1CLK~vXP[l~^C}
     *  @@@@@@@@@20nsec@~@@ 32 @@@~@24
     *  @@@@@@@@@15.36sec
     */

    /*
     *  ^C}EvXP[EWX^MPTPR = 0x0200
     *  @@PTP=0x2F32ɂ镪
     */
    ori     r3, r0, 0x0200
    sth     r3, TADR_MPTPR(r10)

    /*
     *  }VA[hEWX^MAMR = 0x1880,2111
     *  @@PTx=24FtbV
     *  @@PTxE=1F^C}Cl[u
     *  @@AMx=0FAhXdTCY
     *  @@DSx=00FfBZ[u 1TCN
     *  @@G0CLx=001FGPL0ɑ΂AhXCo͂A11
     *  @@GPLx4DIS=0FUPWAIT/GPL_x4GPL_x4ɒ`
     *  @@RLFx=0001F[hTCÑ[v 1
     *  @@WLFx=0001FCgTCÑ[v 1
     *  @@TLFx=0001F^C}T[rXTCÑ[v 1
     */
    LI32(r4, 0x18802111)
    stw     r4, TADR_MAMR(r10)

    /*
     *  IvVEWX^OR2 = 0xff00,0600
     *  @@MA=0xff00(0b)FANZX͈24rbgi16MBj
     *  @@SAM=0FdAhXȂ
     *  @@G5LA=1FGPL_A5œGPL5Mo
     *  @@G5LS=1FGPL5GCLK1_50̗オGbWHɃhCu
     *  @@BIH=0Fo[XgANZXT|[g
     */
    LI32(r5, 0xff000600)
    stw     r5, TADR_OR2(r10)

    /*
     *  x[XEWX^BR2 = 0x0000,0081
     *  @@BA=0x0000(0b)FANZX͈ 0x0000,0000`
     *  @@PS=00F|[gTCY 32rbg
     *  @@PARE=0FpeBEfBZ[u
     *  @@WP=0F[h^CgiیȂj
     *  @@MS=10FUPMAgp
     *  @@V=1FBR2,OR2L
     */
    ori     r6, r0, 0x0081
    stw     r6, TADR_BR2(r10)
    
    /*
     *  RAMAC̏
     *  @RAMACMPC860̓łAOɃANZX
     *  @ۂ̊eTCNɂs̏ԂK肷B
     *  @
     *  @WX^蓖
     *  @@r3F|C^e[uւ̃|C^
     *  @@r4Fރ[hic萔j
     *  @@r5Ff[^̃AhX
     *  @@r6F]̃CfbNX
     *  @@r10FWX^̈̐擪AhX
     */
	    /*  @lwzu߂g₷Ȃ悤  */
	    /*  @AhX-4Ă  */
    LI32(r3, (RAM_array_index-4))

    /*  ubNf[^݃[v  */
RAM_array_block_init_loop:
    lwzu    r4, 4(r3)       /*  [h  */
    			    /*    r3CNg_ɒ */
    cmpwi   crf0, r4, 0     /*  e[uɎw肳ꂽ[h  */
    beq     SDRAM_init      /*  [Ȃ΁AfoCX̏  */
    lwzu    r5, 4(r3)       /*  f[^̃AhX  */
    			    /*  @lwzu߂g₷Ȃ悤  */
    			    /*  @AhX-4Ċi[Ă  */
    lwzu    r6, 4(r3)       /*  ]̃CfbNX  */
    			    /*    r3CNg_ɒ */

    /*
     *  [hf[^݃[v
     *  @f[^WX^MDRɏ񂾃f[^
     *  @WRITEIyR[hɂRAMACɓ]
     */
RAM_array_word_init_loop:
    lwzu    r8, 4(r5)   /*  f[^  */
			/*    r5CNg_ɒ */
    stw     r8, TADR_MDR(r10)   /*  ݃f[^  */
    ori     r9, r6, MCR_WRITE_OP
    stw     r9, TADR_MCR(r10)   /*  WRITER}hs  */
    subi    r4, r4, 1
    addi    r6, r6, 1
    cmpwi   crf0, r4, 0         /*  ނׂf[^cĂ  */
    bne     RAM_array_word_init_loop    /*  ̃[hf[^̏  */
                    /*  f[^cĂȂ΁ÃubN̏  */
    b       RAM_array_block_init_loop


    /*  SDRAMifoCX́j̏  */
SDRAM_init: 
    /*
     *  SoNEv`[W
     *  
     *  @@R}hWX^MCR = 0x8000,4105
     *  @@@@OP=10FRUN
     *  @@@@UM=0FUPMA
     *  @@@@MB=010FCS2
     *  @@@@MCLF=1F[v1
     *  @@@@MAD=5FACCfbNX
     *  @@@@@@@@iSoNv`[W̖߂Ăj
     */
    LI32(r3, 0x80004105)
    stw     r3, TADR_MCR(r10)
        
    /*
     *  I[gtbV 8
     *  
     *  @@R}hWX^MCR = 0x8000,4830
     *  @@@@OP=10FRUN
     *  @@@@UM=0FUPMA
     *  @@@@MB=010FCS2
     *  @@@@MCLF=8F[v 8 itbV񐔁j
     *  @@@@MAD=0x30FACCfbNX
     *  @@@@@@@@iI[gtbV̖߂Ăj
     */
    LI32(r4, 0x80004830)
    stw     r4, TADR_MCR(r10)
    
    
    /*
     *  샂[hݒ
     *  @CASCeVF2
     *  @o[Xg@ F4
     *  
     *  @@AhXWX^MAR = 0x0000,0088
     *  @@@@AhXoXɏo͂ASDRAMւ̖߂ƂȂ
     *  
     *  @@R}hWX^MCR = 0x8000,4106
     *  @@@@OP=10FRUN
     *  @@@@UM=0FUPMA
     *  @@@@MB=010FCS2
     *  @@@@MCLF=1F[v 1 
     *  @@@@MAD=6FACCfbNX
     *  @@@@@@@@i샂[hݒ̖߂Ăj
     */
    ori     r5, r0, 0x0088
    stw     r5, TADR_MAR(r10)
    LI32(r6, 0x80004106)
    stw     r6, TADR_MCR(r10)
    

/*
 *  OxN^̃Rs[
 */
copy_exception_vector:
	/*  lwzu߂g-4Ă  */
	LI32(r7, EXCEPTION_VECTOR_START_SRC - 4)
	LI32(r8, EXCEPTION_VECTOR_END_SRC - 4)
	LI32(r9, EXCEPTION_VECTOR_START_DST - 4)
copy_exception_vector_1:
	lwzu	r10, 4(r7)	/*  r7̍XV1߂Ŏs  */
	stwu	r10, 4(r9)	/*  r9̍XV1߂Ŏs  */
	cmpw	crf0, r7, r8
	blt	copy_exception_vector_1
	
        /*
         *  MSR.IP0
         *@@OvtBbNXF0x000n,nnnn
         */
	li	r3, MSR_IP
	mfmsr	r4
	or	r4, r4, r3
	xor	r4, r4, r3
	mtmsr	r4
	
	LI32(r10, start_1)
	mtctr	r10
	bctr
	nop
	nop
	nop
	nop

/*
 *  RAMAC̏Ɏgpf[^ւ̃|C^e[u
 *  @[hAf[^̃AhXA]̃CfbNX
 *  @1Zbgi1ubNj
 *  @f[^̃AhXlwzu߂g₷Ȃ悤
 *  @-4ĂB
 *  @
 *  @Ō̓[hÕf[^zuA[vI̔ɗp
 */
RAM_array_index:    
    /*
     *  [hEVOEr[gviv 16[hj
     *  @@E[hEVOEr[gvi5[hj
     *  @@ESoNv`[Wi1[hj
     *  @@E[hݒi2[hj
     *  @@E[hEo[Xgvi8[hj
     */
    .int    16                  /*  [h  */
    .int    RAM_array_RSS - 4   /*  f[^̃AhX  */
    .int    0x0                 /*  ]̃CfbNX  */

    /*
     *  CgEVOEr[gv
     */
    .int    4                   /*  [h  */
    .int    RAM_array_WSS - 4   /*  f[^̃AhX  */
    .int    0x18                /*  ]̃CfbNX  */

    /*
     *  CgEo[Xgv
     */
    .int    7                   /*  [h  */
    .int    RAM_array_WBS - 4   /*  f[^̃AhX  */
    .int    0x20                /*  ]̃CfbNX  */

    /*
     *  ^C}viI[gtbVj
     */
    .int    5                   /*  [h  */
    .int    RAM_array_TPS - 4   /*  f[^̃AhX  */
    .int    0x30                /*  ]̃CfbNX  */

    /*
     *  Ov
     */
    .int    1                   /*  [h  */
    .int    RAM_array_EXS - 4   /*  f[^̃AhX  */
    .int    0x3c                /*  ]̃CfbNX  */

    /*
     *  [vIpf[^
     */
    .int    0                   /*  [h  */
    

/*
 *  RAMACɃRs[f[^
 */

    /*
     *  ȉ̂S̖ߌQÄɔzuiv 16[hj
     *  @@E[hEVOEr[gvi5[hj
     *  @@ESoNv`[Wi1[hj
     *  @@E[hݒi2[hj
     *  @@E[hEo[Xgvi8[hj
     */
RAM_array_RSS:  
    /*  [hEVOEr[gv  */
    .int    0x1f07fc04                      /*  0  */
    .int    0xeeaef004                      /*  1  */
    .int    0x11adf004                      /*  2  */
    .int    0xefbbbc00                      /*  3  */
    .int    0x1ff77c47                      /*  4  */
    /*  SoNv`[W  */
    .int    0x1ff77c07                      /*  5  */
    /*  [hݒpf[^  */
    .int    0xefcab034                      /*  6  */
    .int    0x1f357405                      /*  7  */
    /*  [hEo[Xgv  */
    .int    0x1f07fc04                      /*  8  */
    .int    0xeeaef004                      /*  9  */
    .int    0x10adf004                      /*  a  */
    .int    0xf0affc00                      /*  b  */
    .int    0xf0affc00                      /*  c  */
    .int    0xf1affc00                      /*  d  */
    .int    0xefbbbc00                      /*  e  */
    .int    0x1ff77c47                      /*  f  */

    /*
     *  CgEVOEr[gv
     */
RAM_array_WSS:
    .int    0x1f07fc04                      /*  0x18 + 0  */
    .int    0xeeaeb000                      /*  0x18 + 1  */
    .int    0x01b93004                      /*  0x18 + 2  */
    .int    0x1ff77c47                      /*  0x18 + 3  */

    /*
     *  CgEo[Xgv
     */
RAM_array_WBS:
    .int    0x1f07fc04                      /*  0x20 + 0  */
    .int    0xeeaeb000                      /*  0x20 + 1  */
    .int    0x10ad7000                      /*  0x20 + 2  */
    .int    0xf0affc00                      /*  0x20 + 3  */
    .int    0xf0affc00                      /*  0x20 + 4  */
    .int    0xe1bbbc04                      /*  0x20 + 5  */
    .int    0x1ff77c47                      /*  0x20 + 6  */

    /*
     *  ^C}viI[gtbVj
     */
RAM_array_TPS:
    .int    0x1ff5fc84                      /*  0x30 + 0  */
    .int    0xfffffc04                      /*  0x30 + 1  */
    .int    0xfffffc04                      /*  0x30 + 2  */
    .int    0xfffffc84                      /*  0x30 + 3  */
    .int    0xfffffc05                      /*  0x30 + 4  */

    /*
     *  Ov
     */
RAM_array_EXS:
    .int    0xfffffc07                      /*  0x3c + 0  */


#endif  /*  DOWNLOAD_TO_RAM  */
/*  end of file  */
