/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: vea_oea.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*  
 *   PowerPCA[LeN`VEA,OEAˑ̒`
 *   @IWiPowerPCA[LeN`̏ꍇ
 *   @@g[MPCV[YAIPM PowerPC6xx/7xxV[Y
 *   @@ɊYB
 *   @
 *   @PowerPCA[LeN`̒`͈ȉ̂R̃x琬
 *   @EUSIA:User Instruction Set Architecture
 *   @EVEA: Virtual Environment Architecture
 *   @EOEA: Operating Environment Architecture
 *   @
 *   @USIAɂĂ͑S@틤ʂł邪AVEAOEAɂĂ
 *   @IWiPowerPCA[LeN`The IBM PowerPC 
 *   @Embedded Environmentꂼʂɒ`Ă邽߁A
 *   @VEAOEA̒`̓t@C𕪂āACN[h
 *   @ĂB
 */   

#ifndef _VEA_OEA_H_
#define _VEA_OEA_H_

/*  
 *  WX^ԍ̒`
 */   

/*  
 *  Configuration Register
 */   
#define PVR	287	/*  vZbTEo[WEWX^  */

/*  
 *  Memory Management Registers
 */   
/*  Instruction BAT Registers  */
#define IBAT0U	528
#define IBAT0L	529
#define IBAT1U	530
#define IBAT1L	531
#define IBAT2U	532
#define IBAT2L	533
#define IBAT3U	534
#define IBAT3L	535

/*  Instruction BAT Registers  */
#define DBAT0U	536
#define DBAT0L	537
#define DBAT1U	538
#define DBAT1L	539
#define DBAT2U	540
#define DBAT2L	541
#define DBAT3U	542
#define DBAT3L	543

#define SDR1	 25
#define ASR	280

/*  
 *  Exception Handling Registers
 */   
#define DAR	 19	/*  Data Address Register  */

#define SPRG0   272     /*  ꃌWX^FOSp  */
#define SPRG1   273     /*  ꃌWX^FOSp  */
#define SPRG2   274     /*  ꃌWX^FOSp  */
#define SPRG3   275     /*  ꃌWX^FOSp  */

#define DSISR    18     /*  DSIXe[^XEWX^(*)  */
                        /*  @DSIFf[^EXgA  */
#define SRR0     26     /*  Ҕ^AWX^0  */
#define SRR1     27     /*  Ҕ^AWX^1  */

#define FPECR	1022	/*  Floating-Point Exception Cause Register  */


/*  
 *  Miscellaneous Registers
 */   
/*  Time Base Facility(OEA:for Writing)  */
#define TBLw	284
#define TBUw	285

/*  Time Base Facility(VEA:for Reading)  */
#define TBL	268
#define TBU	269

#define DEC      22     /*  fBNgEWX^(*)  */

#define PIR	1023	/*  Processor Identification Register  */

#define DABR	1013	/*  DATA Address Breakpint Register(option)  */
#define EAR	 282	/*  Exception Access Register(option)  */



/*  
 *   rbgԍ̒`
 *   @ӁFPowerPC̃rbgԍ͒ʏƋtɂȂĂ
 *   @@@@܂A32rbgWX^16rbgWX^ł
 *   @@@@ŉʃrbg̃rbgԍقȂ_ɂ
 */   

/*  }VXe[^XWX^̊erbg̒`  */
/*  @ӁF32rbgECvgp  */
#define MSR_POW BIT13_32    /*  p[}l[WgECl[u  */
#define MSR_ILE BIT15_32    /*  ÕGfBA[h  */
                            /*  @OtMSR.LEMSR.ILE  */
#define MSR_EE  BIT16_32    /*  O݃Cl[u  */
#define MSR_PR  BIT17_32    /*  x  */
                            /*  @0FX[poCUEx  */
                            /*  @1F[UEx  */
#define MSR_FP  BIT18_32    /*  _Cl[u  */
#define MSR_ME  BIT19_32    /*  }V`FbNECl[u  */
#define MSR_FE0 BIT20_32    /*  _O[h0  */
#define MSR_FE1 BIT23_32    /*  _O[h1  */
                            /*  @ӁFԍsA  */
#define MSR_SE  BIT21_32    /*  VOXebvg[XECl[u  */
#define MSR_BE  BIT22_32    /*  g[XECl[u  */
#define MSR_IP  BIT25_32    /*  OvtBbNX  */
                            /*  @0F0x000n,nnnn  */
                            /*  @1F0xfffn,nnnn  */
#define MSR_IR  BIT26_32    /*  ߃AhXϊCl[u  */
#define MSR_DR  BIT27_32    /*  f[^AhXϊCl[u  */
#define MSR_RI  BIT30_32    /*  񕜉\ȗO  */
                            /*  @0:񕜕s\  */
                            /*  @1:񕜉\  */
#define MSR_LE  BIT31_32    /*  gGfBAE[h  */
                            /*  @0FrbOGfBA  */
                            /*  @1FgGfBA  */
/*  0ŗ\񂳂Ărbĝ߂̃}XN  */
#define MSR_MASK    ~(BIT0_32 | BIT1_32 | BIT2_32 | BIT3_32 | BIT4_32 \
                    | BIT5_32 | BIT6_32 | BIT7_32 | BIT8_32 | BIT9_32 \
                    | BIT10_32 | BIT11_32 | BIT12_32 | BIT24_32 \
                    | BIT28_32 | BIT29_32)


/*  
 *   CPUOv̒`
 *   @ԍsAȂ̂CPUO[xN^e[uɈꕔʂ邪A
 *   @PowerPCA[LeN`̒`ɍ킹D悵B
 */   
#define EXC_NO_SYSTEM_RESET             0x1   /*  VXeZbgO  */
#define EXC_NO_MACHINE_CHECK            0x2   /*  }VE`FbNO  */
#define EXC_NO_DSI                      0x3   /*  DSIO  */
                                        /*  if[^EEANZXj  */
#define EXC_NO_ISI                      0x4   /*  ISIOi߃tFb`j  */
#define EXC_NO_EXTERNAL_INTERRUPT       0x5   /*  O  */
#define EXC_NO_ALIGNMENT                0x6   /*  ACgO  */
#define EXC_NO_PROGRAM                  0x7   /*  vOO  */
#define EXC_NO_FLOATING_POINT_UNAVAILABLE 0x8   /*  _gps  */
#define EXC_NO_DECREMENTER              0x9   /*  fN^O  */
                            /*  Cve[VŗL̗O0x00a00  */
#define EXC_NO_IMPLEMENT_EXCEPTION_00A00 0xa 
#define EXC_NO_SYSTEM_CALL              0xc /*  VXeR[  */
#define EXC_NO_TRACE                    0xd /*  g[XiIvVj  */
#define EXC_NO_FLOATING_POINT_ASSIST    0xe /*  _⏕  */
                            /*  Cve[VŗL̗O0x01000  */
#define EXC_NO_IMPLEMENT_EXCEPTION_01000 0x10    


/*  
 *   O̎ʐ
 *   @O݂PƐ
 *   @@0Ԃ͖gp
 *   @@@EOxN^̃ItZbgƑΉ
 *   @@@EO荞݂PƐ
 *   @@@Ez錾̂߁A+1Ă
 */   

#ifdef IMPLEMENT_EXCEPTION_01000    /*  OxN^0x1000gpꍇ  */
#define TMAX_EXCNO       ( 0x10 + 1 )

#else /* IMPLEMENT_EXCEPTION_01000 */
#define TMAX_EXCNO       ( 0xe + 1 )

#endif /* IMPLEMENT_EXCEPTION_01000 */




#endif /* _VEA_OEA_H_ */
/*  end of file  */
