/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *  vZbTˑW[(S1C33p)
 */


#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include "cpu_rename.h"


/*
 *  ݒ\ȍō荞ݗDx
 */
#define	TPS_INTLEV_MAX	(0x04)
#define	TPS_CPULOCK_LEV	(TPS_INTLEV_MAX + 1)

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg	 */


#ifndef _MACRO_ONLY
/*
 *  TCB ֘A̒`
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
/*
 *  ^XNReLXgubN̒`
 *  Task context block.
 */
typedef struct task_context_block {
	VP sp;				/* X^bN|C^	*/
	FP pc;				/* vOJE^	*/
} CTXB;


/*
 *  ōD揇ʃ^XNւ̃fBXpb`(cpu_config.c)
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`(cpu_config.c)
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void exit_and_dispatch(void);

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

/*
 *  CPUbNɕ銄荞݃x
 */
extern UINT	tps_OrgIntLevel;

/*
 *  ݃lXgJE^
 */
extern UINT	tps_IntNestCnt;

/*
 *  rbgT[`}Ngp̐ݒ
 */
#ifndef __c33pe
#define CPU_BITMAP_SEARCH
#endif  /* __c33pe */

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include "cpu_insn.h"

/*
 * VXeԎQƊ֐̕ʖ`
 */
#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock
#define	t_lock_cpu	lock_cpu
#define	i_lock_cpu	lock_cpu
#define	t_unlock_cpu	unlock_cpu
#define	i_unlock_cpu	unlock_cpu

/*
 *  ݂̃ReLXgԂQ
 */
Inline BOOL
sense_context()
{
	return ((tps_IntNestCnt) ? TRUE : FALSE);
}

/*
 *  ݂CPUbNԂQ
 */
Inline BOOL
sense_lock()
{
	UW	ulIntLevel;

	ulIntLevel = get_psr();

	ulIntLevel = (ulIntLevel & S1C33_PSR_MASK_IL);
	return ((ulIntLevel < (TPS_CPULOCK_LEV << 8)) ? FALSE : TRUE);
}

/*
 * CPUbNԐݒ菈
 */
Inline void
lock_cpu()
{
	UW	ulPsr, ulIntLevel;

	ulPsr = get_psr();
	ulIntLevel = (ulPsr & S1C33_PSR_MASK_IL);

	if(ulIntLevel < (TPS_CPULOCK_LEV << 8)){
		ulPsr &= ~S1C33_PSR_MASK_IL;
		set_psr(ulPsr | (TPS_CPULOCK_LEV << 8));
		tps_OrgIntLevel = ulIntLevel;
	}
}

Inline void
unlock_cpu()
{
	UW	ulPsr;

	ulPsr = get_psr();
	ulPsr &= ~S1C33_PSR_MASK_IL;
	ulPsr |= tps_OrgIntLevel;
	tps_OrgIntLevel = (TPS_INIT_INTLEVEL << 8);

	set_psr(ulPsr);
}

/*
 *  CPUO̔̃VXeԂ̎Q
 */
/*
 *  CPUO̔̃ReLXg̎Q
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return ((tps_IntNestCnt > 1) ? TRUE : FALSE);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	UW	ulPsr;

	ulPsr = ((*((UW *)p_excinf) & S1C33_PSR_MASK_IL) >> 8);
	return (ulPsr == TPS_CPULOCK_LEV) ? TRUE : FALSE;
}

/*
 *  OxN^e[u̍\̒`
 */
typedef struct exc_vector_entry {
	FP exchdr;				/* Onh̋NԒn */
} EXCVE;

/*
 *  CPUOnh̐ݒ
 */
#define	define_exc	define_inh

/*
 *  ݃nh̐ݒ
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	EXCVE	*excvt;

	excvt = (EXCVE *) get_ttbr();
	excvt[inhno].exchdr = inthdr;
}

/*
 *  ݃nh̏o̐}N
 */
#define INTHDR_ENTRY(inthdr)	void inthdr##_entry(void) { tpsIntPreWrap(); asm("xcall " #inthdr); tpsIntPostWrap(); }
#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPUOnh̏o̐}N
 */
#define EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)
#define	EXC_ENTRY(exchdr)	exchdr##_entry

/*
 *  /CPUOnh̏o
 *
 *  idle͊荞܂ꂽX^bN==stacktopȂ̂ŁA
 *  idle[`ɂretiŕAłʒuɊ荞݃X^bNݒ肵Ă
 */
Inline void
tpsIntPreWrap(void)
{
#if TPS_DAREA_CNT == 4			/* f[^GAɉđޔ	*/
	Asm("pushn %r11");		/* WX^ύXB	*/
#elif TPS_DAREA_CNT == 3
	Asm("pushn %r12");
#elif TPS_DAREA_CNT == 2
	Asm("pushn %r13");
#elif TPS_DAREA_CNT == 1
	Asm("pushn %r14");
#else
	Asm("pushn %r15");
#endif /* TPS_DAREA */

#ifdef	__c33adv
	Asm("pushs 	%sor				");
#else	/* __c33adv */
	Asm("ld.w	%r0, %ahr			");
	Asm("ld.w	%r1, %alr			");
#endif	/* __c33adv */

	Asm("ld.w	%r2, %sp			");	/* X^bN̐؂ւA		*/
	Asm("xld.w	%r3, _kernel_tps_IntNestCnt	");	/* 荞݃JE^̍XVA	*/
	Asm("ld.w	%r5, [%r3]			");	/* d荞݂̋s	*/
	Asm("xld.w	%%r4, %0 - 8  " : : "g"(STACKTOP));
	Asm("cmp	%r5, 0x00			");
	Asm("jrne	0f				");
	Asm("ld.w	%sp, %r4			");
	Asm("0:						");
	Asm("add	%r5, 1				");
	Asm("ld.w	[%r3], %r5			");
	Asm("ld.w	%r4, %psr			");
	Asm("or		%r4, 0x10			");
	Asm("ld.w	%psr, %r4			");
	Asm("ld.w	%r6, %r2			");

#ifdef	__c33adv						/* pushs߂ɂX^bNgp	*/
	Asm("add	%r6, 24");				/* TCYZ		*/
#endif	/* __c33adv */
	
#if TPS_DAREA_CNT == 4
	Asm("add	%r6, 48");
#elif TPS_DAREA_CNT == 3
	Asm("add	%r6, 52");
#elif TPS_DAREA_CNT == 2
	Asm("add	%r6, 56");
#elif TPS_DAREA_CNT == 1
	Asm("add	%r6, 60");
#else
	Asm("ext	0x0001");
	Asm("add	%r6, 0x00");
#endif /* TPS_DAREA */
}

Inline void
tpsIntPostWrap(void)
{
	Asm("ld.w	%r4, %psr		");	/* 荞݂fBZ[u	*/
	Asm("xand	%r4, 0xfffff0ff		");
	Asm("xld.w	%%r5, %0"
		: : "g"(TPS_CPULOCK_LEV << 8));
	Asm("or		%r4, %r5		");
	Asm("ld.w	%psr, %r4		");

	Asm("ld.w	%r4, [%r3]		");	/* tps_IntNestCntXV	*/
	Asm("sub	%r4, 1			");
	Asm("ld.w	[%r3], %r4		");

	Asm("ld.w	%sp, %r2		");	/* X^bN̈𕜌	*/

	Asm("cmp	%r4, 0x00		");
	Asm("xjrne	0f			");
	Asm("xld.w	%r3, _kernel_reqflg	");
	Asm("ld.w	%r3, [%r3]		");
	Asm("cmp	%r3, 1			");	/* tps_IntNestCnt== 0ŃfBX	  */
	Asm("xjreq	_kernel_ret_int		");	/* pb`Ă΃Wv */
	Asm("0:					");	/* 				  */

#ifdef	__c33adv					/* ޔꃌWX^𕜌 */
	Asm("pops	%sor			");
#else	/* __c33adv */
	Asm("ld.w	%alr, %r1		");
	Asm("ld.w	%ahr, %r0		");
#endif	/* __c33adv */

#if TPS_DAREA_CNT == 4
	Asm("popn %r11");
#elif TPS_DAREA_CNT == 3
	Asm("popn %r12");
#elif TPS_DAREA_CNT == 2
	Asm("popn %r13");
#elif TPS_DAREA_CNT == 1
	Asm("popn %r14");
#else
	Asm("popn %r15");
#endif /* TPS_DAREA */

	Asm("reti");
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
