/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  䃌WX^̑֐
 */

/*
 *  Xe[^XWX^(PSR)̌ݒl̓Ǐo
 */
Inline UW
get_psr(void)
{
	UW psr;

	Asm("ld.w %0, %%psr": "=r"(psr));

	return psr;
}

/*
 *  Xe[^XWX^(PSR)̌ݒl̕ύX
 */
Inline void
set_psr(register UW psr)
{
	Asm("ld.w %%psr, %0": : "r"(psr));
}

/*
 *  X^bN|C^(SP)̌ݒl̓Ǐo
 */
Inline VP
get_sp(void)
{
	VP sp;

	Asm("ld.w %0, %%sp": "=r"(sp));

	return sp;
}

/*
 *  X^bN|C^(SP)̌ݒl̕ύX
 */
Inline void
set_sp(VP sp)
{
	Asm("ld.w %%sp, %0": : "r"(sp));
}

/*
 *  vOJE^(PC)̌ݒl̕ύX
 */
Inline void
set_pc(VP pc)
{
	Asm("jp %0": "=r"(pc) : "0"(pc));
}

/*
 *  gbvx[XWX^(TTBR)̌ݒl̓Ǐo
 */
Inline VP
get_ttbr(void)
{
#ifdef __c33std
	return (VP) ((volatile s1c33Bcu_t *) S1C33_BCU_BASE)->ulTtbr;
#else
	VP ttbr;

	Asm("ld.w %0, %%ttbr": "=r"(ttbr));

	return ttbr;
#endif /* __c33std */
}

/*
 *  fBL[T[`̂߂̃rbg}bvT[`֐
 *  rbg}bv̉16rbggpCŉʃrbgŒDxɑΉ
 */
#ifdef CPU_BITMAP_SEARCH
Inline UINT
bitmap_search(UINT bitmap)
{
	INT offset;
	INT bit;

	Asm("swap %0, %1": "=r"(bitmap): "r"(bitmap));
	Asm("mirror %0, %1": "=r"(bitmap): "r"(bitmap));
	Asm("scan1 %0, %1": "=r"(bit): "r"(bitmap));
	if(bit != 8){
		return bit;
	}

	Asm("sll %0, %1": "=r"(bitmap): "r"(bit));
	offset = bit;
	Asm("scan1 %0, %1": "=r"(bit): "r"(bitmap));

	return offset + bit;
}
#endif	/* CPU_BITMAP_SEARCH */

#endif /* _CPU_INSN_H_ */
