/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 *@@VAI/OfoCXiSIOjhCoiKZ-SH1pj
 *@@@@SH1VAR~jP[VC^tF[XSCIgp
 *
 *@@@@sh1sci.{c,h}hw_serial.h̊̕
 *@@@@@@Esh1sci.{c,h}FVAfoCXɈˑ镔̂݋Lq
 *@@@@@@Ehw_serial.hFVAfoCXȊOɋN鎖
 *@@@@ @@@@@@@@@hw_serial.hɋLq
 *@@@@@@@@@@@@@@݃Rg[ˑȂ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include <sh1sci.h>
#endif /* _MACRO_ONLY */

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SERIAL_IN	 	RXI0
#define INHNO_SERIAL_OUT 	TXI0
#define INHNO_SERIAL_ERROR  	ERI0

#define LEVEL0		0	/*  ݉̃x  */
#define SCI_SHIFT	0	/*  ݃xo^̃rbgVtg  */



#ifndef _MACRO_ONLY

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize	sh1sci_initialize

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  I[v|[g邩 openflag ɓǂłD
	 */
	openflag = sh1sci_openflag();

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = sh1sci_opn_por(siopid, exinf);

	/*
	 *  ݃Rg[ˑ
	 *  @VAI/O݂̊݃xݒ肷
	 */
	if (!openflag) {
		define_int_plevel(IPRD, SCI_INTLVL, SCI_SHIFT);
	}
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[YD
	 */
	sh1sci_cls_por(siopcb);

	/*
	 *  VAI/O݃xŒ჌xɂ
	 */
	define_int_plevel(IPRD, LEVEL0, SCI_SHIFT);

	if (!sh1sci_openflag()) {
		/*  ׂẴ|[gN[YĂ  */
		/*  VAfoCXւ̃NbN~  */
	}
}

/*
 *  SIO̊݃nh
 */
#define	sio_handler_in	sh1sci_isr_in		/*  M݃nh  */
#define	sio_handler_out	sh1sci_isr_out		/*  M݃nh  */
					/*  MG[݃nh  */
#define	sio_handler_error sh1sci_isr_error

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr	sh1sci_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr	sh1sci_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr	sh1sci_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr	sh1sci_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 *  @@jsp/systask/serial.cɂ̂l[Ă
 *  @@ȋOQƁj
 */
#define	sio_ierdy_snd	sh1sci_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 *  @@jsp/systask/serial.cɂ̂l[Ă
 *  @@ȋOQƁj
 */
#define	sio_ierdy_rcv	sh1sci_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
