/*
 *  TOPPERS/JSP Rose-RT Link Programs
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
/*
 *  ()쏊ITRONSH1CPU{[hp
 *  LED,SW ֐
 */
#include <s_services.h>
#include <sh1_sil.h>
#include "zunda_sh1.h"
#include "device.h"

/*
 *  LED̏
 */
void
initial_led(void)
{
	set_led( LED1, OFF );
	set_led( LED2, OFF );
	set_led( LED3, OFF );
}

/*
 *  LED̐ݒs
 *  arg1: LED1 - 3
 *  arg2: ON|OFF
 */
void
set_led( int led, int req )
{
	if ( req != ON && req != OFF ) {
		return;
	}
	
	switch ( led ) {
	case LED1:
		if( req == OFF ) {
			sh1_orh_reg( PA_DR, LED_CTL1 );
		} else {
			sh1_anh_reg( PA_DR, ~LED_CTL1 );
		}
		break;
	case LED2:
		if( req == OFF ) {
			sh1_orh_reg( PB_DR, LED_CTL2 );
		} else {
			sh1_anh_reg( PB_DR, ~LED_CTL2 );
		}
		break;
	case LED3:
		if( req == OFF ) {
			sh1_orh_reg( PB_DR, LED_CTL3 );
		} else {
			sh1_anh_reg( PB_DR, ~LED_CTL3 );
		}
		break;
	default:
		break;
	}
}

/*
 *  LED̏Ԏ擾
 *  arg1: LED1 - 3
 */
int
get_led( int led )
{
	switch ( led ) {
	case LED1:
		if ( (sil_reh_mem( PA_DR ) & LED_CTL1) == 0 ) {
			return ON;
		}
		break;
	case LED2:
		if ( (sil_reh_mem( PB_DR ) & LED_CTL2) == 0 ) {
			return ON;
		}
		break;
	case LED3:
		if ( (sil_reh_mem( PB_DR ) & LED_CTL3) == 0 ) {
			return ON;
		}
		break;
	default:
		break;
	}
	return OFF;
}

/*
 *  fBbvXCb`̏Ԏ擾
 *  return:ON OFF
 *  arg1:DSW11 ` DSW14
 */
int
get_dsw( int sw )
{
	UH	key = 0;
	int	result = OFF;

	key = sil_reh_mem( SW_DR );
	switch ( sw ) {
	case DSW11:
		if ((key & DSW11) == 0 ) {
			result = ON;
		}
		break;
	case DSW12:
		if ((key & DSW12) == 0 ) {
			result = ON;
		}
		break;
	case DSW13:
		if ((key & DSW13) == 0 ) {
			result = ON;
		}
		break;
	case DSW14:
		if ((key & DSW14) == 0 ) {
			result = ON;
		}
		break;
	default:
		break;
	}
	return result;
}

/*
 *  [^[XCb`̒l擾
 *  return:XCb`̒l
 */
int
get_rsw(void)
{
	return (sil_reh_mem( SW_DR ) & RSW_CTL);
}

