/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD.
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *   SH1VAR~jP[VC^tF[XSCIp ȈՃhCo
 *   ()쏊ITRONSH1CPU{[hp
 *@@@@
 *   SCI0(RS232C)/SCI1(RS485)T|[g
 *
 *@@@@sh1sci.{c,h}hw_serial.h̊̕
 *@@@@@@Esh1sci.{c,h}FVAfoCXɈˑ镔̂݋Lq
 *@@@@@@Ehw_serial.hF݃Rg[ˑ
 *@@@@@@
 *@@@@@@ENbNgˑɂ
 *@@@@@@@@EfoCXˑ̃p[^sh1sci.cŗpӂB
 *@@@@@@@@E匳̃NbNg̓RpCIvVƂė^
 */

#include <s_services.h>
#include <sh1sci2.h>

/*
 *  Rg[WX^̃AhX iׂ1oCgTCYj
 */
	/*  `l0  */
#define SCI_SMR0 (VB *)0x5fffec0	/*  VA[hWX^ */
#define SCI_BRR0 (VB *)0x5fffec1	/*  rbg[gWX^  */
#define SCI_SCR0 (VB *)0x5fffec2	/*  VARg[WX^ */
#define SCI_TDR0 (VB *)0x5fffec3	/*  gX~bgf[^WX^ */
#define SCI_SSR0 (VB *)0x5fffec4	/*  VAXe[^XWX^ */
#define SCI_RDR0 (VB *)0x5fffec5	/*  V[uf[^WX^ */

	/*  `l1  */
#define SCI_SMR1 (VB *)0x5fffec8	/*  VA[hWX^ */
#define SCI_BRR1 (VB *)0x5fffec9	/*  rbg[gWX^  */
#define SCI_SCR1 (VB *)0x5fffeca	/*  VARg[WX^ */
#define SCI_TDR1 (VB *)0x5fffecb	/*  gX~bgf[^WX^ */
#define SCI_SSR1 (VB *)0x5fffecc	/*  VAXe[^XWX^ */
#define SCI_RDR1 (VB *)0x5fffecd	/*  V[uf[^WX^ */

/*
 *  Rg[WX^̐ݒl
 */
/*  VAXe[^XWX^SSR̊erbg  */
#define SSR_TDRE	0x80u	/* gX~bgf[^WX^GveB */
#define SSR_RDRF	0x40u	/* V[uf[^WX^t 		*/
#define SSR_ORER	0x20u	/* I[o[G[ 			*/
#define SSR_FER		0x10u	/* t[~OG[ 			*/
#define SSR_PER		0x08u	/* peBG[ 			*/
#define SSR_TEND	0x04u	/* gX~bgGh 		*/
#define SSR_MPB		0x02u	/* }`vZbTrbg 		*/
#define SSR_MPBT	0x01u	/* }`vZbTrbggXt@ 	*/

/*  VARg[WX^SCR̊erbg  */
#define SCR_TIE		0x80u	/* gX~bgC^vgCl[u */
#define SCR_RIE		0x40u	/* V[uC^vgCl[u 	*/
#define SCR_TE		0x20u	/* gX~bgCl[u 		*/
#define SCR_RE		0x10u	/* V[uCl[u 			*/
#define SCR_MPIE	0x08u	/* }`vZbTC^vgCl[u */
				/* gX~bgGhC^vg	*/
#define SCR_TEIE	0x04u	/* Cl[u 				*/
#define SCR_CKE_MASK	0x03u	/* NbN\[XIp}XN		*/
#define SCR_CKE		0x00u	/* NbNCl[u			*/
				/*   ̂Ƃ  			*/
				/*   	NbNgp  		*/
				/*   	o͂Ȃ  			*/

/*  VA[hWX^SMR̊erbg  */
				/* R~jP[V[h 	*/
#define SMR_CA_CLOCK	0x80u	/* 	NbN 		*/
#define SMR_CA_ASYNC	0x00u	/* 	 		*/
	/*  ʐMFAsynchronous Communication method */
				/* LN^OX 		*/
#define SMR_CHR8	0x00u	/* 	8rbg 		*/
#define SMR_CHR7	0x40u	/* 	7rbg 		*/
				/* peBCl[u 		*/
#define SMR_PE		0x20u	/* 	peB 		*/
#define SMR_PE_NON	0x00u	/* 	peBȂ 		*/
#define SMR_OE_ODD	0x10u	/* peB[hipeBj*/
#define SMR_STOP2	0x08u	/* XgbvrbgOXF2 	*/
#define SMR_STOP1	0x00u	/* XgbvrbgOXF1 	*/
#define SMR_MP		0x04u	/* }`vZbT[h 	*/

/*
 *  VARg[WX^̃x[X̃ItZbg
 */
#define SMR (VB *)0x0	/*  VA[hWX^ */
#define BRR (VB *)0x1	/*  rbg[gWX^  */
#define SCR (VB *)0x2	/*  VARg[WX^ */
#define TDR (VB *)0x3	/*  gX~bgf[^WX^ */
#define SSR (VB *)0x4	/*  VAXe[^XWX^ */
#define RDR (VB *)0x5	/*  V[uf[^WX^ */

/*
 *  NbNgˑ
 *  NbNg19.6608MHz
 */
/*
 *  `l0:ƃrbg[g̐ݒ
 */
#if CONFIG_BAUD == 9600
/*
 *  NbN	@19.6608MHz
 *  rbg[g@9600bps
 *
 *  @n=0(Ȃ̂ł̂܂)
 *  @N=63Ō덷0%
 *  āA
 *  @VA[hWX^SMR̃NbNZNgrbgCKS=00
 *  @rbg[gWX^BRR=63
 */
#define SMR_CKS_0 	0x0u	/*    		*/
#define SCI_BRR_0 	63u	/*  rbg[g  	*/
/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=9600bps̏ꍇ
 *  @t = 1 / BPS = 104,167 = 105,000[nsec]
 */
#define SH1SCI_DELAY0 	105000

#elif CONFIG_BAUD == 19200
/*
 *  NbN	@19.6608MHz
 *  rbg[g@19200bps
 *
 *  @n=0(Ȃ̂ł̂܂)
 *  @N=31Ō덷0%
 *  āA
 *  @VA[hWX^SMR̃NbNZNgrbgCKS=00
 *  @rbg[gWX^BRR=31
 */
#define SMR_CKS_0 	0x0u	/*    		*/
#define SCI_BRR_0 	31u	/*  rbg[g  	*/
/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=19200bps̏ꍇ
 *  @t = 1 / BPS = 52,083 = 53,000[nsec]
 */
#define SH1SCI_DELAY0 	53000

#elif CONFIG_BAUD == 38400
/*
 *  NbN	@19.6608MHz
 *  rbg[g@38400bps
 *
 *  @n=0(Ȃ̂ł̂܂)
 *  @N=15Ō덷0%
 *  āA
 *  @VA[hWX^SMR̃NbNZNgrbgCKS=00
 *  @rbg[gWX^BRR=15
 */
#define SMR_CKS_0 	0x0u	/*    		*/
#define SCI_BRR_0 	15u	/*  rbg[g  	*/
/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=38400bps̏ꍇ
 *  @t = 1 / BPS = 26,042 = 27,000[nsec]
 */
#define SH1SCI_DELAY0 	27000

#else	/*  CONFIG_BAUD  */
#error chanel0 is unsupported baud rate.

#endif 	/*  CONFIG_BAUD  */


/*
 *  `l1:ƃrbg[g̐ݒ
 */
#if CONFIG_BAUD_2 == 9600
/*
 *  NbN	@19.6608MHz
 *  rbg[g@9600bps
 *
 *  @n=0(Ȃ̂ł̂܂)
 *  @N=63Ō덷0%
 *  āA
 *  @VA[hWX^SMR̃NbNZNgrbgCKS=00
 *  @rbg[gWX^BRR=63
 */
#define SMR_CKS_1 	0x0u	/*    		*/
#define SCI_BRR_1 	63u	/*  rbg[g  	*/
/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=9600bps̏ꍇ
 *  @t = 1 / BPS = 104,167 = 105,000[nsec]
 */
#define SH1SCI_DELAY1 	105000

#elif CONFIG_BAUD_2 == 19200
/*
 *  NbN	@19.6608MHz
 *  rbg[g@19200bps
 *
 *  @n=0(Ȃ̂ł̂܂)
 *  @N=31Ō덷0%
 *  āA
 *  @VA[hWX^SMR̃NbNZNgrbgCKS=00
 *  @rbg[gWX^BRR=31
 */
#define SMR_CKS_1 	0x0u	/*    		*/
#define SCI_BRR_1 	31u	/*  rbg[g  	*/
/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=19200bps̏ꍇ
 *  @t = 1 / BPS = 52,083 = 53,000[nsec]
 */
#define SH1SCI_DELAY1 	53000

#elif CONFIG_BAUD_2 == 38400
/*
 *  NbN	@19.6608MHz
 *  rbg[g@38400bps
 *
 *  @n=0(Ȃ̂ł̂܂)
 *  @N=15Ō덷0%
 *  āA
 *  @VA[hWX^SMR̃NbNZNgrbgCKS=00
 *  @rbg[gWX^BRR=15
 */
#define SMR_CKS_1 	0x0u	/*    		*/
#define SCI_BRR_1 	15u	/*  rbg[g  	*/
/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=38400bps̏ꍇ
 *  @t = 1 / BPS = 26,042 = 27,000[nsec]
 */
#define SH1SCI_DELAY1 	27000

#else	/*  CONFIG_BAUD  */
#error chanel1 is unsupported baud rate.

#endif 	/*  CONFIG_BAUD  */

/*
 *  VA|[g̏ubN
 */
static const SIOPINIB siopinib_table[TNUM_PORT] = 
{

#if TNUM_PORT == 1

	{
		(UW)SCI_SMR0,
		SCI_BRR_0,
		IPRD,
		0,
		(SMR_CA_ASYNC | SMR_CHR8 | SMR_PE_NON | SMR_STOP1 | SMR_CKS_0),
		SH1SCI_DELAY0,
		RS232C_INTERFACE,
	},

#elif TNUM_PORT == 2	/* of #if TNUM_PORT == 1 */

	{
		(UW)SCI_SMR0,
		SCI_BRR_0,
		IPRD,
		0,
		(SMR_CA_ASYNC | SMR_CHR8 | SMR_PE_NON | SMR_STOP1 | SMR_CKS_0),
		SH1SCI_DELAY0,
		RS232C_INTERFACE,
	},
	{
		(UW)SCI_SMR1,
		SCI_BRR_1,
		IPRE,
		12,
		(SMR_CA_ASYNC | SMR_CHR8 | SMR_PE_NON | SMR_STOP1 | SMR_CKS_1),
		SH1SCI_DELAY1,
		RS485_INTERFACE,
	},

#endif	/* of #if TNUM_PORT == 1 */

};

/*
 *  VAI/O|[gǗubÑGA
 *  @@ID = 1 SCI0ɑΉĂD
 */
static SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  Mł邩H
 */
Inline BOOL
sh1sci_getready(SIOPCB *siopcb)
{
	VB ssr = sil_reb_mem(siopcb->inib->base + SSR);
	return(ssr & SSR_RDRF);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
sh1sci_putready(SIOPCB *siopcb)
{
	VB ssr = sil_reb_mem(siopcb->inib->base + SSR);
	return(ssr & SSR_TDRE);
}

/*
 *  M̎o
 */
Inline char
sh1sci_getchar(SIOPCB *siopcb)
{
	char data;

	data = sil_reb_mem(siopcb->inib->base + RDR);
	
	/*  V[uf[^WX^tEtÕNA  */
	sh1_anb_reg(siopcb->inib->base + SSR, (VB)~SSR_RDRF);
	return data;
}

/*
 *  M镶̏
 */
Inline void
sh1sci_putchar(SIOPCB *siopcb, char c)
{
	if (siopcb->inib->rs485if) {
		if (!(sil_reh_mem(PB_DR) & PB_TXE1)) {
			sh1_orh_reg(PB_DR, PB_TXE1);	/* TXENA ON 		*/
			sil_dly_nse(5000);		/* 5us ی쎞		*/
		}
		sil_wrb_mem(siopcb->inib->base + TDR ,c);
		/*  gX~bgf[^WX^GveBEtÕNA*/
		sh1_anb_reg(siopcb->inib->base + SSR, (VB)~SSR_TDRE);
		/*  TXENA OFF̂߁ÃR[obN̋ */
		sh1sci_ena_cbr(siopcb, SIO_ERDY_SND);
	} else {
#ifdef GDB_STUB
		gdb_stub_putc( c );
#else
		sil_wrb_mem(siopcb->inib->base + TDR ,c);

		/*  gX~bgf[^WX^GveBEtÕNA*/
		sh1_anb_reg(siopcb->inib->base + SSR, (VB)~SSR_TDRE);
#endif
	}
}

/*
 *  SIOhCȍ[`
 */
void
sh1sci_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->inib     = &siopinib_table[i];
		siopcb->openflag = FALSE;
	}
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
sh1sci_openflag(ID siopid)
{
	SIOPCB *siopcb;

	siopcb = get_siopcb(siopid);
	return (siopcb->openflag);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sh1sci_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb = get_siopcb(siopid);
	VB scr, smr;
	VH pbcr1;

#ifdef GDB_STUB
	if (siopid == PORT1) {
		siopcb->exinf = exinf;
		siopcb->openflag = TRUE;
		return(siopcb);
	}
#endif	/*  GDB_STUB  */

	sh1_anb_reg(siopcb->inib->base + SCR, (VB)~(SCR_TE | SCR_RE));	/*  M~  */

	/*  sATC
	 *     VAfoCX̂̎ł͂Ȃ̂
	 *     {͂̃t@CɋLq̂͂ӂ킵ȂA
	 *     hw_serial.cpӂ̂ώGȂ̂ŎbIɂɓĂB
	 */
	pbcr1 = sil_reh_mem((VP)PBCR1);
	if (siopid == PORT1) {	/* PB08:RxD0 PB09:TxD0  */
		pbcr1 = (pbcr1 & PBCR1_TD0_RD0_MASK) | PBCR1_TD0 | PBCR1_RD0;
	} else {		/* PB10:RxD1 PB11:TxD1  */
		pbcr1 = (pbcr1 & PBCR1_TD1_RD1_MASK) | PBCR1_TD1 | PBCR1_RD1;
	}
	sil_wrh_mem((VP)PBCR1, pbcr1);
	
						/*  MtH[}bg  */
	smr = siopcb->inib->smr_init;

	sil_wrb_mem(siopcb->inib->base + SMR, smr);
	
	sil_wrb_mem(siopcb->inib->base + BRR, (UB)siopcb->inib->baudrate);	/*  {[[gݒ  	*/

					/*  ݋֎~ƃNbN\[X̑I */
	scr = (VB)(~(SCR_TIE | SCR_RIE | SCR_TE | SCR_RE |
			  SCR_MPIE | SCR_TEIE | SCR_CKE_MASK) | SCR_CKE);
	sil_wrb_mem(siopcb->inib->base + SCR, scr);
	
	/*
	 * {[[g̐ݒA1JEg҂Ȃ΂ȂȂB
	 */
	sil_dly_nse(siopcb->inib->delay);

					/* G[tONA	*/
	sh1_anb_reg(siopcb->inib->base + SSR, (VB)~(SSR_ORER | SSR_FER | SSR_PER));
					/* M荞݋   	*/
					/* M  		*/
	sh1_orb_reg(siopcb->inib->base + SCR, (SCR_RIE | SCR_TE | SCR_RE));
			/*  M݂̋͑M֐ōs  */

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sh1sci_cls_por(SIOPCB *siopcb)
{
				/*  M~A݋֎~ 	*/
	sh1_anb_reg(siopcb->inib->base + SCR, (VB)~(SCR_TIE | SCR_RIE | SCR_TE | SCR_RE));
	
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
sh1sci_snd_chr(SIOPCB *siopcb, char c)
{
	if (sh1sci_putready(siopcb)) {
		sh1sci_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
sh1sci_rcv_chr(SIOPCB *siopcb)
{
	if (sh1sci_getready(siopcb)) {
		return((INT)(UB) sh1sci_getchar(siopcb));
		/*  (UB)ŃLXĝ̓[gɂ邽  */
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sh1sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* M荞ݗv */
		sh1_orb_reg(siopcb->inib->base + SCR, SCR_TIE);
		break;
	case SIO_ERDY_RCV:	/* M荞ݗv */
		sh1_orb_reg(siopcb->inib->base + SCR, SCR_RIE);
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sh1sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* M荞ݗv֎~ */
		sh1_anb_reg(siopcb->inib->base + SCR, (VB)~SCR_TIE);
		if (siopcb->inib->rs485if) {
				/* MI荞݋ */
			sh1_orb_reg(siopcb->inib->base + SCR, SSR_TEND);
		}
		break;
	case SIO_ERDY_RCV:	/* M荞ݗv֎~ */
		sh1_anb_reg(siopcb->inib->base + SCR, (VB)~SCR_RIE);
		break;
	}
}

/*
 *  VAI/O|[gɑ΂鑗Mݏ
 */
Inline void
sh1sci_isr_siop_out(SIOPCB *siopcb)
{
	VB scr = sil_reb_mem(siopcb->inib->base + SCR);
	
	if ((scr & SCR_TIE) != 0 && sh1sci_putready(siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sh1sci_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  VAI/O|[gɑ΂鑗MIݏ
 */
Inline void
sh1sci_isr_siop_tend(SIOPCB *siopcb)
{
	/*
 	 * RS485 M֎~
 	 */
	sh1_anb_reg(siopcb->inib->base + SCR, (VB)~SSR_TEND);
	sh1_anh_reg(PB_DR, ~PB_TXE1);	/* txena|[g֎~ */
}

/*
 *  VAI/O|[gɑ΂Mݏ
 */
Inline void
sh1sci_isr_siop_in(SIOPCB *siopcb)
{
	VB scr = sil_reb_mem(siopcb->inib->base + SCR);

	if ((scr & SCR_RIE) != 0 && sh1sci_getready(siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sh1sci_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  SIOM݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI0̑M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh1sci_isr_out(void)
{
	if (siopcb_table[0].openflag) {
		sh1sci_isr_siop_out(&(siopcb_table[0]));
	}
}

/*
 *  SIOM݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI0̎M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh1sci_isr_in(void)
{
	if (siopcb_table[0].openflag) {
		sh1sci_isr_siop_in(&(siopcb_table[0]));
	}
}

/*
 *  SIOMG[݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍ`lʂɕĂ̂ŁA
 *  @SCI0̎MG[݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  @
 *  @G[̂̓G[tÕNÂ݂ɂƂǂ߂ĂB
 *  @@@EI[o[G[
 *  @@@Et[~OG[
 *  @@@EpeBG[
 */
void
sh1sci_isr_error(void)
{
	VB ssr0;
	
	if (siopcb_table[0].openflag) {
		ssr0 = sil_reb_mem(SCI_SSR0);	/*  1xǂݏo  */
		ssr0 &= ~(SSR_RDRF | SSR_ORER | SSR_FER | SSR_PER);
		sil_wrb_mem(SCI_SSR0, ssr0);	/*  G[tONA  */
	}
}

/*
 * |[Oɂ镶̑M
 */
void
sh1sci_putc_pol(char c)
{
	while(!sh1sci_putready(&siopcb_table[0]));
	sh1sci_putchar(&siopcb_table[0], c);
}

/* VAQ	*/
#if TNUM_SIOP >= 2
/*
 *  SIOM݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI1̑M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh1sci2_isr_out(void)
{
	if (siopcb_table[1].openflag) {
		sh1sci_isr_siop_out(&(siopcb_table[1]));
	}
}

/*
 *  SIOMI݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI1̑M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh1sci2_isr_tend(void)
{
	if (siopcb_table[1].openflag) {
		sh1sci_isr_siop_tend(&(siopcb_table[1]));
	}
}

/*
 *  SIOM݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI0̎M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh1sci2_isr_in(void)
{
	if (siopcb_table[1].openflag) {
		sh1sci_isr_siop_in(&(siopcb_table[1]));
	}
}

/*
 *  SIOMG[݃T[rX[`
 *  
 *  @SH1SCIł͊ݔԍ`lʂɕĂ̂ŁA
 *  @SCI0̎MG[݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  @
 *  @G[̂̓G[tÕNÂ݂ɂƂǂ߂ĂB
 *  @@@EI[o[G[
 *  @@@Et[~OG[
 *  @@@EpeBG[
 */
void
sh1sci2_isr_error(void)
{
	VB ssr1;
	
	if (siopcb_table[1].openflag) {
		ssr1 = sil_reb_mem(SCI_SSR1);	/*  1xǂݏo  */
		ssr1 &= ~(SSR_RDRF | SSR_ORER | SSR_FER | SSR_PER);
		sil_wrb_mem(SCI_SSR1, ssr1);	/*  G[tONA  */
	}
}

/*
 * |[Oɂ镶̑M
 */
void
sh1sci2_putc_pol(char c)
{
	while(!sh1sci_putready(&siopcb_table[1]));
	sh1sci_putchar(&siopcb_table[1], c);
}

#endif /* TNUM_SIOP = 2 */
