/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *   SH1VAR~jP[VC^tF[XSCIp ȈՃhCo
 *
 *@@@@SCI0/1T|[g
 *
 *@@@@sh1sci.{c,h}hw_serial.h̊̕
 *@@@@@@Esh1sci.{c,h}FVAfoCXɈˑ镔̂݋Lq
 *@@@@@@Ehw_serial.hFVAfoCXȊOɋN鎖
 *@@@@ @@@@@@@@@hw_serial.hɋLq
 *@@@@@@@@@@@@@@݃Rg[ˑȂ
 */

#ifndef _SH1SCI2_H_
#define _SH1SCI2_H_

#include <t_services.h>
#include <sh1_sil.h>

/*
 *  VA|[gC^[tF[X
 */
#define	PORT1			1
#define	PORT2			2

#define RS232C_INTERFACE	0	/* RS232C I/F̏ꍇAM */
#define RS485_INTERFACE		1	/* RS485 I/F̏ꍇAM */

/*
 *  VA|[g̏ubN
 */
typedef struct sio_port_initialization_block {
	UW 	base;		/* SCI ̃x[XAhX		*/
	UW	baudrate;	/* {[Cg			*/	
	VH  	*ipr;		/* 荞݃Rg[AhX */
	UH	shift;		/* 荞݃Rg[Vtg	*/
	UB	smr_init;	/* SMR ̐ݒl			*/
	UINT	delay;		/* {[[g̐ݒ҂	*/
	UB	rs485if;	/* RS232C | RS485		*/
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 *  @2chɊg
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*inib;		/* lp̃f[^ 	*/
	VP_INT		exinf;		/* g 		*/
	BOOL		openflag;	/* I[vς݃tO 	*/
} SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND	1u		/* M\R[obN */
#define SIO_ERDY_RCV	2u		/* MʒmR[obN */

/*
 *  SIOhCȍ[`
 */
extern void	sh1sci_initialize(void);

/*
 *  I[vĂ|[g邩H
 */
extern BOOL	sh1sci_openflag(ID siopid);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*sh1sci_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void	sh1sci_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL	sh1sci_snd_chr(SIOPCB *siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern INT	sh1sci_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void	sh1sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void	sh1sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void	sh1sci_isr_in(void);
extern void	sh1sci_isr_out(void);

/*
 *  SIO̎MG[݃T[rX[`
 */
extern void	sh1sci_isr_error(void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void	sh1sci_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void	sh1sci_ierdy_rcv(VP_INT exinf);



#endif /* _SH1SCI2_H_ */
