/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
#ifndef _SYS_SUPPORT_H_
#define _SYS_SUPPORT_H_

/*
 *  |[g`Egh^n֊J[q̒`
 *  ׂăvAbv
 */
/*
 *  PA15 I@\ 1 ɃZbgĂ
 */
#define	PA15_PORT_IN	1	/* ėp̓|[g		PI15	*/
#define	PA15_PORT_OUT	0	/* ėpo̓|[g		PO15	*/
#define	PA15_IRQ3	0	/* 荞ݗv		IRQ3	*/
#define	PA15_DREQ1	0	/* cl`]v		DREQ1	*/

/*
 *  PA14 I@\ 1 ɃZbgĂ
 */
#define	PA14_PORT_IN	1	/* ėp̓|[g		PI14	*/
#define	PA14_PORT_OUT	0	/* ėpo̓|[g		PO14	*/
#define	PA14_IRQ2	0	/* 荞ݗv 		IRQ2	*/
#define	PA14_DACK1	0	/* cl`]vto	DACK1	*/

/*
 *  PA13 I@\ 1 ɃZbgĂ
 */
#define	PA13_PORT_IN	1	/* ėp̓|[g		PI13	*/
#define	PA13_PORT_OUT	0	/* ėpo̓|[g		PO13	*/
#define	PA13_IRQ1	0	/* 荞ݗv 		IRQ1	*/
#define	PA13_TCLKB	0	/* hst^C}NbN	TCLKB	*/
#define	PA13_DREQ0	0	/* cl`]v		DREQ0	*/

/*
 *  PA12 I@\ 1 ɃZbgĂ
 */
#define	PA12_PORT_IN	1	/* ėp̓|[g		PI12	*/
#define	PA12_PORT_OUT	0	/* ėpo̓|[g		PO12	*/
#define	PA12_IRQ0	0	/* 荞ݗv 		IRQ0	*/
#define	PA13_TCLKA	0	/* hst^C}NbN	TCLKA	*/
#define	PA13_DACK0	0	/* cl`]vto	DACK0	*/

/*
 *  PA03 I@\ 1 ɃZbgĂ
 */
#define	PA03_PORT_IN	1	/* ėp̓|[g		PI03	*/
#define	PA03_PORT_OUT	0	/* ėpo̓|[g		PO03	*/
#define	PA03_CS7	0	/* `bvZNgVo		CS7	*/
#define	PA03_WAIT	0	/* EGCgXe[g		WAIT	*/

/*
 *  PA01 I@\ 1 ɃZbgĂ
 */
#define	PA01_PORT_IN	1	/* ėp̓|[g		PI01	*/
#define	PA01_PORT_OUT	0	/* ėpo̓|[g		PO01	*/
#define	PA01_CS5	0	/* `bvZNgTo		CS5	*/
#define	PA01_RAS	0	/* EAhXXg[uo	RAS	*/

/*####################################################
 *
 *  ȉҏWȂ
 *
 *####################################################*/
/*
 *  o`Aoao̓obt@l
 *  ̃st@NV`QƂĂ
 */
#define	VAL_PA_DR 	(1<<10 | 1<<9 | 1<<8)	/* RTC-4553-CS=1,RTC-4553-WR=1,LEDCTL1=1(off) */
#define	VAL_PB_DR 	(1<<11 | 1<<9 | 1<<6)	/* TXD1=1,TXD0=1,LEDCTL2=1(off) */

/*
 *  PA Œ@\iPA15,14,13,12,03,01j
 *
 *  PNO  I/O PAIOR  PACR1/2
 *  PA15 IN   [0]    [00] | gh^nɊJ
 *  PA14 IN   [0]    [00] | gh^nɊJ
 *  PA13 IN   [0]    [00] | gh^nɊJ
 *  PA12 IN   [0]    [00] | gh^nɊJ
 *  PA11 IN   [0]    [00] | RTC-4553-SOUT
 *  PA10 OUT  [1]    [00] | RTC-4553-CS[active-low]
 *  PA09 OUT  [1]    [00] | RTC-4553-WR[active-low]
 *  PA08 OUT  [1]    [10] | LEDCTL1 LED1[active-low]
 *  PA07 IN   [0]    [10] | gp
 *  PA06 |   [0]    [11] | RD Ɋ蓖ā|
 *  PA05 OUT  [1]    [10] | WD-PULSE EHb`hbNZbgpXQɂ
 *  PA04 |   [0]    [11] | WR Ɋ蓖
 *  PA03 |   [0]    [00] | gh^nɊJ
 *  PA02 |   [0]    [01] | CS6 Ɋ蓖āik`mRg[pj
 *  PA01 |   [0]    [00] | gh^nɊJ
 *  PA00 |   [0]    [01] | CS4 Ɋ蓖āiROMICE pj
 */
#define	PAIOR_BASE	0x0720
#define	PACR1_BASE	0x0002
#define	PACR2_BASE	0xbb11

#if PA15_PORT_IN == 1
#define	PA15MD			0	/* ėp̓|[g		PI15	*/
#define	PA15IOR			0
#endif
#if PA15_PORT_OUT == 1
#ifdef PA15MD
#error : 'PA15MD' redefined.
#endif
#define	PA15MD			0	/* ėpo̓|[g		PO15	*/
#define	PA15IOR			1
#endif
#if PA15_IRQ3 == 1
#ifdef PA15MD
#error : 'PA15MD' redefined.
#endif
#define	PA15MD			1	/* 荞ݗv		IRQ3	*/
#define	PA15IOR			0
#endif
#if PA15_DREQ1 == 1
#ifdef PA15MD
#error : 'PA15MD' redefined.
#endif
#define	PA15MD			3	/* cl`]v		DREQ1	*/
#define	PA15IOR			0
#endif
#ifndef	PA15MD
#error : 'PA15MD' is not set up.
#endif

#if PA14_PORT_IN == 1
#define	PA14MD			0	/* ėp̓|[g		PI14	*/
#define	PA14IOR			0
#endif
#if PA14_PORT_OUT == 1
#ifdef PA14MD
#error : 'PA14MD' redefined.
#endif
#define	PA14MD			0	/* ėpo̓|[g		PO14	*/
#define	PA14IOR			1
#endif
#if PA14_IRQ2 == 1
#ifdef PA14MD
#error : 'PA14MD' redefined.
#endif
#define	PA14MD			1	/* 荞ݗv		IRQ2	*/
#define	PA14IOR			0
#endif
#if PA14_DACK1 == 1
#ifdef PA14MD
#error : 'PA14MD' redefined.
#endif
#define	PA14MD			3	/* cl`]vto	DACK1	*/
#define	PA14IOR			0
#endif
#ifndef PA14MD
#error : 'PA14MD' is not set up.
#endif

#if PA13_PORT_IN == 1
#define	PA13MD			0	/* ėp̓|[g		PI13	*/
#define	PA13IOR			0
#endif
#if PA13_PORT_OUT == 1
#ifdef PA13MD
#error : 'PA13MD' redefined.
#endif
#define	PA13MD			0	/* ėpo̓|[g		PO13	*/
#define	PA13IOR			1
#endif
#if PA13_IRQ1 == 1
#ifdef PA13MD
#error : 'PA13MD' redefined.
#endif
#define	PA13MD			1	/* 荞ݗv		IRQ1	*/
#define	PA13IOR			0
#endif
#if PA13_TCLKB == 1
#ifdef PA13MD
#error : 'PA13MD' redefined.
#endif
#define	PA13MD			2	/* hst^C}NbN	TCLKB	*/
#define	PA13IOR			0
#endif
#if PA13_DREQ0 == 1
#ifdef PA13MD
#error : 'PA13MD' redefined.
#endif
#define	PA13MD			3	/* cl`]v		DREQ0	*/
#define	PA13IOR			0
#endif
#ifndef PA13MD
#error : 'PA13MD' is not set up.
#endif

#if PA12_PORT_IN == 1
#define	PA12MD			0	/* ėp̓|[g		PI12	*/
#define	PA12IOR			0
#endif
#if PA12_PORT_OUT == 1
#ifdef PA12MD
#error : 'PA12MD' redefined.
#endif
#define	PA12MD			0	/* ėpo̓|[g		PO12	*/
#define	PA12IOR			1
#endif
#if PA12_IRQ0 == 1
#ifdef PA12MD
#error : 'PA12MD' redefined.
#endif
#define	PA12MD			1	/* 荞ݗv		IRQ0	*/
#define	PA12IOR			0
#endif
#if PA13_TCLKA == 1
#ifdef PA12MD
#error : 'PA12MD' redefined.
#endif
#define	PA12MD			2	/* hst^C}NbN	TCLKA	*/
#define	PA12IOR			0
#endif
#if PA13_DACK0 == 1
#ifdef PA12MD
#error : 'PA12MD' redefined.
#endif
#define	PA12MD			3	/* cl`]vto	DACK0	*/
#define	PA12IOR			0
#endif
#ifndef PA12MD
#error : 'PA12MD' is not set up.
#endif

#if PA03_PORT_IN == 1
#define	PA03MD			0	/* ėp̓|[g		PI03	*/
#define	PA03IOR			0
#endif
#if PA03_PORT_OUT == 1
#ifdef PA03MD
#error : 'PA03MD' redefined.
#endif
#define	PA03MD			0	/* ėpo̓|[g		PO03	*/
#define	PA03IOR			1
#endif
#if PA03_CS7 == 1
#ifdef PA03MD
#error : 'PA03MD' redefined.
#endif
#define	PA03MD			1	/* `bvZNgVo		CS7	*/
#define	PA03IOR			0
#endif
#if PA03_WAIT == 1
#ifdef PA03MD
#error : 'PA03MD' redefined.
#endif
#define	PA03MD			2	/* EGCgXe[g		WAIT	*/
#define	PA03IOR			0
#endif
#ifndef PA03MD
#error : 'PA03MD' is not set up.
#endif

#if PA01_PORT_IN == 1
#define	PA01MD			0	/* ėp̓|[g		PI01	*/
#define	PA01IOR			0
#endif
#if PA01_PORT_OUT == 1
#ifdef PA01MD
#error : 'PA01MD' redefined.
#endif
#define	PA01MD			0	/* ėpo̓|[g		PO01	*/
#define	PA01IOR			1
#endif
#if PA01_CS5 == 1
#ifdef PA01MD
#error : 'PA01MD' redefined.
#endif
#define	PA01MD			1	/* `bvZNgTo		CS5	*/
#define	PA01IOR			0
#endif
#if PA01_RAS == 1
#ifdef PA01MD
#error : 'PA01MD' redefined.
#endif
#define	PA01MD			2	/* EAhXXg[uo	RAS	*/
#define	PA01IOR			0
#endif
#ifndef PA01MD
#error : 'PA01MD' is not set up.
#endif

/*
 *  |[g`st@NV`
 */
#define VAL_PFC_PAIOR   (PAIOR_BASE | PA15IOR<<15 | PA14IOR<<14 | PA13IOR<<13 | PA12IOR<<12 | PA03IOR<<3 | PA01IOR<<1)
#define VAL_PFC_PACR1   (PACR1_BASE | PA15MD<<14  | PA14MD<<12  | PA13MD<<10  | PA12MD<<8)
#define VAL_PFC_PACR2   (PACR2_BASE | PA03MD<<6   | PA01MD<<2)

/*
 *  |[gast@NV`
 */
#define VAL_PFC_PBIOR   0x107b
#define VAL_PFC_PBCR1   0x14aa
#define VAL_PFC_PBCR2   0x0000
 /*
 *  PNO  I/O PBIOR  PBCR1/2
 *  PB15 IN   [0]    [00] | gp IRQ7 Ɋ蓖āiqsbpj
 *  PB14 |   [0]    [01] | IRQ6 Ɋ蓖āitraRg[pj
 *  PB13 |   [0]    [01] | IRQ5 Ɋ蓖āik`mRg[pj
 *  PB12 OUT  [1]    [00] | LEDCTL3 LED3 [active-low]
 *  PB11 |   [0]    [10] | TDX1 Ɋ蓖āiRS485 f[^ój
 *  PB10 |   [0]    [10] | RDX1 Ɋ蓖āiRS485 f[^́j
 *  PB09 |   [0]    [10] | TDX0 Ɋ蓖āiRS-232C f[^ój
 *  PB08 |   [0]    [10] | RDX0 Ɋ蓖āiRS-232C f[^́j
 *  PB07 IN   [0]    [00] | VAEEPROM-DO
 *  PB06 OUT  [1]    [00] | LEDCTL2 LED2 [active-low]
 *  PB05 OUT  [1]    [00] | TXE0 RS485 MCl[uo͑M~
 *  PB04 OUT  [1]    [00] | VAEEPROM-CS[active-high]
 *  PB03 OUT  [1]    [00] | CTS0 RS232C CTS Mij
 *  PB02 IN   [0]    [00] | RTS0 RS232C RTS Mij
 *  PB01 OUT  [1]    [00] | VAEEPROM-SKARTC-4553-SCK
 *  PB00 OUT  [1]    [00] | VAEEPROM-DIARTC-4553-SIN
 *
 *  PBIOR=0x107b
 *  PBCR1=0x14aa
 *  PBCR2=0x0000
 *
 */

/*
 *  JAhXXg[usRg[`
 */
#define VAL_PFC_CASCR   0x5fff

#ifndef _MACRO_ONLY
/*
 * ֐錾
 */
void	software_init_hook(void);
void	hardware_init_hook(void);

#endif /* _MACRO_ONLY */
#endif	/* _SYS_SUPPORT_H_ */


