/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *	vZbTˑW[ AZuꕔiSH1/2pj
 *@@@@@J[lŎgp`
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 * ^XNRg[ubNTCBsp,pc擪60oCg
 * ͈͓ɂAACg4oCgEɂȂĂ΁A
 * C~fBGCg΃AhbVOŃANZXł
 * TCB_pc,TCB_spoffset.hŒ`Ă
 * (makeɐj
 */

/*  C~fBGCg΃AhbVO\`FbN  */
#define CHECK_IMMEDIATE_ADDRESSING(dst)			\
			((dst <= 60) && ((dst % 4) == 0))

#if CHECK_IMMEDIATE_ADDRESSING(TCB_pc) && 		\
	CHECK_IMMEDIATE_ADDRESSING(TCB_sp)
#define TCB_SHORT
#endif

/*
 * ^XNRg[ubNTCBsp,pc擪128oCg
 * ȍ~ɔzuĂ
 * mov    #TCB_sp,r9
 * ̕g܂ޖ߂͊Ғʂɓ삵Ȃ
 */
#if (TCB_pc > 127) || (TCB_sp > 127)
#error "TCB_pc <= 127 ?"
// ŃAZuG[
#endif

#if !CHECK_IMMEDIATE_ADDRESSING(TCB_texptn)
#error "TCB_texptn ?"
// ŃAZuG[
#endif

/*
 * ̑̃ItZbglɂ
 * 
 * (1) TCB_enatex
 *    mov.b @(#TCB_enatex,rx),r0߂̑l̓[ĝ
 *    TCB_enatexɊւĂ̓`FbNKvȂ
 *    iANZXł͈15oCg𒴂ƁAAZuG[ɂȂj
 * 
 * (2) TCB_enatex_mask
 *    and  #TCB_enatex_mask,r0߂̑l̓[ĝ
 *    TCB_enatex_maskɊւĂ̓`FbNKvȂ
 */


/*
 *  ^XNfBXpb`
 *
 *    @dispatch ́A݁^CPUOlXgJE^ = 0,݋֎~
 *    ŌĂяoȂ΂ȂȂDexit_and_dispatch C݃lXg
 *    JE^ = 0E݋֎~ԂŌĂяôł邪CJ[l
 *    NɑΉ邽߁C݃lXgJE^ = 1ŌĂяoꍇ
 *    ΉĂD
 */

	.text
	.align 2
	.global _dispatch
_dispatch:
				/* pr,r8`r15 X^bNɕۑ           */
	mov.l  r8, @-r15       	/* r0`r7͌ĂяoŕۑĂ邽  */
	mov.l  r9, @-r15        /* ۑKv                    */
	mov.l  r10,@-r15
	mov.l  r11,@-r15
	mov.l  r12,@-r15
	mov.l  r13,@-r15
	mov.l  r14,@-r15
	sts.l  pr,@-r15
	mov.l  _runtsk_dis,r2   /* r0 <- runtsk                          */
	mov.l  @r2,r0
	/*
	 * ^XNRg[ubNTCBsp,pc擪60oCg
	 * ͈͓ɂAACg4oCgEɂȂĂ΁A
	 * C~fBGCg΃AhbVOŃANZXł
	 */
#ifdef TCB_SHORT
				/*  ^XNX^bN|C^ۑ 	*/
	mov.l	r15,@(TCB_sp, r0)
	mov.l   dispatch_r_k,r1  /* sĊJԒn	                */
	bra     dispatcher
	mov.l	r1,@(TCB_pc, r0)	/*  xXbg   		*/
#else	/*  TCB_SHORT  */
	mov    #TCB_sp,r9
	mov.l  r15,@(r0,r9)     /* ^XNX^bNۑ                 */
	mov    #TCB_pc,r8
	mov.l  dispatch_r_k,r1  /* sĊJԒnۑ                   */
	bra    dispatcher
	mov.l  r1,@(r0,r8)	/*  xXbg  			*/
#endif	/* TCB_SHORT */

	/*
	 * dispatch_r:
	 * @^XNRgReLXgŃfBXpb`Ăяoꍇ
	 * @sĊJԒn
	 * @dispatcherĂ΂̂ŁAr7runtskĂ
	 * 
	 * @@WX^蓖
	 * @@@r7 Fruntsk
	 * @@@r0 Fruntsk->enatex
	 * @@@     mov.b @(imm, r),r0߂̓Iyhr0
	 * @@@     Œ肳Ă
	 * @@@r1 Fruntsk->texptn
	 * @@@r2 Fcall_texrtn()̐擪AhX
	 * 
	 */
dispatch_r:
	lds.l  @r15+,pr			/* WX^𕜋A               */
	mov.l  @r15+,r14
	mov.l  @r15+,r13
	mov.l  @r15+,r12
	mov.l  @r15+,r11
	mov.l  @r15+,r10
	mov.l  @r15+,r9
	mov.l  @r15+,r8
	mov.b  @(TCB_enatex,r7),r0	/*  Iyhr0ɌŒ (c)  */
	mov.l  @(TCB_texptn,r7),r1
	and    #TCB_enatex_mask,r0
	tst    r0,r0			/*  runtsk->enatex̃`FbN 	*/
	bt     _dispatch_r_1
	/*  xXbgȂ  */
	tst    r1,r1			/*  runtsk->texptñ`FbN  	*/
	bt     _dispatch_r_1
	/*  xXbgȂ  */
	mov.l  _call_texrtn_dis,r2 /* ^XNO[`N	*/
	jmp    @r2		/*idispatch()ĂяoɃ^[j*/
	nop			/*  xXbg@			*/
_dispatch_r_1:
	rts			/*  dispatch()Ăяoւ̃^[  	*/
	nop			/*  xXbg@			*/


	.global _exit_and_dispatch
_exit_and_dispatch:
				/*  ݃lXgJE^NA  	*/
	mov.l  _intnest_dis, r1
	mov    #0,r0
	mov.l  r0,@r1

/*
 *  fBXpb`{
 *  
 */
dispatcher:
	/*
	 * ɂ͊荞݋֎~ŗ邱
	 */
	mov.l  _schedtsk_dis,r1
	mov.l  _runtsk_dis,r2
	mov.l  @r1,r7		/* r7 <- schedtsk  */
	mov    #0, r0		/* (b) @@@@@@*/

	/*
	 * runtskschedtsk̂͂Q̈ӖB
	 * @(1) schedtsk != NULL̏ꍇ
	 * @@@@ʏ̃^XN؂ւsB
	 * @(2) schedtsk == NULL̏ꍇ
	 * @@@@runtskNULLĂB
	 * @@@@idispatcher_1ȍ~̊ݑ҂Ŋ݂A̒
	 * @@@@@iget_tid()R[ꂽƂɐTSK_NONEԂ
	 * @@@@@ɂ́AsԂ̃^XNȂɁAruntskNULLɂ
	 * @@@@@KvBj
	 */
	mov.l  r7,@r2               /* runtskschedtsk@               */

	cmp/eq r7,r0                /* schedtsk 邩H (a) Q */
	bt     dispatcher_1         /* ΃Wv                 */
	/*  xXbgȂ  */

	/*
	 * ^XNRg[ubNTCBsĊJԒno
	 * 򂷂B
	 * ͈ȉ3
	 * @dispatch_rF^XNReLXg̃fBXpb`Ăяo
	 * @ret_int_r F݂̏o
	 * @activate_rFN
	 * 
	 * @łr7runtsk(=schedtsk)[hĂƂ
	 * @gpėǂ
	 */
#ifdef TCB_SHORT
	/*
	 * ^XNRg[ubNTCBsp,pc擪60oCg
	 * ͈͓ɂAACg4oCgEɂȂĂ΁A
	 * C~fBGCg΃AhbVOŃANZXł
	 */
					/* sĊJԒn𕜋A           */
	mov.l	@(TCB_pc, r7),r1
	jmp     @r1
	mov.l	@(TCB_sp, r7),r15      /*  xXbg		*/
					/* ^XNX^bN|C^𕜌 */
#else	/*  TCB_SHORT  */
	mov    #TCB_pc,r8
	mov.l  @(r7,r8),r1          	/* sĊJԒn𕜋A		*/
	mov    #TCB_sp,r9
	jmp    @r1
	mov.l  @(r7,r9),r15         	/* xXbg			*/
					/* ^XNX^bN|C^𕜌 */
#endif	/* TCB_SHORT */


dispatcher_1:
	/*
	 *  Ŋ݃[hɐ؂芷̂́CŔ銄ݏ
	 *  ɂǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ̈ӖD
	 */


	/* C~fBGCgl𖈉ǂݍނ̂͌̂ŎOɗpӂ
	 * 	r0  : 0x00
	 * 	r1  : 0x01
	 * 	r8  : 荞݋֎~SR̒l   
	 * 	r9  : 荞݋SR̒l
	 * 	r10 : reqflg̔Ԓn
	 * 	r11 : ݃lXgJE^intnest̔Ԓn       
	 */
	mov    #0,r0
	mov    #1,r1
	mov.l  _mask_ipm_dis,r8

#ifdef SUPPORT_CHG_IPM
	mov.l  _task_intmask_dis,r2  /*  ^XNReLXgIPM  */
	mov.l  @r2,r9
#else /* SUPPORT_CHG_IPM */
	mov    #0,r9
#endif /* SUPPORT_CHG_IPM */

	mov.l  _reqflg_dis,r10
	mov.l  _intnest_dis,r11
	    			
	mov.l  _stacktop_dis,r15  /* X^bN݃X^bNɐؑւ */
	mov.l  r1,@r11		  /* ݃lXgJE^Pɂ   */
dispatcher_2:
	ldc    r9,sr		  /* 荞݋                     */

	/*
	 *@Relase1.4.1ŉꂽ
	 *@
	 *@fBXpb`̏oŎsׂ^XNȂ(schedtsk==
	 *@NULLjꍇ́Asleep߂ɂăvZbTȓd̓[hɐ
	 *@ւĊݑ҂ĂB
	 *@
	 *@݋sleep߂sĂ邽߁A݋߂
	 *@sOɊݗvĂꍇi邢͊݋A
	 *@sleepߎsOɊݗvꍇjA݋߂
	 *@sƋɊ݂󂯕tA̕Asleep܂܂
	 *@ȂAreqflg̃`FbNɐi܂ȂB
	 *@i1msecȓɃ^C}݂邽߁Aۂɂsleep܂܂
	 *@Ƃ͂ȂBj
	 *@
	 *@̖́A݂̋sleepԂւ̈ڍsAg~bNɎ
	 *@słȂƂɋNBSH3ȍ~łIPMƂ͕ʂSRBLrbg
	 *@gĊ݂̋֎~/𐧌䂷邱ƂɂA̖
	 *@ł邪ASH1/2łIPMݒ肷ȊOɊ݂֎~^
	 *@@ȂA݋iݑ҂IPMݒjsleepAg
	 *@~bNɍs@ȂB
	 *@SH1ˑł́AݎtɃX^bNɐς܂ꂽ߂
	 *@n𑽏d݂̏oŃ`FbNA߂ԒnLsleep
	 *@߂ɊYꍇ͖߂Ԓn1ߕi2oCgji߂邱Ƃ
	 *@肱̖ĂB
	 *@A̕@ł͑d݂̏oɐ߂̃I[o[
	 *@wbhB
	 *@OMIT_POWER_CONTROL}N`邱Ƃsleep߂̑
	 *@nop߂}Ad݂̏oł̃`FbN[`
	 *@͏ȗBȉꍇ͏d͂̓_ŕsɂȂBj
	 */
#ifndef OMIT_POWER_CONTROL
_waiting_interrupt:
	sleep    		    /* ݑ҂                       */
#else	/*  OMIT_POWER_CONTROL  */
	nop
#endif	/*  OMIT_POWER_CONTROL  */
	ldc    r8,sr		    /* 荞݋֎~                     */
	mov.l  @r10,r2		    /* reqflg̃`FbN   		*/
	tst    r2,r2		    /* FALSEȂ΁A1x荞ݑ҂  */
	bt     dispatcher_2
	/*  xXbgȂ  */
	mov.l  r0,@r10		    /* reqflg̃NA   		*/
	bra    dispatcher
	mov.l  r0,@r11		    /*  xXbg  */
				    /*  ݃lXgJE^NA 	*/

	/*
	 *@ݑ҂̒OɍsX^bNؑւ̖߂sĂȂA
	 *@fBXpb`̏oTCBolX^bN|C
	 *@^ɐݒ肷̂ŖȂB
	 */


	.align 4
_runtsk_dis:
	.long _runtsk
_schedtsk_dis:
	.long _schedtsk
_call_texrtn_dis:
	.long _call_texrtn
_mask_ipm_dis:
	.long MAX_IPM << 4	/* ݋֎~SR̒l  		*/
dispatch_r_k:
	.long dispatch_r
_stacktop_dis:
	.long STACKTOP		/* ^XNƗ̃X^bN̏l	*/

_intnest_dis:	  		/* ݁^CPUOlXgJE^  	*/
	.long _intnest
_reqflg_dis:
	.long _reqflg

#ifdef SUPPORT_CHG_IPM
_task_intmask_dis:		/* ^XNReLXg̊݃}XN   	*/
	.long _task_intmask
#endif /* SUPPORT_CHG_IPM */


/*
 *  ݁^CPUO̓
 */

/*
 *  ݁^CPUO̍ۂ̃X^bN|C^wʒu
 *@SR,PC̃Rs[ꏊ܂ł̃ItZbg
 *@@@@
 *@@@łX^bN|C^Ƃ͊݁^CPUO̓
 *@@@vV[WWX^PȒޔI̒lӖB
 *@@@SR̓X^bN擪40oCgɁAPC36oCgɐς܂
 *@@@B@@iret_int_3QƁj
 */
#define	SP_SR_OFFSET	40
#define	SP_PC_OFFSET	36

/*
 *  CPUO̓̑
 *
 *  CPUOnh́C^XNReLXgŎsD̂߁CCPU
 *  OnhĂяoOɊ݃[hɈڍsC^[Ă
 *  ̃[hɖ߂D̃[hɖ߂߂ɁC݃[hɈڍsO
 *   SR ݃X^bNɕۑDCPUO^XNReLXg
 *  Creqflg  TRUE ɂȂɁCret_exc ֕򂷂D
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 *  @
 *  ʕs߂̏ꍇ͖߂Ԓn2oCgi߂Kv邪
 *  ΉĂȂ
 *  iGDB stubu[N|CgƂĎgpBj
 *  @
 * @@CPUOvɓWJ郋[`r0,r1ۑA
 * @@݋֎~ɂA
 *@@@@r1FݎtSR̃Rs[
 *@@@@r2FCꃋ[`̐擪AhX
 * @@̏ԂłɗB
 * @@
 * @@WX^
 * @@@r4FCꃋ[`̈
 * @@@@@X^bNɐς܂ꂽSR̃AhX
 * @@@r7F^XNX^bN|C^
 */
	.text
	.align 2
	.globl _cpu_exception_entry
_cpu_exception_entry:
			/*  c̃XNb`WX^X^bNɐςށ@	*/
	mov.l	r3,@-r15
	mov.l	r4,@-r15
	mov.l	r5,@-r15
	mov.l	r6,@-r15
	mov.l	r7,@-r15
	sts.l	pr,@-r15
	mov	r15,r4		/*  Cꃋ[`̈ݒ  		*/
	add	#SP_SR_OFFSET, r4
			/*  ݁^CPUOlXgJE^̃`FbN 	*/
	mov.l	_intnest_int, r5
	mov.l	@r5,r6
	tst     r6,r6   	/* CPUÕReLXg𔻒  	*/
	add	#0x1,r6		/* ݃lXgJE^CNg */
				/*  add߂łsrTrbg͕ωȂ	*/
	mov.l	r6,@r5
				/* dOȂWv   		*/
	bf	_exc_from_int
	/*  xXbgȂ  */					
									
/* 	iCPUȌꍇ 						*/
				/* X^bNւO			*/
				/* ^XNX^bN|C^ۑ        	*/
	mov     r15,r7
				/* ݃X^bNɐ؂ւ		*/
	mov.l   _stacktop_int,r15
	ldc  	r1,sr		/*  ݋  */			
	jsr	@r2		/* Cꃋ[`Ăяo		*/
	mov.l	r7,@-r15 	/*  xXbg@  			*/
				/*    ^XNX^bN|C^		*/
				/*    ݃X^bNɐς  		*/
									
				/*  ݋֎~		*/		
	mov.l	_mask_ipm_int,r0
	ldc	r0,sr
				/* /CPUOlXgJE^NA */
	mov.l	_intnest_int,r0
	mov	#0x0,r1
	mov.l	r1,@r0
	mov.l	@r15,r15	/* X^bNؑւ  			*/
				/* reqflg̃`FbN                    	*/
	mov.l	_reqflg_int,r4
        mov.l	@r4,r5
	tst	r5,r5
	bt   	1f		/*  reqflg=FALSȄꍇret_to_task_exc */
	/*  xXbgȂ  */					
	bra	ret_exc		/*  reqflg=TRUȄꍇret_exc	*/
	nop			/*  xXbg 			*/

	/*
	 *@bt߂łret_to_task_excɓ͂Ȃ̂ŁAbra߂PNbV
	 *@B
	 */
1:									
	bra	ret_to_task_exc	/*  reqflg=FALSȄꍇ			*/
	nop			/*  xXbg 			*/


/* dCPUȌꍇ 							*/
/* 	CPUÕReLXg𔻕ʌA 				*/
/*   		݋֎~ 						*/
/*   		r1Fݎtsr̃Rs[ 				*/
/*   		r2FCꃋ[`̐擪AhX				*/
/*   		r4FCꃋ[`̈					*/
/* 	̏Ԃłɔł 					*/
/* 	Cꃋ[`̈ݒƊ݃lXgJE^ 		*/
/* 	CNg͍ςł 					*/
									
_exc_from_int:
	jsr	@r2			/*  Cꃋ[`Ăяo 	*/
	ldc	r1,sr			/*  ݋ixXbgj	*/
									
	mov.l	_mask_ipm_int,r0	/*  ݋֎~			*/
	ldc	r0,sr
		/* ݁^CPUOlXgJE^fBNg	*/
	mov.l	_intnest_int,r3
	mov.l	@r3,r4
	add	#-1,r4
	bra	_ret_to_exc
	mov.l	r4,@r3		/*  xXbg 			*/


/*
 *  ݂̌̑
 *
 * @@ݗvɓWJ郋[`r0,r1ۑA
 * @@݋֎~ɂA
 *@@@@r1FݎtSR̃Rs[
 *@@@@r2FCꃋ[`̐擪AhX
 * @@̏ԂłɗB
 * @@
 * @@WX^
 * @@@r7F^XNX^bN|C^
 */
	.text
	.align 2
	.globl _interrupt_entry
_interrupt_entry:
			/*  c̃XNb`WX^X^bNɐςށ@	*/
	mov.l	r3,@-r15
	mov.l	r4,@-r15
	mov.l	r5,@-r15
	mov.l	r6,@-r15
	mov.l	r7,@-r15
	sts.l	pr,@-r15
			/*  ݁^CPUOlXgJE^̃`FbN 	*/
	mov.l	_intnest_int, r5
	mov.l	@r5,r6
	tst     r6,r6   	/* ݔ̃ReLXg𔻒  	*/
	add	#0x1,r6		/* ݃lXgJE^CNg */
				/*  add߂łsrTrbg͕ωȂ	*/
	mov.l	r6,@r5
				/* d݂ȂWv   		*/
	bf	_interrupt_from_int
	/*  xXbgȂ  */					
									
/* 	i݂̊̏ꍇ 						*/
				/* X^bNւO			*/
				/* ^XNX^bN|C^ۑ        	*/
	mov     r15,r7
				/* ݃X^bNɐ؂ւ		*/
	mov.l   _stacktop_int,r15
	ldc  	r1,sr		/*  ݋  */			
	jsr	@r2		/* Cꃋ[`Ăяo		*/
	mov.l	r7,@-r15 	/*  xXbg@  			*/
				/*    ^XNX^bN|C^		*/
				/*    ݃X^bNɐς  		*/
									
				/*  ݋֎~		*/		
	mov.l	_mask_ipm_int,r0
	ldc	r0,sr
				/* ݁^CPUOlXgJE^NA*/
	mov.l	_intnest_int,r0
	mov	#0x0,r1
	mov.l	r1,@r0
	mov.l	@r15,r15	/* X^bNؑւ  			*/
				/* reqflg̃`FbN                    	*/
	mov.l	_reqflg_int,r4
        mov.l	@r4,r5
	tst	r5,r5
	bt   	ret_to_task_int	/*  reqflg=FALSȄꍇ 			*/
	/*  xXbgȂ  */					
	bra	ret_int		/*  reqflg=TRUȄꍇ			*/
	nop			/*  xXbg 			*/

										
/* d݂̏ꍇ 							*/
/* 	ݔ̃ReLXg𔻕ʌA 				*/
/*   		݋֎~ 						*/
/*   		r1Fݎtsr̃Rs[ 				*/
/*   		r2FCꃋ[`̐擪AhX				*/
/* 	̏Ԃłɔł 					*/
/* 	i݃lXgJE^̃CNg͍ςłj 		*/
									
_interrupt_from_int:
	jsr	@r2			/*  Cꃋ[`Ăяo 	*/
	ldc	r1,sr			/*  ݋ixXbgj	*/
									
	mov.l	_mask_ipm_int,r0	/*  ݋֎~			*/
	ldc	r0,sr
		/* ݁^CPUOlXgJE^fBNg	*/
	mov.l	_intnest_int,r3
	mov.l	@r3,r4
	add	#-1,r4
	mov.l	r4,@r3


/*   d݁^CPUO̕A
 *
 *   	EfBXpb`^XNOKvȂ
 * 	Echg_ipm()͕̏KvȂ
 * 	@i^XNReLXgł́Achg_ipm()͎gpsj
 *
 *
 *    fBXpb`̏oŎsׂ^XNȂ(schedtsk==NULLjꍇ
 *    ́Asleep߂ɂăvZbTȓd̓[hɐ؂ւĊݑ
 *    ĂBidispatcher_2t߂QƁj
 *    
 *    ݋sleep߂sĂ邽߁A݋߂̎sO
 *    ɊݗvĂꍇi邢͊݋Asleepߎ
 *    sOɊݗvꍇjA݋߂̎sƋɊ݂
 *    󂯕tA̕Asleep܂܂ɂȂĂ܂B
 *    ireqflg̃`FbNɐi܂ȂBj̖́A݂̋sleep 
 *    Ԃւ̈ڍsAg~bNɎsłȂƂɋNB
 *    h߁Ȁ݂oŖ߂AhXsleep߂ł
 *    ꍇA߂Ԓn1ߕi߂鏈ĂBisׂ^XN
 *    ȂAfBXpbeŊݑ҂Ɋ݂󂯕tꍇ́A
 *    fBXpb`̓dĂяo邽߁Ad݂Ƃď
 *    邽߁AL_ret_to_intʉ߂B
 */
_ret_to_int:
_ret_to_exc:

#ifndef OMIT_POWER_CONTROL
				/*  r4X^bNɐς܂ꂽ߂Ԓn	*/
	mov.l	@(SP_PC_OFFSET, r15), r4
	mov.l	_waiting_interrupt_int, r5
	cmp/eq	r4, r5
	bf	_ret_to_int_1
	add	#2, r4
	mov.l	r4, @(SP_PC_OFFSET, r15)
#endif	/*  OMIT_POWER_CONTROL  */

_ret_to_int_1:
	lds.l	@r15+,pr    	/*  WX^  			*/
	mov.l	@r15+,r7
	mov.l	@r15+,r6
	mov.l	@r15+,r5
	mov.l	@r15+,r4
	mov.l	@r15+,r3
	mov.l	@r15+,r2
	mov.l	@r15+,r1
	mov.l	@r15+,r0
	rte		    	/*  ݌ɖ߂  			*/
	nop
									
	.align 4
_stacktop_int:			/* ^XNƗ̃X^bN̏l  	*/
	.long  STACKTOP
_intnest_int:	    		/*  ݁^CPUOlXgJE^  	*/
	.long  _intnest
_reqflg_int:
	.long  _reqflg
_mask_ipm_int:	    		/*  ݋֎~p}XN  		*/
	.long  MAX_IPM << 4	/*  ipmȊÕrbg̓[ŗǂ	*/

#ifndef OMIT_POWER_CONTROL
_waiting_interrupt_int:
	.long  _waiting_interrupt
#endif	/*  OMIT_POWER_CONTROL  */

/*
 *  ݃nh/CPUOnho
 *
 * ߂悪^XNreqflgZbgĂꍇ݂̂ɂB
 * ݃lXgJE^ = 0,݋֎~,XNb`WX^
 * ۑԂŌĂяoƁB
 *
 * r4ɂ͕ϐreqflg̃AhXꂽԂłɗB
 *
 */
	.text
	.align 2
ret_int:
ret_exc:
	/*
	 *@߂悪݂̓ۂ̔
	 *@
	 *@SH1ł͊ݎtɊ݋֎~ɂȂĂȂ߁AA
	 *@̓ɕʂ̊B\Bi̓n[h
	 *@EFÃA[LeN`悤ȂBj݃nhB
	 *@Ń^XN؂ւN悤ȃT[rXR[ĂԂƊB
	 *@̏oŕʂ̃^XNɃfBXpb`Ă܂A^XN2
	 *@̃^XNɖ߂Ă܂ŁAȀxĂ܂B
	 *@܂AAxgK2񌟏oĂ܂B
	 *@h߁AX^bNɐςł߂IPMtask_intmask
	 *@̒lrāAɊ݂Ȃ`FbN
	 *@ĂBfBXpb`Õ^C~OŔʂĂ̂ŁA
	 *@chg_ipm()task_intmaskĂSz͂ȂB
	 */
				/*  	r0X^bNɐς܂ꂽsr  	*/
	mov.l  @(SP_SR_OFFSET,r15),r0
#ifdef SUPPORT_CHG_IPM
	mov.l  _task_intmask_ret,r2 /*  r2&task_intmask  		*/
	and    #0xf0, r0	/*  	IPMo  			*/
	mov.l  @r2,r3		/*  	r3task_intmask  		*/
	cmp/eq r0, r3		/*  	߂悪݂̓H 	*/
#else /* SUPPORT_CHG_IPM */
	/*
	 *@chg_ipmT|[gȂꍇ́A^XNReLXgIPM
	 *@0x0
	 */
	and    #0xf0, r0	/*  	IPMo  			*/
	cmp/eq #0x00, r0	/*  	߂悪݂̓H 	*/
#endif /* SUPPORT_CHG_IPM */
	bf     ret_to_task_int	/*    	fBXpb`ȂŊ݌	*/
				/*	߂鏈			*/
	/*  xXbgȂ  */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
	/*
	 *@߂悪CPUO̓ۂ̔
	 *@
	 *@SH1łCPUO݂ƂقړosĂ邪A
	 *@CPUO󂯕tĂ݃}XN͕ωȂBCPUO̓
	 *@Ɋ݂ꍇɔāAX^bNɐς܂ꂽ
	 *@߂ԒngĔʂsB
	 *@
	 *@
	 *@@check_exc_entry()API
	 *@@@r4FX^bNɐς܂ꂽ߂Ԓn
	 *@@@߂lr0F
	 *@@@@@1F߂悪CPUO̓
	 *@@@@@0FȊO
	 */
	mov.l	_check_exc_entry_ret, r1
	jsr	@r1			/*  Cꃋ[`Ăяo  	*/
	mov.l	@(SP_PC_OFFSET, r15), r4 /* ݒixXbgj  	*/
	
	tst	r0, r0		/*  ߂l̔  */
	bf     ret_to_task_int	/*    ߂悪CPUO̓ł  */
				/*@@fBXpb`ȂŊ݌ɖ߂ */
	/*  xXbgȂ  */

#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */

	/*  
	 *@reqflg̃NA
	 *@
	 *@ɓBOreqflgNAĂ܂ƁAL̊A
	 *@̏oŃfBXpb`ĂяoKvȃP[XłfBX
	 *@pb`ĂяoȂB
	 *@iBreqflgZbgāAAreqflgɕωȂ
	 *@@j
	 */
	mov	#0x0, r0
	mov.l  _reqflg_ret,r1
	mov.l	r0, @r1		/* reqflg <- 0			   */ 
	
	mov.l  _runtsk_ret,r1   /* r7 <- runtsk                    */
	mov.l  @r1,r7
	mov.l  _enadsp_ret,r2   /* enadsp̃`FbN                */
	mov.l  @r2,r3
	tst    r3,r3		/* fBXpb`֎~Ȃret_int_1 */
	bt     ret_int_1
	/*  xXbgȂ  */

	mov.l  _schedtsk_ret,r4 /* r5 <- schedtsk                  */
	mov.l  @r4,r5
	cmp/eq r7,r5            /* runtsk  schedtsk r       */
	bt     ret_int_1	/*  Ȃret_int_1  	   */
	/*  xXbgȂ  */

        mov.l  r8,@-r15        	/* c̃WX^ۑ            */
        mov.l  r9,@-r15
        mov.l  r10,@-r15
        mov.l  r11,@-r15
        mov.l  r12,@-r15
        mov.l  r13,@-r15
        mov.l  r14,@-r15
	sts.l  mach,@-r15
	sts.l  macl,@-r15
	stc.l  gbr,@-r15
	/*
	 * ^XNRg[ubNTCBsp,pc擪60oCg
	 * ͈͓ɂAACg4oCgEɂȂĂ΁A
	 * C~fBGCg΃AhbVOŃANZXł
	 */
#ifdef TCB_SHORT
				/*  ^XNX^bN|C^ۑ  */
	mov.l  r15,@(TCB_sp, r7)
	mov.l  ret_int_r_ret,r1	/* sĊJԒn             	  */
	bra    dispatcher
	mov.l  r1,@(TCB_pc, r7)	/*  xXbg@*/

#else	/*  TCB_SHORT  */
	mov    #TCB_sp,r1      	/* ^XNX^bNۑ           */
	mov.l  r15,@(r7,r1)
	mov.l  ret_int_r_ret,r1	/* sĊJԒnۑ             */
	mov    #TCB_pc,r2	/*  fBXpb`̖߂  */
				/*  ret_int_rɐݒ  		@*/
	bra    dispatcher
	mov.l  r1,@(r7,r2)	/*  xXbg 		  */
#endif	/* TCB_SHORT */

/*
 *  ݂̏oŃfBXpb`炱ɖ߂Ă
 *    r7runtskꂽԂłɗ
 */
ret_int_r:
	ldc.l  @r15+,gbr       /* WX^𕜋A                  */
	lds.l  @r15+,macl
	lds.l  @r15+,mach
	mov.l  @r15+,r14
	mov.l  @r15+,r13
	mov.l  @r15+,r12
	mov.l  @r15+,r11
	mov.l  @r15+,r10
	mov.l  @r15+,r9
	mov.l  @r15+,r8

	/*
	 * fBXpb`ret_int_rɕ򂵂ꍇA
	 * ret_int璼ڂɕ򂵂ꍇA
	 * ̏ꍇAr7runtskĂ
	 *
	 *@ WX^蓖
	 * 	r7  : runtsk
	 * 	r0  : runtsk->enatex
	 * @@@     mov.b @(imm, r),r0߂̓Iyhr0
	 * @@@     Œ肳Ă
	 * 	r2  : runtsk->texptn
	 * 	r3  : call_texrtn()̐擪Ԓn
	 */
ret_int_1:
	mov.b  @(TCB_enatex,r7),r0	/*  Iyhr0ɌŒ (d) */
	and    #TCB_enatex_mask,r0
	tst    r0,r0			/*  runtsk->enatex̃`FbN  	*/
	bt     ret_int_2
	/*  xXbgȂ  */
	mov.l  @(TCB_texptn,r7),r2	/*  runtsk->texptñ`FbN  	*/
	tst    r2,r2
	bt     ret_int_2
	/*  xXbgȂ  */
	mov.l  _call_texrtn_ret,r3 	/* ^XNO[`N	*/
	jsr    @r3
	nop				/*  xXbg		*/

ret_int_2:
#ifdef SUPPORT_CHG_IPM
	/*
	 *@SH1ł݂͊̃^[߂Ńn[hEFAX^bN
	 *@̃f[^ǂݏoSR𕜌B
	 *@݂ɂĕʂ̃^XNɐ؂ւꍇ́A^XNRe
	 *@LXgIPMύXĂ\̂ŃX^bNSR
	 *@̃Rs[Ɋ܂܂IPMXVĂKvB
	 */
				/*  	r0X^bNɐς܂ꂽsr  	*/
	mov.l  @(SP_SR_OFFSET,r15),r0
	mov.l  _unmask_ipm_ret,r1
	mov.l  _task_intmask_ret,r2 /*  r2&task_intmask  		*/
	and    r1,r0		/*  	IPMrbgNA 	 	*/
	mov.l  @r2,r3		/*  	r3task_intmask  		*/
	or     r3,r0		/*  	IPMrbgZbg 	 	*/
				/*  X^bNɐςłsrɏ㏑  	*/
	mov.l  r0,@(SP_SR_OFFSET,r15)
#endif /* SUPPORT_CHG_IPM */

	/*
	 *@^XNւ̕A
	 *@@fBXpb`ĂяovȂꍇ͂獇B
	 *@@̓rŊ݂ꍇ́A߂
	 *@@ȂB
	 */
ret_to_task_int:
ret_to_task_exc:
				/* pr,XNb`WX^𕜋A 		*/
				/*  X^bN̐擪̃ItZbg  	*/
	lds.l  @r15+,pr		/*   +0:PR  */
	mov.l  @r15+,r7		/*   +4:r7  */
	mov.l  @r15+,r6		/*   +8:r6  */
	mov.l  @r15+,r5		/*  +12:r5  */
	mov.l  @r15+,r4		/*  +16:r4  */
	mov.l  @r15+,r3		/*  +20:r3  */
	mov.l  @r15+,r2		/*  +24:r2  */
	mov.l  @r15+,r1		/*  +28:r1  */
	mov.l  @r15+,r0		/*  +32:r0  */
				/*  +36:PC  */
				/*  +40:SR  */
	rte
	nop			/*  xXbg  */
	.align 4
_reqflg_ret:
	.long  _reqflg
_call_texrtn_ret:
	.long _call_texrtn
_runtsk_ret:
	.long _runtsk
_schedtsk_ret:
	.long _schedtsk
_enadsp_ret:
	.long _enadsp
ret_int_r_ret:
	.long ret_int_r

#ifdef SUPPORT_CHG_IPM		/*  chg_ipm()T|[gꍇ */
_unmask_ipm_ret:
	.long  ~0xf0		/*  ipmrbgȊOׂĂP  */
_task_intmask_ret:
	.long _task_intmask
#endif /* SUPPORT_CHG_IPM */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
_check_exc_entry_ret:
	.long _check_cpu_exc_entry
#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */


/*
 *  no_reg_exception()
 *  CPUOƂēo^ĂȂOƌĂяo
 *  O_pc,sr,pr,r0`15o͂ăJ[l
 *  ~B
 */
	.text
	.align 2
	.globl _no_reg_exception
_no_reg_exception:
				/*  pr,r0`15ۑ  */
	sts.l  pr, @-r15
	mov.l  r15,@-r15
	mov.l  r14,@-r15
	mov.l  r13,@-r15
	mov.l  r12,@-r15
	mov.l  r11,@-r15
	mov.l  r10,@-r15
	mov.l  r9, @-r15
	mov.l  r8, @-r15
	mov.l  r7, @-r15
	mov.l  r6, @-r15
	mov.l  r5, @-r15
	mov.l  r4, @-r15
	mov.l  r3, @-r15
	mov.l  r2, @-r15
	mov.l  r1, @-r15
	mov.l  r0, @-r15

				/*  cpu_experr()̌Ăяo  	*/
	mov.l  _cpu_experr_k,r1	/*  (cpu_config.c)  		*/
	jsr    @r1
	mov    r15, r4		/*  ݒixXbgj	*/

	.align 4
_cpu_experr_k:
	.long  _cpu_experr



/*  C~fBGCg΃AhbVO\`FbN  */
#if !(CHECK_IMMEDIATE_ADDRESSING(TCB_tinib) 			\
	&& CHECK_IMMEDIATE_ADDRESSING(TINIB_task)		\
	&& CHECK_IMMEDIATE_ADDRESSING(TINIB_exinf) )

ŃAZuEG[
#endif


/*
 *  ^XNN
 *  @@dispatcherĂ΂̂ŁAr7runtskĂ
 *  
 */
	.text
	.align 2
	.globl _activate_r
_activate_r:
				/* 荞݋̏ 		*/
#ifndef SUPPORT_CHG_IPM		/*  it_unlock_cpȕj 	*/
	mov   #0,r1		/*  IPMȊÕrbgj󂳂 */
#else  /* SUPPORT_CHG_IPM */
        mov.l _task_intmask_act,r2
	mov.l @r2,r1
#endif /* SUPPORT_CHG_IPM */
	ldc   r1,sr		/*  ݋  		*/
	mov.l _ext_tsk_act,r3
	lds   r3,pr		/*  ^XN̖߂Ԓnݒ  */

	/*
	 *  Ŋ݂runtskĂA
	 *  ̃^XNɖ߂ĂƂɂruntsk̒l
	 *  RAɖ߂Ă
	 * 
	 *   WX^蓖
	 * @@r7Fruntsk
	 * @@r1F&(runtsk->tinib)
	 * @@r2Fruntsk->tinib->task
	 * @@r4F^XN̊gij
	 */
	mov.l @(TCB_tinib,r7),r1
	mov.l @(TINIB_task,r1),r2	/*  ^XNNԒn  	*/
	jmp   @r2		/* jsr߂łprj󂵂Ă܂*/
	mov.l @(TINIB_exinf,r1),r4	/*  xXbg  	*/
				/*  gi^XNւ̈j  */
	.align 4
_ext_tsk_act:
	.long _ext_tsk

#ifdef SUPPORT_CHG_IPM
_task_intmask_act:
	.long _task_intmask
#endif /* SUPPORT_CHG_IPM */

/*
 *  ԑ҂
 */
	.globl _sil_dly_nse
_sil_dly_nse:

    mov.l  _sil_dly_tim1, r1	/* r4 SIL_DLY_TIM1  */
    add    r1, r4
    cmp/pl r4			/* ʂ 0 ȉȂ烊^[ */
    bt     _sil_dly_nse1
    /*  xXbgȂ  */
    rts
    nop
_sil_dly_nse1:            
    mov.l  _sil_dly_tim2, r1	/* r4 SIL_DLY_TIM2  */
    add    r1, r4
    cmp/pl r4			/* ʂ 0 ȉȂ烊^[ */
    bt     _sil_dly_nse1
    /*  xXbgȂ  */
    rts
    nop   
    .align 4
_sil_dly_tim1:
    .long  -SIL_DLY_TIM1    
_sil_dly_tim2:                         
    .long  -SIL_DLY_TIM2


/*
 * Y^
 * @@dispatcher(a)scmp/eq imm,r0߂gȂR
 * @@
 *@@@dispatcherr7runtsk̒lAdispatch_rA
 *@@@ret_int_rAactivate_rł͖ʂȃ[hȂ悤ɂĂ
 *@@@B
 *@@@schedtsk̗L`FbNƂcmp/eq imm,r0߁i(a)
 *@@@sjIyhr0ɌŒ肳Ă邽߁Aɍ킹āA
 *@@@ŏruntskr0蓖ĂĂB
 *@@@Ar0͊eɂenatex̓ǂݏo(c),(d)smov.b
 *@@@߂ł\񂵂Ă邽߁Ał΋󂯂ĂB
 *@@@imov.b @(imm, r),r0߂̓Iyhr0ɌŒ肳ĂBj
 *@@@]āAruntskr7Ɋ蓖āA(a)scmp/eq imm,r0߂
 *@@@cmp/eq rn,rm߂ɕύXB̂߁AWX^0
 *@@@߁i(b)sjP]ɓĂB
 *
 *@@@Amov.l @(imm, r),r0߂̓Iyhr0ɌŒ肳
 *@@@ȂB
 *@@@SH3ł̂悤makeoffset.cŃxBIT_BWw肷΁A4o
 *@@@CgPʂŃItZbgƃ}XN̂ŁAmov.l߂
 *@@@gAWX^tyɂȂ邪Aenatex莞̃}XNf[
 *@@@^and߂̃C~fBG[glɎ܂؂ȂȂ邽߁A
 *@@@[h߂P]ɓB
 *@@@ǂ꒷Z邪AɂAruntskă[h
 *@@@̓}VƎvB
 */
