/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 *@@VAI/OfoCXiSIO/SCIFjhCoiHSB7615ITpj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include "sh7615scif.h"
#endif /* _MACRO_ONLY */

/*
 *  SIO/SCIF̊݃nh̃xN^ԍ
 */
/* o̓|[g̐ݒsys_config.c */
/* ݃xN^ԍ̐ݒhw_serial.h */
/* ǗubN̐ݒsh7615scif.c */

#ifndef GDB_STUB

#define INHNO_SERIAL_IN	 RXI1
#define INHNO_SERIAL_OUT TXI1
#define INHNO_SERIAL_ERROR ERI1
#define INHNO_SERIAL_BRK BRI1
#if TNUM_PORT >= 2
#define INHNO_SERIAL2_IN	 RXI2
#define INHNO_SERIAL2_OUT TXI2
#define INHNO_SERIAL2_ERROR ERI2
#define INHNO_SERIAL2_BRK BRI2
#endif /* TNUM_PORT >= 2 */

#else	/*  GDB_STUB  */

#define INHNO_SERIAL_IN	 RXI2
#define INHNO_SERIAL_OUT TXI2
#define INHNO_SERIAL_ERROR ERI2
#define INHNO_SERIAL_BRK BRI2

#endif	/*  GDB_STUB  */

/*
 * SCI̊荞݃x
 * @݃nh͑MʁXɓo^ł邪A݃x
 * @MMxɂݒłȂB
 */
#define LEVEL0		0			/*  ݉̃x  */

#ifndef _MACRO_ONLY

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize	sh2scif_initialize

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  I[v|[g邩 openflag ɓǂłD
	 */
	openflag = sh2scif_openflag (siopid);

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = sh2scif_opn_por(siopid, exinf);

	/*
	 *  ݃Rg[ˑ
	 *  @VAI/O݂̊݃xݒ肷
	 */
	if (!openflag) {
		if (siopcb->siopinib->reg_base == 0xfffffcc0)
			define_int_plevel (IPRD, siopcb->siopinib->int_level, 0);
		if ((siopcb->siopinib->reg_base) == 0xfffffce0)
			define_int_plevel (IPRE, siopcb->siopinib->int_level, 12);
	}
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[YD
	 */
	sh2scif_cls_por(siopcb);

	/*
	 *  VAI/O݃xŒ჌xɂ
	 */
		if (siopcb->siopinib->reg_base == 0xfffffcc0)
			define_int_plevel (IPRD, LEVEL0, 0);
		if ((siopcb->siopinib->reg_base) == 0xfffffce0)
			define_int_plevel (IPRE, LEVEL0, 12);

}

/*
 *  SIO/SCIF̊݃nh
 */
#define	sio_handler_in	sh2scif_isr_in	/*  M݃nh  */
#define	sio_handler_out	sh2scif_isr_out	/*  M݃nh  */
#define	sio_handler_error sh2scif_isr_error	/*  MG[݃nh  */
#define	sio_handler_brk	sh2scif_isr_brk	/*  u[No݃nh  */
#if TNUM_PORT >= 2
#define	sio_handler2_in		sh2scif_isr2_in	/*  M݃nh  */
#define	sio_handler2_out	sh2scif_isr2_out	/*  M݃nh  */
#define	sio_handler2_error	sh2scif_isr2_error	/*  MG[݃nh  */
#define	sio_handler2_brk	sh2scif_isr2_brk	/*  u[No݃nh  */
#endif /* TNUM_PORT >= 2 */

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr	sh2scif_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr	sh2scif_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr	sh2scif_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr	sh2scif_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 *  @@jsp/systask/serial.cɂ̂l[Ă
 *  @@ȋOQƁj
 */
#define	sio_ierdy_snd	sh2scif_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 *  @@jsp/systask/serial.cɂ̂l[Ă
 *  @@ȋOQƁj
 */
#define	sio_ierdy_rcv	sh2scif_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
