/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh7145cmt.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *	^C}hCo
 *  CMTgp
 */

#ifndef _SH7145CMT_H_
#define _SH7145CMT_H_

/*
 *   ^C}ւ̓̓NbN̕ݒ
 *   	f/8ŃJEg
 */
#define TCR_CKS         0x0

/*
 *   ^C}ɋNbNg[kHz]
 *      12.288MHz*2/8 = 3,072kHz
 */
#define TIMER_CLOCK     3072


/*
 *  ^C}l̓\̌^
 */
typedef UH CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define	GET_TOLERANCE	100		/* x̌ςliPʂ͓\j */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  Rg[WX^̃AhX
 */
#define CMSTR	(VH *)0xffff83d0
#define CMCSR_0	(VH *)0xffff83d2
#define CMCNT_0	(VH *)0xffff83d4
#define CMCOR_0	(VH *)0xffff83d6


#ifndef _MACRO_ONLY
/*
 *  ^C}X^[g
 */
Inline void
sh2_timer_start ()
{
	sil_wrh_mem (CMSTR, sil_reh_mem (CMSTR) | 0x0001);
}

/*
 *  ^C}ꎞ~
 */
Inline void
sh2_timer_stop ()
{
    	/* ^C}~ 	  */
	sil_wrh_mem (CMSTR, sil_reh_mem (CMSTR) & ~0x0001);
}

/*
 *  ^C}ݗṽNA
 *	TCRWX^IMFArbg1ǂݏoɂO
 */
Inline void
sh2_timer_int_clear ()
{
	/* 荞ݗvNA     */
	sil_wrh_mem (CMCSR_0, sil_reh_mem (CMCSR_0) & ~0x0080);
				/* CMFRyA}b`tÕNA */
}


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
sh2_timer_initialize ()
{
	CLOCK cyc = TO_CLOCK (TIC_NUME, TIC_DENO);


	sil_wrh_mem (MSTCR2, (sil_reh_mem(MSTCR2)& ~0x0100));
	/*
	 *  ^C}֘A̐ݒ
	 */
	sh2_timer_stop ();			/* ^C}~ */
	/* ^C}l̃`FbN */
	assert (cyc <= MAX_CLOCK);

	/*  ݒ  clock 1/8  A荞݋֎~ */
    sil_wrh_mem(CMCSR_0,0x0000);
	/*  CMCOR0WX^ݒiJE^ڕWlj      */
	sil_wrh_mem (CMCOR_0,(VH)CLOCK_PER_TICK);
	/* JE^NA             */
	sil_wrh_mem (CMCNT_0,0x0000);
	sil_wrh_mem (CMCSR_0, sil_reh_mem(CMCSR_0) | 0x0040);	/* 荞݋ */
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
sh2_timer_terminate ()
{
	sh2_timer_stop ();			/* ^C}~     */
	sh2_timer_int_clear ();		/* 荞ݗvNA */

	sil_wrh_mem (CMCSR_0, sil_reh_mem(CMCSR_0) & ~0x0040);	//荞ݕs
	sil_wrh_mem (CMCNT_0,0x0000);
	sil_wrh_mem (CMCOR_0,0x0000);
	sil_wrh_mem (MSTCR2, (sil_reh_mem(MSTCR2) | 0x0100));
}

/*
 *  ^C}̌ݒl̓Ǐo
 *@@@^C}̓ꎞIɒ~C^C}lǂݏoD
 */
Inline CLOCK
sh2_timer_get_current ()
{
	CLOCK	clk;
/* SH1Ɠ */
	sh2_timer_stop ();			/*  ^C}~  */

	/*  {͑҂Ԃׂ  */

	clk = sil_reh_mem(CMCNT_0);
	sh2_timer_start();			/*  ^C}X^[g  */
	
	return(clk);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
sh2_timer_fetch_interrupt ()
{
	return (sil_reh_mem (CMCSR_0) & 0x0080);
}

#endif /* _MACRO_ONLY */
#endif /* _SH7145CMT_H_ */
